/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc;

import java.io.File;
import org.apache.kerby.kerberos.kdc.impl.NettyKdcServerImpl;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadminImpl;
import org.apache.kerby.kerberos.kerb.server.KdcServer;
import org.apache.kerby.kerberos.kerb.server.impl.InternalKdcServer;
import org.apache.kerby.util.OSUtil;

public class KerbyKdcServer
extends KdcServer {
    private static final String USAGE = (OSUtil.isWindows() ? "Usage: bin\\start-kdc.cmd" : "Usage: sh bin/start-kdc.sh") + " <conf-dir> <working-dir> \n\tExample:\n\t\t" + (OSUtil.isWindows() ? "bin\\start-kdc.cmd" : "sh bin/start-kdc.sh") + " conf runtime\n";

    public KerbyKdcServer(File confDir) throws KrbException {
        super(confDir);
        this.setInnerKdcImpl((InternalKdcServer)new NettyKdcServerImpl(this.getKdcSetting()));
    }

    public void init() throws KrbException {
        super.init();
        LocalKadminImpl kadmin = new LocalKadminImpl(this.getKdcSetting(), this.getIdentityService());
        kadmin.checkBuiltinPrincipals();
    }

    public static void main(String[] args) throws KrbException {
        File workDir;
        if (args.length != 3) {
            System.err.println(USAGE);
            System.exit(1);
        }
        if (!args[0].equals("-start")) {
            System.err.println(USAGE);
            System.exit(2);
        }
        String confDirPath = args[1];
        String workDirPath = args[2];
        File confDir = new File(confDirPath);
        if (!confDir.exists()) {
            System.err.println("The conf-dir is invalid or does not exist");
            System.exit(3);
        }
        if (!(workDir = new File(workDirPath)).exists()) {
            System.err.println("The work-dir is invalid or does not exist");
            System.exit(3);
        }
        KerbyKdcServer server = new KerbyKdcServer(confDir);
        server.setWorkDir(workDir);
        try {
            server.init();
        }
        catch (KrbException e) {
            System.err.println("Errors occurred when starting the kdc server:  " + e.getMessage());
            System.exit(4);
        }
        try {
            server.start();
            System.out.println("KDC started.");
        }
        catch (KrbException e) {
            System.err.println("Errors occurred when starting the kdc server:  " + e.getMessage());
            System.exit(5);
        }
    }
}

