/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.KdcHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyKdcUdpServerHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private final KdcHandler myKdcHandler;
    private static final Logger LOG = LoggerFactory.getLogger(NettyKdcUdpServerHandler.class);

    public NettyKdcUdpServerHandler(KdcContext kdcContext) {
        this.myKdcHandler = new KdcHandler(kdcContext);
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, DatagramPacket datagramPacket) throws Exception {
        ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
        byte[] msgBytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(msgBytes);
        ByteBuffer requestMessage = ByteBuffer.wrap(msgBytes);
        InetSocketAddress clientAddress = (InetSocketAddress)datagramPacket.sender();
        boolean isTcp = false;
        try {
            ByteBuffer responseMessage = this.myKdcHandler.handleMessage(requestMessage, isTcp, clientAddress.getAddress());
            channelHandlerContext.writeAndFlush((Object)new DatagramPacket(Unpooled.wrappedBuffer((ByteBuffer)responseMessage), clientAddress));
        }
        catch (Exception e) {
            LOG.error("Error occurred while processing request: " + e.toString());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.fireExceptionCaught(cause);
    }
}

