/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.provider.token;

import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.kerby.kerberos.kerb.spec.base.AuthToken;
import org.apache.kerby.kerberos.provider.token.JwtUtil;

public class JwtAuthToken
implements AuthToken {
    private JWTClaimsSet jwtClaims;
    private Boolean isIdToken = true;
    private Boolean isAcToken = false;

    protected JwtAuthToken() {
        this(new JWTClaimsSet());
    }

    protected JwtAuthToken(JWTClaimsSet jwtClaims) {
        this.jwtClaims = jwtClaims;
    }

    protected JwtAuthToken(ReadOnlyJWTClaimsSet jwtClaims) {
        this.jwtClaims = JwtUtil.from(jwtClaims);
    }

    protected JWT getJwt() {
        String jti = this.jwtClaims.getJWTID();
        if (jti == null || jti.isEmpty()) {
            jti = UUID.randomUUID().toString();
            this.jwtClaims.setJWTID(jti);
        }
        PlainHeader header = new PlainHeader();
        PlainJWT jwt = new PlainJWT(header, (ReadOnlyJWTClaimsSet)this.jwtClaims);
        return jwt;
    }

    public String getSubject() {
        return this.jwtClaims.getSubject();
    }

    public void setSubject(String sub) {
        this.jwtClaims.setSubject(sub);
    }

    public String getIssuer() {
        return this.jwtClaims.getIssuer();
    }

    public void setIssuer(String issuer) {
        this.jwtClaims.setIssuer(issuer);
    }

    public List<String> getAudiences() {
        return this.jwtClaims.getAudience();
    }

    public void setAudiences(List<String> audiences) {
        this.jwtClaims.setAudience(audiences);
    }

    public boolean isIdToken() {
        return this.isIdToken;
    }

    public void isIdToken(boolean isIdToken) {
        this.isIdToken = isIdToken;
    }

    public boolean isAcToken() {
        return this.isAcToken;
    }

    public void isAcToken(boolean isAcToken) {
        this.isAcToken = isAcToken;
    }

    public boolean isBearerToken() {
        return true;
    }

    public boolean isHolderOfKeyToken() {
        return false;
    }

    public Date getExpiredTime() {
        return this.jwtClaims.getExpirationTime();
    }

    public void setExpirationTime(Date exp) {
        this.jwtClaims.setExpirationTime(exp);
    }

    public Date getNotBeforeTime() {
        return this.jwtClaims.getNotBeforeTime();
    }

    public void setNotBeforeTime(Date nbt) {
        this.jwtClaims.setNotBeforeTime(nbt);
    }

    public Date getIssueTime() {
        return this.jwtClaims.getIssueTime();
    }

    public void setIssueTime(Date iat) {
        this.jwtClaims.setIssueTime(iat);
    }

    public Map<String, Object> getAttributes() {
        return this.jwtClaims.getAllClaims();
    }

    public void addAttribute(String name, Object value) {
        this.jwtClaims.setCustomClaim(name, value);
    }
}

