/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.provider.token;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.kerby.kerberos.kerb.provider.TokenDecoder;
import org.apache.kerby.kerberos.kerb.spec.base.AuthToken;
import org.apache.kerby.kerberos.provider.token.JwtAuthToken;

public class JwtTokenDecoder
implements TokenDecoder {
    private RSAPrivateKey decryptionKey;
    private RSAPublicKey verifyKey;
    private List<String> audiences = null;

    public AuthToken decodeFromBytes(byte[] content) throws IOException {
        String tokenStr = new String(content, Charset.forName("UTF-8"));
        return this.decodeFromString(tokenStr);
    }

    public AuthToken decodeFromString(String content) throws IOException {
        JWT jwt = null;
        try {
            jwt = JWTParser.parse((String)content);
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse JWT token string", e);
        }
        if (jwt instanceof PlainJWT) {
            PlainJWT plainObject = (PlainJWT)jwt;
            try {
                if (this.verifyToken(jwt)) {
                    return new JwtAuthToken(plainObject.getJWTClaimsSet());
                }
                return null;
            }
            catch (ParseException e) {
                throw new IOException("Failed to get JWT claims set", e);
            }
        }
        if (jwt instanceof EncryptedJWT) {
            EncryptedJWT encryptedJWT = (EncryptedJWT)jwt;
            this.decryptEncryptedJWT(encryptedJWT);
            SignedJWT signedJWT = encryptedJWT.getPayload().toSignedJWT();
            if (signedJWT != null) {
                boolean success;
                boolean bl = success = this.verifySignedJWT(signedJWT) && this.verifyToken((JWT)signedJWT);
                if (success) {
                    try {
                        return new JwtAuthToken(signedJWT.getJWTClaimsSet());
                    }
                    catch (ParseException e) {
                        throw new IOException("Failed to get JWT claims set", e);
                    }
                }
                return null;
            }
            try {
                if (this.verifyToken((JWT)encryptedJWT)) {
                    return new JwtAuthToken(encryptedJWT.getJWTClaimsSet());
                }
                return null;
            }
            catch (ParseException e) {
                throw new IOException("Failed to get JWT claims set", e);
            }
        }
        if (jwt instanceof SignedJWT) {
            boolean success;
            SignedJWT signedJWT = (SignedJWT)jwt;
            boolean bl = success = this.verifySignedJWT(signedJWT) && this.verifyToken((JWT)signedJWT);
            if (success) {
                try {
                    return new JwtAuthToken(signedJWT.getJWTClaimsSet());
                }
                catch (ParseException e) {
                    throw new IOException("Failed to get JWT claims set", e);
                }
            }
            return null;
        }
        throw new IOException("Unexpected JWT type: " + jwt);
    }

    public void decryptEncryptedJWT(EncryptedJWT encryptedJWT) throws IOException {
        RSADecrypter decrypter = new RSADecrypter(this.decryptionKey);
        try {
            encryptedJWT.decrypt((JWEDecrypter)decrypter);
        }
        catch (JOSEException e) {
            throw new IOException("Failed to decrypt the encrypted JWT", e);
        }
    }

    public void setDecryptionKey(RSAPrivateKey key) {
        this.decryptionKey = key;
    }

    public boolean verifySignedJWT(SignedJWT signedJWT) throws IOException {
        RSASSAVerifier verifier = new RSASSAVerifier(this.verifyKey);
        try {
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (JOSEException e) {
            throw new IOException("Failed to verify the signed JWT", e);
        }
    }

    public void setVerifyKey(RSAPublicKey key) {
        this.verifyKey = key;
    }

    public void setAudiences(List<String> auds) {
        this.audiences = auds;
    }

    private boolean verifyToken(JWT jwtToken) throws IOException {
        boolean audValid = this.verifyAudiences(jwtToken);
        boolean expValid = this.verifyExpiration(jwtToken);
        return audValid && expValid;
    }

    private boolean verifyAudiences(JWT jwtToken) throws IOException {
        boolean valid;
        block4: {
            valid = false;
            try {
                List tokenAudiences = jwtToken.getJWTClaimsSet().getAudience();
                if (this.audiences == null) {
                    valid = true;
                    break block4;
                }
                for (String audience : tokenAudiences) {
                    if (!this.audiences.contains(audience)) continue;
                    valid = true;
                    break;
                }
            }
            catch (ParseException e) {
                throw new IOException("Failed to get JWT claims set", e);
            }
        }
        return valid;
    }

    private boolean verifyExpiration(JWT jwtToken) throws IOException {
        boolean valid = false;
        try {
            Date expire = jwtToken.getJWTClaimsSet().getExpirationTime();
            if (expire != null && new Date().before(expire)) {
                valid = true;
            }
        }
        catch (ParseException e) {
            throw new IOException("Failed to get JWT claims set", e);
        }
        return valid;
    }
}

