/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.provider.token;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import java.nio.charset.Charset;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.provider.TokenEncoder;
import org.apache.kerby.kerberos.kerb.spec.base.AuthToken;
import org.apache.kerby.kerberos.provider.token.JwtAuthToken;

public class JwtTokenEncoder
implements TokenEncoder {
    private static JWEAlgorithm jweAlgorithm = JWEAlgorithm.RSA_OAEP;
    private static EncryptionMethod encryptionMethod = EncryptionMethod.A128GCM;
    private static JWSAlgorithm jwsAlgorithm = JWSAlgorithm.RS256;
    private RSAPublicKey encryptionKey;
    private RSAPrivateKey signKey;

    public byte[] encodeAsBytes(AuthToken token) throws KrbException {
        String tokenStr = this.encodeAsString(token);
        return tokenStr.getBytes(Charset.forName("UTF-8"));
    }

    public String encodeAsString(AuthToken token) throws KrbException {
        if (!(token instanceof JwtAuthToken)) {
            throw new KrbException("Unexpected AuthToken, not JwtAuthToken");
        }
        JwtAuthToken jwtAuthToken = (JwtAuthToken)token;
        JWT jwt = jwtAuthToken.getJwt();
        String tokenStr = null;
        if (this.signKey != null) {
            RSASSASigner signer = new RSASSASigner(this.signKey);
            SignedJWT signedJWT = null;
            try {
                signedJWT = new SignedJWT(new JWSHeader(jwsAlgorithm), jwt.getJWTClaimsSet());
            }
            catch (ParseException e) {
                throw new KrbException("Failed to get JWT claims set", (Throwable)e);
            }
            try {
                signedJWT.sign((JWSSigner)signer);
            }
            catch (JOSEException e) {
                throw new KrbException("Failed to sign the Signed JWT", (Throwable)e);
            }
            if (this.encryptionKey != null) {
                JWEObject jweObject = new JWEObject(new JWEHeader.Builder(jweAlgorithm, encryptionMethod).contentType("JWT").build(), new Payload(signedJWT));
                try {
                    jweObject.encrypt((JWEEncrypter)new RSAEncrypter(this.encryptionKey));
                }
                catch (JOSEException e) {
                    throw new KrbException("Failed to encrypt the JWE object", (Throwable)e);
                }
                tokenStr = jweObject.serialize();
            } else {
                tokenStr = signedJWT.serialize();
            }
        } else if (this.encryptionKey != null) {
            JWEHeader header = new JWEHeader(jweAlgorithm, encryptionMethod);
            EncryptedJWT encryptedJWT = null;
            try {
                encryptedJWT = new EncryptedJWT(header, jwt.getJWTClaimsSet());
            }
            catch (ParseException e) {
                throw new KrbException("Failed to get JWT claims set", (Throwable)e);
            }
            try {
                encryptedJWT.encrypt((JWEEncrypter)new RSAEncrypter(this.encryptionKey));
            }
            catch (JOSEException e) {
                throw new KrbException("Failed to encrypt the encrypted JWT", (Throwable)e);
            }
            tokenStr = encryptedJWT.serialize();
        } else {
            tokenStr = jwt.serialize();
        }
        return tokenStr;
    }

    public void setEncryptionKey(RSAPublicKey key) {
        this.encryptionKey = key;
    }

    public void setSignKey(RSAPrivateKey key) {
        this.signKey = key;
    }
}

