/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.auth;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoAuthInterceptor
implements Interceptor,
Authenticator {
    private static final String NEGOTIATE = "Negotiate";
    private static final GSSManager GSS_MANAGER = GSSManager.getInstance();
    private static final Oid SPNEGO_OID = SpnegoAuthInterceptor.createOid("1.3.6.1.5.5.2");
    private static final Oid KERBEROS_OID = SpnegoAuthInterceptor.createOid("1.2.840.113554.1.2.2");
    private static final String DEFAULT_REMOTE_SERVICE_NAME = "HTTP";
    private static final int CREDENTIAL_EXPIRATION_THRESHOLD = 60;
    private final String remoteServiceName;
    private final boolean useCanonicalHostname;
    private Subject subject;
    private GSSCredentialSession credentialSession;

    public SpnegoAuthInterceptor(Subject subject) {
        this(subject, DEFAULT_REMOTE_SERVICE_NAME);
    }

    public SpnegoAuthInterceptor(Subject subject, String remoteServiceName) {
        this(subject, remoteServiceName, true);
    }

    public SpnegoAuthInterceptor(Subject subject, String remoteServiceName, boolean useCanonicalHostname) {
        this.subject = subject;
        this.remoteServiceName = remoteServiceName;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        try {
            return chain.proceed(this.authenticate(chain.request()));
        }
        catch (Exception ignored) {
            return chain.proceed(chain.request());
        }
    }

    private static boolean isNegotiate(String value) {
        String[] split = value.split("\\s+");
        return split.length == 2 && split[1].equalsIgnoreCase(NEGOTIATE);
    }

    public Request authenticate(Proxy proxy, Response response) throws IOException {
        if (response.request().headers("Authorization").stream().anyMatch(SpnegoAuthInterceptor::isNegotiate) || response.headers("WWW-Authenticate").stream().noneMatch(SpnegoAuthInterceptor::isNegotiate)) {
            return null;
        }
        return this.authenticate(response.request());
    }

    public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
        return null;
    }

    private Request authenticate(Request request) {
        String principal = SpnegoAuthInterceptor.defineServicePrincipal(this.remoteServiceName, request.url().getHost(), this.useCanonicalHostname);
        byte[] token = this.generateToken(principal);
        String credential = String.format(Locale.getDefault(), "%s %s", NEGOTIATE, Base64.getEncoder().encodeToString(token));
        return request.newBuilder().header("Authorization", credential).build();
    }

    private byte[] generateToken(String servicePrincipal) {
        GSSContext context = null;
        try {
            GSSCredentialSession GSSCredentialSession2 = this.getCredentialSession();
            context = SpnegoAuthInterceptor.doAs(this.subject, () -> {
                GSSContext result = GSS_MANAGER.createContext(GSS_MANAGER.createName(servicePrincipal, GSSName.NT_HOSTBASED_SERVICE), SPNEGO_OID, GSSCredentialSession2.getClientCredential(), Integer.MAX_VALUE);
                result.requestMutualAuth(true);
                result.requestConf(true);
                result.requestInteg(true);
                result.requestCredDeleg(false);
                return result;
            });
            byte[] token = context.initSecContext(new byte[0], 0, 0);
            if (token == null) {
                throw new LoginException("No token generated from GSS context");
            }
            byte[] byArray = token;
            return byArray;
        }
        catch (LoginException | GSSException e) {
            throw new RuntimeException(String.format(Locale.getDefault(), "Kerberos error for [%s]: %s", servicePrincipal, e.getMessage()), e);
        }
        finally {
            try {
                if (context != null) {
                    context.dispose();
                }
            }
            catch (GSSException gSSException) {}
        }
    }

    private synchronized GSSCredentialSession getCredentialSession() throws GSSException {
        if (this.credentialSession == null || this.credentialSession.needsRefresh()) {
            this.credentialSession = this.createCredentialSession();
        }
        return this.credentialSession;
    }

    private GSSCredentialSession createCredentialSession() throws GSSException {
        Principal clientPrincipal = this.subject.getPrincipals().iterator().next();
        GSSCredential clientCredential = SpnegoAuthInterceptor.doAs(this.subject, () -> GSS_MANAGER.createCredential(GSS_MANAGER.createName(clientPrincipal.getName(), GSSName.NT_USER_NAME), 0, KERBEROS_OID, 1));
        return new GSSCredentialSession(clientCredential);
    }

    private static String defineServicePrincipal(String serviceName, String hostName, boolean useCanonicalHostname) {
        String serviceHostName = useCanonicalHostname ? SpnegoAuthInterceptor.getCanonicalHostName(hostName) : hostName;
        return String.format(Locale.getDefault(), "%s@%s", serviceName, serviceHostName.toLowerCase(Locale.US));
    }

    private static String getCanonicalHostName(String hostName) {
        String canonicalHostName;
        try {
            InetAddress address = InetAddress.getByName(hostName);
            canonicalHostName = "localhost".equalsIgnoreCase(address.getHostName()) ? InetAddress.getLocalHost().getCanonicalHostName() : address.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to resolve host: " + hostName, e);
        }
        return canonicalHostName;
    }

    private static <T> T doAs(Subject subject, GssSupplier<T> action) throws GSSException {
        try {
            return (T)Subject.doAs(subject, action::get);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof GSSException) {
                throw (GSSException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static Oid createOid(String value) {
        try {
            return new Oid(value);
        }
        catch (GSSException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class GSSCredentialSession {
        private final GSSCredential clientCredential;

        GSSCredentialSession(GSSCredential clientCredential) {
            Objects.requireNonNull(clientCredential, "gssCredential is null");
            this.clientCredential = clientCredential;
        }

        GSSCredential getClientCredential() {
            return this.clientCredential;
        }

        public boolean needsRefresh() throws GSSException {
            return this.clientCredential.getRemainingLifetime() < 60;
        }
    }

    private static interface GssSupplier<T> {
        public T get() throws GSSException;
    }
}

