/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.knox.gateway.ha.provider.HaDescriptor;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.ha.provider.impl.DefaultHaProvider;
import org.apache.knox.gateway.ha.provider.impl.HaDescriptorManager;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.registry.ServiceRegistry;

public class HaServletContextListener
implements ServletContextListener {
    public static final String PROVIDER_ATTRIBUTE_NAME = "haProvider";
    public static final String DESCRIPTOR_LOCATION_INIT_PARAM_NAME = "haDescriptorLocation";
    public static final String DESCRIPTOR_DEFAULT_FILE_NAME = "ha.xml";
    public static final String DESCRIPTOR_DEFAULT_LOCATION = "/WEB-INF/ha.xml";

    public void contextInitialized(ServletContextEvent event) {
        HaDescriptor descriptor;
        ServletContext servletContext = event.getServletContext();
        try {
            URL url = HaServletContextListener.locateDescriptor(servletContext);
            descriptor = HaServletContextListener.loadDescriptor(url);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.setupHaProvider(descriptor, servletContext);
    }

    public void contextDestroyed(ServletContextEvent event) {
        event.getServletContext().removeAttribute(PROVIDER_ATTRIBUTE_NAME);
    }

    public static HaProvider getHaProvider(ServletContext context) {
        return (HaProvider)context.getAttribute(PROVIDER_ATTRIBUTE_NAME);
    }

    private void setupHaProvider(HaDescriptor descriptor, ServletContext servletContext) {
        GatewayServices services = (GatewayServices)servletContext.getAttribute("org.apache.knox.gateway.gateway.services");
        String clusterName = (String)servletContext.getAttribute("org.apache.knox.gateway.gateway.cluster");
        ServiceRegistry serviceRegistry = (ServiceRegistry)services.getService(ServiceType.SERVICE_REGISTRY_SERVICE);
        DefaultHaProvider provider = new DefaultHaProvider(descriptor);
        List<String> serviceNames = descriptor.getEnabledServiceNames();
        for (String serviceName : serviceNames) {
            provider.addHaService(serviceName, serviceRegistry.lookupServiceURLs(clusterName, serviceName));
        }
        servletContext.setAttribute(PROVIDER_ATTRIBUTE_NAME, (Object)provider);
    }

    private static URL locateDescriptor(ServletContext context) throws IOException {
        URL url;
        String param = context.getInitParameter(DESCRIPTOR_LOCATION_INIT_PARAM_NAME);
        if (param == null) {
            param = DESCRIPTOR_DEFAULT_LOCATION;
        }
        try {
            url = context.getResource(param);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        if (url == null) {
            url = new URL(param);
        }
        return url;
    }

    private static HaDescriptor loadDescriptor(URL url) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream stream = url.openStream();){
            return HaDescriptorManager.load(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

