/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.knox.gateway.dispatch.KnoxSpnegoAuthSchemeFactory;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.URLManager;
import org.apache.knox.gateway.ha.provider.impl.StringResponseHandler;
import org.apache.knox.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public abstract class BaseZookeeperURLManager
implements URLManager {
    protected static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);
    private static final int TIMEOUT = 5000;
    private final ConcurrentLinkedQueue<String> urls = new ConcurrentLinkedQueue();
    private String zooKeeperEnsemble;
    private String zooKeeperNamespace;

    @Override
    public boolean supportsConfig(HaServiceConfig config) {
        if (!config.getServiceName().equalsIgnoreCase(this.getServiceName())) {
            return false;
        }
        String zookeeperEnsemble = config.getZookeeperEnsemble();
        return zookeeperEnsemble != null && !zookeeperEnsemble.trim().isEmpty();
    }

    @Override
    public void setConfig(HaServiceConfig config) {
        this.zooKeeperEnsemble = config.getZookeeperEnsemble();
        this.zooKeeperNamespace = config.getZookeeperNamespace();
        this.setURLs(this.lookupURLs());
    }

    @Override
    public synchronized String getActiveURL() {
        if (this.urls.isEmpty()) {
            this.setURLs(this.lookupURLs());
        }
        return this.urls.peek();
    }

    @Override
    public synchronized void setActiveURL(String url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized List<String> getURLs() {
        return new ArrayList<String>(this.urls);
    }

    @Override
    public synchronized void markFailed(String url) {
        String topURL = this.getActiveURL();
        this.setURLs(this.lookupURLs());
        LOG.markedFailedUrl(topURL, this.getActiveURL());
    }

    @Override
    public void makeNextActiveURLAvailable() {
        String head = this.urls.poll();
        this.urls.offer(head);
    }

    @Override
    public synchronized void setURLs(List<String> urls) {
        if (urls != null && !urls.isEmpty()) {
            this.urls.clear();
            this.urls.addAll(urls);
        }
    }

    protected abstract List<String> lookupURLs();

    protected abstract String getServiceName();

    protected String getZookeeperEnsemble() {
        return this.zooKeeperEnsemble;
    }

    protected String getZookeeperNamespace() {
        return this.zooKeeperNamespace;
    }

    protected List<String> validateHosts(List<String> hosts, String suffix, String acceptHeader) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient client = this.buildHttpClient();){
                for (String host : hosts) {
                    try {
                        String response;
                        HttpGet get = new HttpGet(String.valueOf(host) + suffix);
                        if (acceptHeader != null) {
                            get.setHeader("Accept", acceptHeader);
                        }
                        if ((response = (String)client.execute((HttpUriRequest)get, (ResponseHandler)new StringResponseHandler())) == null) continue;
                        result.add(host);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private CloseableHttpClient buildHttpClient() {
        CloseableHttpClient client;
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(5000);
        if (Boolean.getBoolean("gateway.hadoop.kerberos.secured")) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new NullCredentials());
            Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new KnoxSpnegoAuthSchemeFactory(true)).build();
            client = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        } else {
            client = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).build();
        }
        return client;
    }

    private static class NullCredentials
    implements Credentials {
        private NullCredentials() {
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getPassword() {
            return null;
        }
    }
}

