/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.knox.gateway.ha.provider.impl.BaseZookeeperURLManager;

public class HBaseZookeeperURLManager
extends BaseZookeeperURLManager {
    private static final int PORT_NUMBER = 8080;
    private static final String DEFAULT_ZOOKEEPER_NAMESPACE_SECURE = "/hbase-secure";
    private static final String DEFAULT_ZOOKEEPER_NAMESPACE_UNSECURE = "/hbase-unsecure";

    @Override
    protected List<String> lookupURLs() {
        List<String> hosts = this.retrieveHosts();
        List<String> validatedHosts = this.validateHosts(hosts, "/version/rest", "text/xml");
        if (!validatedHosts.isEmpty()) {
            Collections.shuffle(validatedHosts);
        }
        return validatedHosts;
    }

    @Override
    protected String getServiceName() {
        return "WEBHBASE";
    }

    @Override
    protected String getZookeeperNamespace() {
        return super.getZookeeperNamespace();
    }

    private List<String> retrieveHosts() {
        ArrayList<String> serverHosts = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(this.getZookeeperEnsemble()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();){
                zooKeeperClient.start();
                zooKeeperClient.blockUntilConnected(10, TimeUnit.SECONDS);
                List serverNodes = null;
                String namespace = this.getZookeeperNamespace();
                if (namespace != null && !namespace.isEmpty()) {
                    if (!namespace.startsWith("/")) {
                        namespace = "/" + namespace;
                    }
                    serverNodes = (List)zooKeeperClient.getChildren().forPath(String.valueOf(namespace) + "/rs");
                } else {
                    try {
                        serverNodes = (List)zooKeeperClient.getChildren().forPath("/hbase-secure/rs");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (serverNodes == null || serverNodes.isEmpty()) {
                        serverNodes = (List)zooKeeperClient.getChildren().forPath("/hbase-unsecure/rs");
                    }
                }
                if (serverNodes != null) {
                    for (String serverNode : serverNodes) {
                        String serverURL = this.constructURL(serverNode);
                        serverHosts.add(serverURL);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.failedToGetZookeeperUrls(e);
            throw new RuntimeException(e);
        }
        return serverHosts;
    }

    private String constructURL(String serverInfo) {
        String scheme = "http";
        return String.valueOf(scheme) + "://" + serverInfo.substring(0, serverInfo.indexOf(44)) + ":" + 8080;
    }
}

