/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.knox.gateway.ha.provider.impl.BaseZookeeperURLManager;

public class SOLRZookeeperURLManager
extends BaseZookeeperURLManager {
    @Override
    protected List<String> lookupURLs() {
        List<String> hosts = this.retrieveHosts();
        if (!hosts.isEmpty()) {
            Collections.shuffle(hosts);
        }
        return hosts;
    }

    @Override
    protected String getServiceName() {
        return "SOLR";
    }

    private List<String> retrieveHosts() {
        ArrayList<String> serverHosts = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(this.getZookeeperEnsemble()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();){
                zooKeeperClient.start();
                zooKeeperClient.blockUntilConnected(10, TimeUnit.SECONDS);
                List serverNodes = (List)zooKeeperClient.getChildren().forPath("/live_nodes");
                for (String serverNode : serverNodes) {
                    String serverURL = this.constructURL(serverNode);
                    serverHosts.add(serverURL);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.failedToGetZookeeperUrls(e);
            throw new RuntimeException(e);
        }
        return serverHosts;
    }

    private String constructURL(String serverInfo) {
        String scheme = "http";
        return String.valueOf(scheme) + "://" + serverInfo.replace("_", "/");
    }
}

