/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.audit.api.CorrelationContext;
import org.apache.knox.gateway.audit.api.CorrelationServiceFactory;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.util.ServletRequestUtils;
import org.apache.knox.gateway.util.urltemplate.Matcher;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class GatewayFilter
implements Filter {
    private static final FilterChain EMPTY_CHAIN = new FilterChain(){

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        }
    };
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final GatewayResources RES = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    private Set<Holder> holders = new HashSet<Holder>();
    private Matcher<Chain> chains = new Matcher();
    private FilterConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.doFilter(servletRequest, servletResponse);
        if (filterChain != null) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        String defaultServicePath;
        Topology topology;
        Template pathWithQueryTemplate;
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String path = httpRequest.getPathInfo();
        String requestPath = ServletRequestUtils.getRequestPath(httpRequest);
        String requestPathWithQuery = ServletRequestUtils.getRequestPathWithQuery(httpRequest);
        try {
            pathWithQueryTemplate = Parser.parseLiteral((String)requestPathWithQuery);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        String contextWithPathAndQuery = ServletRequestUtils.getContextPathWithQuery(httpRequest);
        LOG.receivedRequest(httpRequest.getMethod(), requestPath);
        servletRequest.setAttribute("sourceRequestUrl", (Object)pathWithQueryTemplate);
        servletRequest.setAttribute("sourceRequestContextUrl", (Object)contextWithPathAndQuery);
        Matcher.Match match = this.chains.match(pathWithQueryTemplate);
        if (match == null && (topology = (Topology)servletRequest.getServletContext().getAttribute("org.apache.knox.gateway.topology")) != null && (defaultServicePath = topology.getDefaultServicePath()) != null) {
            try {
                String origUrl;
                String newPathWithQuery = defaultServicePath + "/" + pathWithQueryTemplate;
                match = this.chains.match(Parser.parseLiteral((String)newPathWithQuery));
                String url = origUrl = ((HttpServletRequest)servletRequest).getRequestURL().toString();
                if (path == null || "/".equals(path)) {
                    url = url + defaultServicePath;
                } else {
                    int index = origUrl.indexOf(path);
                    url = origUrl.substring(0, index) + "/" + defaultServicePath + path;
                }
                servletRequest = new ForwardedRequest((HttpServletRequest)servletRequest, defaultServicePath, url);
            }
            catch (URISyntaxException e) {
                throw new ServletException((Throwable)e);
            }
        }
        this.assignCorrelationRequestId();
        AuditContext auditContext = auditService.getContext();
        auditContext.setTargetServiceName(match == null ? null : ((Chain)match.getValue()).getResourceRole());
        auditContext.setRemoteIp(this.getRemoteAddress((ServletRequest)servletRequest));
        auditContext.setRemoteHostname(servletRequest.getRemoteHost());
        auditor.audit("access", contextWithPathAndQuery, "uri", "unavailable", RES.requestMethod(((HttpServletRequest)servletRequest).getMethod()));
        if (match != null) {
            Chain chain = (Chain)match.getValue();
            servletRequest.setAttribute("targetServiceRole", (Object)chain.getResourceRole());
            try {
                chain.doFilter((ServletRequest)servletRequest, servletResponse);
            }
            catch (IOException | RuntimeException | ThreadDeath | ServletException e) {
                LOG.failedToExecuteFilter(e);
                auditor.audit("access", contextWithPathAndQuery, "uri", "failure");
                throw e;
            }
            catch (Throwable e) {
                LOG.failedToExecuteFilter(e);
                auditor.audit("access", contextWithPathAndQuery, "uri", "failure");
                throw new ServletException(e);
            }
            finally {
                CorrelationServiceFactory.getCorrelationService().detachContext();
            }
        } else {
            LOG.failedToMatchPath(requestPath);
            httpResponse.setStatus(404);
            CorrelationServiceFactory.getCorrelationService().detachContext();
        }
    }

    private String getRemoteAddress(ServletRequest servletRequest) {
        GatewayConfig gatewayConfig = (GatewayConfig)servletRequest.getServletContext().getAttribute("org.apache.knox.gateway.config");
        String addrHeaderName = gatewayConfig.getHeaderNameForRemoteAddress();
        String addr = ((HttpServletRequest)servletRequest).getHeader(addrHeaderName);
        if (addr == null || addr.trim().isEmpty()) {
            addr = servletRequest.getRemoteAddr();
        }
        return addr;
    }

    public void destroy() {
        for (Holder holder : this.holders) {
            holder.destroy();
        }
    }

    private void addHolder(Holder holder) {
        this.holders.add(holder);
        Chain chain = (Chain)this.chains.get(holder.template);
        if (chain == null) {
            chain = new Chain();
            chain.setResourceRole(holder.getResourceRole());
            this.chains.add(holder.template, (Object)chain);
        }
        chain.chainList.add(holder);
    }

    public void addFilter(String path, String name, Filter filter, Map<String, String> params, String resourceRole) throws URISyntaxException {
        Holder holder = new Holder(path, name, filter, params, resourceRole);
        this.addHolder(holder);
    }

    public void addFilter(String path, String name, String clazz, Map<String, String> params, String resourceRole) throws URISyntaxException {
        Holder holder = new Holder(path, name, clazz, params, resourceRole);
        this.addHolder(holder);
    }

    private void assignCorrelationRequestId() {
        String requestId;
        CorrelationContext correlationContext = CorrelationServiceFactory.getCorrelationService().getContext();
        if (correlationContext == null) {
            correlationContext = CorrelationServiceFactory.getCorrelationService().createContext();
        }
        if ((requestId = correlationContext.getRequestId()) == null) {
            correlationContext.setRequestId(UUID.randomUUID().toString());
        }
    }

    static class ForwardedRequest
    extends HttpServletRequestWrapper {
        private String newURL;
        private String contextpath;

        ForwardedRequest(HttpServletRequest request, String contextpath, String newURL) {
            super(request);
            this.newURL = newURL;
            this.contextpath = contextpath;
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(this.newURL);
        }

        public String getRequestURI() {
            return this.newURL;
        }

        public String getContextPath() {
            return super.getContextPath() + "/" + this.contextpath;
        }
    }

    private class Holder
    implements Filter,
    FilterConfig {
        private Template template;
        private String name;
        private Map<String, String> params;
        private Filter instance;
        private Class<? extends Filter> clazz;
        private String type;
        private String resourceRole;

        Holder(String path, String name, Filter filter, Map<String, String> params, String resourceRole) throws URISyntaxException {
            this.template = Parser.parseTemplate((String)path);
            this.name = name;
            this.params = params;
            this.instance = filter;
            this.clazz = filter.getClass();
            this.type = this.clazz.getCanonicalName();
            this.resourceRole = resourceRole;
        }

        Holder(String path, String name, String clazz, Map<String, String> params, String resourceRole) throws URISyntaxException {
            this.template = Parser.parseTemplate((String)path);
            this.name = name;
            this.params = params;
            this.instance = null;
            this.clazz = null;
            this.type = clazz;
            this.resourceRole = resourceRole;
        }

        public String getFilterName() {
            return this.name;
        }

        public ServletContext getServletContext() {
            return GatewayFilter.this.config.getServletContext();
        }

        public String getInitParameter(String name) {
            String value = null;
            if (this.params != null) {
                value = this.params.get(name);
            }
            return value;
        }

        public Enumeration<String> getInitParameterNames() {
            Enumeration<String> names = null;
            if (this.params != null) {
                names = Collections.enumeration(this.params.keySet());
            }
            return names;
        }

        public void init(FilterConfig filterConfig) throws ServletException {
            this.getInstance().init(filterConfig);
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            Filter filter = this.getInstance();
            filter.doFilter(servletRequest, servletResponse, filterChain);
        }

        public void destroy() {
            if (this.instance != null) {
                this.instance.destroy();
                this.instance = null;
            }
        }

        private Class<? extends Filter> getClazz() throws ClassNotFoundException {
            if (this.clazz == null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                this.clazz = loader.loadClass(this.type);
            }
            return this.clazz;
        }

        private Filter getInstance() throws ServletException {
            if (this.instance == null) {
                try {
                    if (this.clazz == null) {
                        this.clazz = this.getClazz();
                    }
                    Filter f = this.clazz.newInstance();
                    f.init((FilterConfig)this);
                    this.instance = f;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            return this.instance;
        }

        private String getResourceRole() {
            return this.resourceRole;
        }
    }

    private class Chain
    implements FilterChain {
        private List<Holder> chainList;
        private String resourceRole;

        Chain() {
            this.chainList = new ArrayList<Holder>();
        }

        Chain(List<Holder> chainList) {
            this.chainList = chainList;
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            if (this.chainList != null && !this.chainList.isEmpty()) {
                Filter filter = this.chainList.get(0);
                FilterChain chain = this.subChain();
                filter.doFilter(servletRequest, servletResponse, chain);
            }
        }

        private FilterChain subChain() {
            if (this.chainList != null && this.chainList.size() > 1) {
                return new Chain(this.chainList.subList(1, this.chainList.size()));
            }
            return EMPTY_CHAIN;
        }

        private String getResourceRole() {
            return this.resourceRole;
        }

        private void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }
    }
}

