/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.config.remote.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.service.config.remote.config.RemoteConfigurationRegistries;
import org.apache.knox.gateway.service.config.remote.config.RemoteConfigurationRegistry;

class DefaultRemoteConfigurationRegistries
extends RemoteConfigurationRegistries {
    private static final String PROPERTY_DELIM = ";";
    private static final String PROPERTY_VALUE_DELIM = "=";
    private List<RemoteConfigurationRegistry> configuredRegistries = new ArrayList<RemoteConfigurationRegistry>();

    DefaultRemoteConfigurationRegistries(GatewayConfig gc) {
        List configRegistryNames = gc.getRemoteRegistryConfigurationNames();
        for (String configRegistryName : configRegistryNames) {
            this.configuredRegistries.add(DefaultRemoteConfigurationRegistries.extractConfigForRegistry(gc, configRegistryName));
        }
    }

    private static RemoteConfigurationRegistry extractConfigForRegistry(GatewayConfig gc, String registryName) {
        RemoteConfigurationRegistry result = new RemoteConfigurationRegistry();
        result.setName(registryName);
        Map<String, String> properties = DefaultRemoteConfigurationRegistries.parsePropertyValue(gc.getRemoteRegistryConfiguration(registryName));
        result.setRegistryType(properties.get("type"));
        result.setConnectionString(properties.get("address"));
        result.setNamespace(properties.get("namespace"));
        result.setAuthType(properties.get("authType"));
        result.setPrincipal(properties.get("principal"));
        result.setCredentialAlias(properties.get("credentialAlias"));
        result.setKeytab(properties.get("keytab"));
        result.setUseKeytab(Boolean.valueOf(properties.get("useKeyTab")));
        result.setUseTicketCache(Boolean.valueOf(properties.get("useTicketCache")));
        result.setBackwardsCompatible(Boolean.valueOf(properties.getOrDefault("backwardsCompatible", "false")));
        return result;
    }

    private static Map<String, String> parsePropertyValue(String value) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (value != null) {
            String[] props;
            String[] stringArray = props = value.split(PROPERTY_DELIM);
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                String prop = stringArray[n2];
                String[] split = prop.split(PROPERTY_VALUE_DELIM);
                String propName = split[0];
                String propValue = split.length > 1 ? split[1] : null;
                result.put(propName, propValue);
                ++n2;
            }
        }
        return result;
    }

    @Override
    List<RemoteConfigurationRegistry> getRegistryConfigurations() {
        return this.configuredRegistries;
    }
}

