/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.test;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Topology;

@Path(value="/service-test")
public class ServiceTestResource {
    @Context
    private HttpServletRequest request;

    /*
     * Loose catch block
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public ServiceTestWrapper serviceTest(@QueryParam(value="username") String username, @QueryParam(value="password") String password) {
        ArrayList<String> messages;
        ArrayList<ServiceTest> tests;
        block35: {
            String authString;
            tests = new ArrayList<ServiceTest>();
            messages = new ArrayList<String>();
            GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
            CloseableHttpClient client = null;
            String id = this.getTopologyName();
            Topology topology = this.getTopology(id);
            if (username != null && password != null) {
                String base64EncodedUserPass = Base64.getEncoder().encodeToString((String.valueOf(username) + ":" + password).getBytes(StandardCharsets.UTF_8));
                authString = "Basic " + base64EncodedUserPass;
            } else {
                authString = this.request.getHeader("Authorization") != null ? this.request.getHeader("Authorization") : null;
            }
            try {
                client = HttpClients.createDefault();
                if (topology != null) {
                    for (Service s : topology.getServices()) {
                        List<String> urls = this.getServiceTestURLs(config, s.getRole(), topology);
                        if (urls.isEmpty()) {
                            ServiceTest test = new ServiceTest(s);
                            test.setMessage("This service did not contain any test URLs");
                        }
                        for (String url : urls) {
                            ServiceTest test;
                            HttpGet req;
                            block34: {
                                req = new HttpGet();
                                test = new ServiceTest(s, url);
                                if (authString != null) {
                                    req.setHeader("Authorization", authString);
                                } else {
                                    messages.add("No credentials provided. Expect HTTP 401 responses.");
                                }
                                try {
                                    req.setURI(new URIBuilder(url).build());
                                    Throwable throwable = null;
                                    Object var18_22 = null;
                                    try (CloseableHttpResponse res = client.execute((HttpUriRequest)req);){
                                        String contentLength = "Content-Length:" + res.getEntity().getContentLength();
                                        String contentType = res.getEntity().getContentType() != null ? res.getEntity().getContentType().toString() : "No-contenttype";
                                        test.setResponseContent(String.valueOf(contentLength) + "," + contentType);
                                        test.setHttpCode(res.getStatusLine().getStatusCode());
                                        break block34;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (IOException e) {
                                    messages.add("Exception: " + e.getMessage());
                                    test.setMessage(e.getMessage());
                                    req.releaseConnection();
                                    tests.add(test);
                                    continue;
                                }
                                catch (URISyntaxException e) {
                                    test.setMessage(e.getMessage());
                                    continue;
                                }
                                catch (Exception e) {
                                    messages.add(e.getMessage());
                                    test.setMessage(e.getMessage());
                                    {
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                    }
                                    req.releaseConnection();
                                    tests.add(test);
                                    continue;
                                }
                                {
                                    finally {
                                        req.releaseConnection();
                                        tests.add(test);
                                    }
                                }
                            }
                            req.releaseConnection();
                            tests.add(test);
                        }
                    }
                    break block35;
                }
                messages.add("Topology " + id + " not found");
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ServiceTestWrapper stw = new ServiceTestWrapper();
        stw.setTests(tests);
        stw.setMessages(messages);
        return stw;
    }

    private String getTopologyName() {
        String ctxPath = this.request.getContextPath();
        GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        String path = config.getGatewayPath();
        return ctxPath.replace(path, "").replace("/", "");
    }

    public Topology getTopology(@PathParam(value="id") String id) {
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        TopologyService ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
        for (Topology t : ts.getTopologies()) {
            if (!t.getName().equals(id)) continue;
            try {
                t.setUri(new URI(this.buildURI(t, config, this.request)));
            }
            catch (URISyntaxException se) {
                t.setUri(null);
            }
            return t;
        }
        return null;
    }

    private List<String> getServiceTestURLs(GatewayConfig conf, String role, Topology topology) {
        TopologyService ts;
        Map urls;
        List urlPaths;
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        ArrayList<String> fullURLs = new ArrayList<String>();
        if (services != null && (urlPaths = (List)(urls = (ts = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE)).getServiceTestURLs(topology, conf)).get(role)) != null) {
            String base = this.buildURI(topology, conf, this.request);
            for (String u : urlPaths) {
                fullURLs.add(String.valueOf(base) + u);
            }
        }
        return fullURLs;
    }

    private String buildXForwardBaseURL(HttpServletRequest req) {
        String X_Forwarded = "X-Forwarded-";
        String X_Forwarded_Context = "X-Forwarded-Context";
        String X_Forwarded_Proto = "X-Forwarded-Proto";
        String X_Forwarded_Host = "X-Forwarded-Host";
        String X_Forwarded_Port = "X-Forwarded-Port";
        String X_Forwarded_Server = "X-Forwarded-Server";
        StringBuilder baseURL = new StringBuilder();
        if (req.getHeader("X-Forwarded-Proto") != null) {
            baseURL.append(req.getHeader("X-Forwarded-Proto")).append("://");
        } else {
            baseURL.append(req.getProtocol()).append("://");
        }
        if (req.getHeader("X-Forwarded-Host") != null && req.getHeader("X-Forwarded-Port") != null) {
            if (req.getHeader("X-Forwarded-Host").contains(req.getHeader("X-Forwarded-Port"))) {
                baseURL.append(req.getHeader("X-Forwarded-Host"));
            } else {
                baseURL.append(req.getHeader("X-Forwarded-Host")).append(':').append(req.getHeader("X-Forwarded-Port"));
            }
        } else if (req.getHeader("X-Forwarded-Server") != null && req.getHeader("X-Forwarded-Port") != null) {
            baseURL.append(req.getHeader("X-Forwarded-Server")).append(':').append(req.getHeader("X-Forwarded-Port"));
        } else if (req.getHeader("X-Forwarded-Port") != null) {
            baseURL.append(req.getServerName()).append(':').append(req.getHeader("X-Forwarded-Port"));
        } else {
            baseURL.append(req.getServerName()).append(':').append(req.getLocalPort());
        }
        if (req.getHeader("X-Forwarded-Context") != null) {
            baseURL.append(req.getHeader("X-Forwarded-Context"));
        } else {
            baseURL.append(req.getContextPath());
        }
        return baseURL.toString();
    }

    String buildURI(Topology topology, GatewayConfig config, HttpServletRequest req) {
        String uri = this.buildXForwardBaseURL(req);
        uri = uri.replace(req.getContextPath(), "");
        String gatewayPath = config.getGatewayPath() != null ? config.getGatewayPath() : "gateway";
        return String.valueOf(uri) + "/" + gatewayPath + "/" + topology.getName();
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ServiceTest {
        @XmlElement
        private String serviceName;
        @XmlElement
        private String requestURL;
        @XmlElement
        private String responseContent;
        @XmlElement
        private int httpCode = -1;
        @XmlElement
        String message;

        public ServiceTest() {
        }

        public ServiceTest(Service s) {
            this.serviceName = s.getRole();
        }

        public ServiceTest(Service s, String requestURL) {
            this.serviceName = s.getRole();
            this.requestURL = requestURL;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String n) {
            this.serviceName = n;
        }

        public String getRequestURL() {
            return this.requestURL;
        }

        public void setRequestURL(String requestURL) {
            this.requestURL = requestURL;
        }

        public String getResponseContent() {
            return this.responseContent;
        }

        public void setResponseContent(String responseContent) {
            this.responseContent = responseContent;
        }

        public int getHttpCode() {
            return this.httpCode;
        }

        public void setHttpCode(int httpCode) {
            this.httpCode = httpCode;
            this.setMessage();
        }

        public void setMessage() {
            this.message = ServiceTest.buildMessage(this.httpCode);
        }

        public void setMessage(String msg) {
            this.message = this.httpCode != -1 ? ServiceTest.buildMessage(this.httpCode) : msg;
        }

        public String getMessage() {
            return this.message;
        }

        static String buildMessage(int code) {
            switch (code) {
                case 200: {
                    return "Request successful.";
                }
                case 400: {
                    return "Could not properly interpret HTTP request.";
                }
                case 401: {
                    return "User was not authorized. Try using credentials with access to all services. Ensure LDAP server is running.";
                }
                case 403: {
                    return "Access to this resource is forbidden. It seems we might have made a bad request.";
                }
                case 404: {
                    return "The page could not be found. Are the URLs for the topology services correct?";
                }
                case 500: {
                    return "The server encountered an error. Are all of the cluster's services running? \nCan a connection be established without Knox?";
                }
            }
            return "";
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement
    public static class ServiceTestWrapper {
        @XmlElement(name="ServiceTest")
        @XmlElementWrapper(name="Tests")
        private List<ServiceTest> tests = new ArrayList<ServiceTest>();
        @XmlElement(name="message")
        @XmlElementWrapper(name="messages")
        private List<String> messages = new ArrayList<String>();

        public List<ServiceTest> getTests() {
            return this.tests;
        }

        public void setTests(List<ServiceTest> st) {
            this.tests = st;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public void setMessages(List<String> messages) {
            this.messages = messages;
        }
    }
}

