/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceTestURL {
    private static final Map<String, List<String>> urls;
    static final String WEBHDFS = "WEBHDFS";
    static final String OOZIE = "OOZIE";
    static final String YARN = "RESOURCEMANAGER";
    static final String WEBHCAT = "WEBHCAT";
    static final String HBASE = "WEBHBASE";
    static final String HIVE = "HIVE";
    static final String STORM = "STORM";

    static {
        HashMap<String, List<String>> urlMap = new HashMap<String, List<String>>();
        ArrayList<String> webhdfs = new ArrayList<String>();
        webhdfs.add("/webhdfs/v1/?op=LISTSTATUS");
        urlMap.put(WEBHDFS, webhdfs);
        ArrayList<String> oozie = new ArrayList<String>();
        oozie.add("/oozie/v1/admin/build-version");
        oozie.add("/oozie/versions");
        oozie.add("/oozie/v1/admin/status");
        urlMap.put(OOZIE, oozie);
        ArrayList<String> resourceManager = new ArrayList<String>();
        resourceManager.add("/resourcemanager/v1/cluster/info");
        resourceManager.add("/resourcemanager/v1/cluster/metrics");
        resourceManager.add("/resourcemanager/v1/cluster/apps");
        urlMap.put(YARN, resourceManager);
        ArrayList<String> templeton = new ArrayList<String>();
        templeton.add("/templeton/v1/status");
        templeton.add("/templeton/v1/version");
        templeton.add("/templeton/v1/version/hive");
        templeton.add("/templeton/v1/version/hadoop");
        urlMap.put(WEBHCAT, templeton);
        ArrayList<String> hbase = new ArrayList<String>();
        hbase.add("/hbase/version");
        hbase.add("/hbase/version/cluster");
        hbase.add("/hbase/status/cluster");
        hbase.add("/hbase");
        urlMap.put(HBASE, hbase);
        urls = urlMap;
    }

    public static List<String> get(String url) {
        return urls.get(url);
    }

    static enum GATEWAY_SERVICES {
        WEBHDFS,
        OOZIE,
        YARN,
        WEBHCAT,
        HBASE,
        HIVE,
        STORM;

    }
}

