/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.vault;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;

@Path(value="/vault/credentials")
public class CredentialResource {
    @Context
    private HttpServletRequest request;

    @GET
    @Path(value="{alias}")
    @Produces(value={"application/json", "application/xml"})
    public Response getCredential(@PathParam(value="alias") String alias) {
        if (alias != null && !alias.isEmpty()) {
            CredentialValue value = this.getCredentialValueForAlias(alias);
            if (value != null) {
                return Response.ok((Object)value).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please provide a credential alias in the path").type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getCredentials() {
        List<String> aliases = this.getCredentialsList();
        if (aliases != null) {
            return Response.ok(aliases).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private List<String> getCredentialsList() {
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        String clusterName = (String)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.cluster");
        AliasService as = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
        List aliases = null;
        try {
            aliases = as.getAliasesForCluster(clusterName);
        }
        catch (AliasServiceException e) {
            e.printStackTrace();
        }
        return aliases;
    }

    private CredentialValue getCredentialValueForAlias(String alias) {
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        String clusterName = (String)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.cluster");
        AliasService as = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
        char[] credential = null;
        try {
            credential = as.getPasswordFromAliasForCluster(clusterName, alias);
        }
        catch (AliasServiceException e) {
            e.printStackTrace();
        }
        if (credential != null) {
            return new CredentialValue(alias, new String(credential));
        }
        return null;
    }

    public static class CredentialValue {
        private String alias;
        private String credential;

        public CredentialValue(String alias, String credential) {
            this.alias = alias;
            this.credential = credential;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getCredential() {
            return this.credential;
        }

        public void setCredential(String credential) {
            this.credential = credential;
        }
    }
}

