/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.servlet.ServletTester;

public class TestUtils {
    private static final Logger LOG = Logger.getLogger(TestUtils.class);
    public static final long SHORT_TIMEOUT = 5000L;
    public static final long MEDIUM_TIMEOUT = 30000L;
    public static final long LONG_TIMEOUT = 60000L;

    private TestUtils() {
    }

    public static String getResourceName(Class clazz, String name) {
        return clazz.getName().replaceAll("\\.", "/") + "/" + name;
    }

    public static URL getResourceUrl(Class clazz, String name) throws FileNotFoundException {
        URL url = ClassLoader.getSystemResource(name = TestUtils.getResourceName(clazz, name));
        if (url == null) {
            throw new FileNotFoundException(name);
        }
        return url;
    }

    public static URL getResourceUrl(String name) throws FileNotFoundException {
        URL url = ClassLoader.getSystemResource(name);
        if (url == null) {
            throw new FileNotFoundException(name);
        }
        return url;
    }

    public static InputStream getResourceStream(String name) throws IOException {
        URL url = ClassLoader.getSystemResource(name);
        return url.openStream();
    }

    public static InputStream getResourceStream(Class clazz, String name) throws IOException {
        URL url = TestUtils.getResourceUrl(clazz, name);
        return url.openStream();
    }

    public static Reader getResourceReader(String name, Charset charset) throws IOException {
        return new InputStreamReader(TestUtils.getResourceStream(name), charset);
    }

    public static Reader getResourceReader(Class clazz, String name, Charset charset) throws IOException {
        return new InputStreamReader(TestUtils.getResourceStream(clazz, name), charset);
    }

    public static String getResourceString(Class clazz, String name, Charset charset) throws IOException {
        return IOUtils.toString((Reader)TestUtils.getResourceReader(clazz, name, charset));
    }

    public static File createTempDir(String prefix) throws IOException {
        File targetDir = new File(System.getProperty("user.dir"), "target");
        File tempDir = new File(targetDir, prefix + UUID.randomUUID());
        FileUtils.forceMkdir((File)tempDir);
        return tempDir;
    }

    public static void LOG_ENTER() {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        System.out.flush();
        System.out.println(String.format(Locale.ROOT, "Running %s#%s", caller.getClassName(), caller.getMethodName()));
        System.out.flush();
    }

    public static void LOG_EXIT() {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        System.out.flush();
        System.out.println(String.format(Locale.ROOT, "Exiting %s#%s", caller.getClassName(), caller.getMethodName()));
        System.out.flush();
    }

    public static void awaitPortOpen(InetSocketAddress address, int timeout, int delay) throws InterruptedException {
        long maxTime = System.currentTimeMillis() + (long)timeout;
        while (true) {
            try (Socket socket = new Socket();){
                socket.connect(address, delay);
                return;
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() < maxTime) continue;
                throw new IllegalStateException("Timed out " + timeout + " waiting for port " + address);
            }
            break;
        }
    }

    public static void awaitNon404HttpStatus(URL url, int timeout, int delay) throws InterruptedException {
        long maxTime = System.currentTimeMillis() + (long)timeout;
        while (true) {
            Thread.sleep(delay);
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.getInputStream().close();
                return;
            }
            catch (IOException e) {
                try {
                    if (conn != null && conn.getResponseCode() != 404) {
                        return;
                    }
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() < maxTime) continue;
                throw new IllegalStateException("Timed out " + timeout + " waiting for URL " + url);
            }
            break;
        }
    }

    public static String merge(String resource, Properties properties) {
        ClasspathResourceLoader loader = new ClasspathResourceLoader();
        loader.getResourceStream(resource);
        VelocityEngine engine = new VelocityEngine();
        Properties config = new Properties();
        config.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
        config.setProperty("resource.loader", "classpath");
        config.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        engine.init(config);
        VelocityContext context = new VelocityContext((Map)properties);
        Template template = engine.getTemplate(resource);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    public static String merge(Class base, String resource, Properties properties) {
        String baseResource = base.getName().replaceAll("\\.", "/");
        String fullResource = baseResource + "/" + resource;
        return TestUtils.merge(fullResource, properties);
    }

    public static int findFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static boolean waitUntil(Callable<Boolean> function, boolean expected, long timeout) throws Exception {
        long before = System.currentTimeMillis();
        while (System.currentTimeMillis() - before < timeout) {
            if (function.call() == expected) {
                return expected;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    public static void waitUntilNextSecond() {
        long wait;
        long before = System.currentTimeMillis();
        while ((wait = 1000L - (System.currentTimeMillis() - before)) > 0L) {
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static HttpTester.Response execute(ServletTester server, HttpTester.Request request) throws Exception {
        LOG.debug((Object)("execute: request=" + request));
        ByteBuffer requestBuffer = request.generate();
        LOG.trace((Object)("execute: requestBuffer=[" + new String(requestBuffer.array(), 0, requestBuffer.limit(), StandardCharsets.UTF_8) + "]"));
        ByteBuffer responseBuffer = server.getResponses(requestBuffer, 30L, TimeUnit.SECONDS);
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        LOG.trace((Object)("execute: responseBuffer=[" + new String(responseBuffer.array(), 0, responseBuffer.limit(), StandardCharsets.UTF_8) + "]"));
        LOG.debug((Object)("execute: reponse=" + response));
        return response;
    }
}

