/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.test.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Source;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.knox.test.mock.MockResponseProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.xmlmatchers.XmlMatchers;
import org.xmlmatchers.transform.XmlConverters;
import uk.co.datumedge.hamcrest.json.SameJSONAs;

public class MockRequestMatcher {
    private String from;
    private MockResponseProvider response;
    private Set<String> methods;
    private String pathInfo;
    private String requestURI;
    private String requestURL;
    Map<String, Matcher> headers;
    Set<Cookie> cookies;
    private Map<String, Object> attributes;
    private Map<String, String> queryParams;
    private String contentType;
    private String characterEncoding;
    private Integer contentLength;
    private byte[] entity;
    private Map<String, String[]> formParams;

    public MockRequestMatcher(MockResponseProvider response) {
        this.response = response;
    }

    public MockResponseProvider respond() {
        return this.response;
    }

    public MockRequestMatcher from(String from) {
        this.from = from;
        return this;
    }

    public MockRequestMatcher method(String ... methods) {
        if (this.methods == null) {
            this.methods = new HashSet<String>();
        }
        if (methods != null) {
            Collections.addAll(this.methods, methods);
        }
        return this;
    }

    public MockRequestMatcher pathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
        return this;
    }

    public MockRequestMatcher requestURI(String requestURI) {
        this.requestURI = requestURI;
        return this;
    }

    public MockRequestMatcher requestUrl(String requestUrl) {
        this.requestURL = requestUrl;
        return this;
    }

    public MockRequestMatcher header(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Matcher>();
        }
        this.headers.put(name, Matchers.is((Object)value));
        return this;
    }

    public MockRequestMatcher header(String name, Matcher matcher) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Matcher>();
        }
        this.headers.put(name, matcher);
        return this;
    }

    public MockRequestMatcher cookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new HashSet<Cookie>();
        }
        this.cookies.add(cookie);
        return this;
    }

    public MockRequestMatcher attribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
        return this;
    }

    public MockRequestMatcher queryParam(String name, String value) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String>();
        }
        this.queryParams.put(name, value);
        return this;
    }

    public MockRequestMatcher formParam(String name, String ... values) {
        Object[] currentValues;
        if (this.entity != null) {
            throw new IllegalStateException("Entity already specified.");
        }
        if (this.formParams == null) {
            this.formParams = new HashMap<String, String[]>();
        }
        if ((currentValues = this.formParams.get(name)) == null) {
            currentValues = values;
        } else if (values != null) {
            currentValues = (String[])ArrayUtils.addAll((Object[])currentValues, (Object[])values);
        }
        this.formParams.put(name, (String[])currentValues);
        return this;
    }

    public MockRequestMatcher content(String string, Charset charset) {
        this.content(string.getBytes(charset));
        return this;
    }

    public MockRequestMatcher content(byte[] entity) {
        if (this.formParams != null) {
            throw new IllegalStateException("Form params already specified.");
        }
        this.entity = entity;
        return this;
    }

    public MockRequestMatcher content(URL url) throws IOException {
        this.content(url.openStream());
        return this;
    }

    public MockRequestMatcher content(InputStream stream) throws IOException {
        this.content(IOUtils.toByteArray((InputStream)stream));
        return this;
    }

    public MockRequestMatcher contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public MockRequestMatcher contentLength(int length) {
        this.contentLength = length;
        return this;
    }

    public MockRequestMatcher characterEncoding(String charset) {
        this.characterEncoding = charset;
        return this;
    }

    public void match(HttpServletRequest request) throws IOException {
        if (this.methods != null) {
            MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " is not using one of the expected HTTP methods"), this.methods, (Matcher)CoreMatchers.hasItem((Object)request.getMethod()));
        }
        if (this.pathInfo != null) {
            MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " does not have the expected pathInfo"), (Object)request.getPathInfo(), (Matcher)CoreMatchers.is((Object)this.pathInfo));
        }
        if (this.requestURI != null) {
            MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " does not have the expected requestURI"), (Object)request.getRequestURI(), (Matcher)CoreMatchers.is((Object)this.requestURI));
        }
        if (this.requestURL != null) {
            MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " does not have the expected requestURL"), (Object)request.getRequestURL().toString(), (Matcher)CoreMatchers.is((Object)this.requestURL));
        }
        if (this.headers != null) {
            for (Map.Entry<String, Matcher> entry : this.headers.entrySet()) {
                MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " does not have the expected value for header " + entry.getKey()), (Object)request.getHeader(entry.getKey()), (Matcher)entry.getValue());
            }
        }
        if (this.cookies != null) {
            List<Cookie> requestCookies = Arrays.asList(request.getCookies());
            for (Cookie cookie : this.cookies) {
                MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " does not have the expected cookie " + cookie), requestCookies, (Matcher)CoreMatchers.hasItem((Object)cookie));
            }
        }
        if (this.contentType != null) {
            String[] requestContentType = request.getContentType().split(";", 2);
            MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " does not have the expected content type"), (Object)requestContentType[0], (Matcher)CoreMatchers.is((Object)this.contentType));
        }
        if (this.characterEncoding != null) {
            MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " does not have the expected character encoding"), (Object)request.getCharacterEncoding(), (Matcher)Matchers.equalToIgnoringCase((String)this.characterEncoding));
        }
        if (this.contentLength != null) {
            MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " does not have the expected content length"), (Object)request.getContentLength(), (Matcher)CoreMatchers.is((Object)this.contentLength));
        }
        if (this.attributes != null) {
            for (String string : this.attributes.keySet()) {
                MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " is missing attribute '" + string + "'"), (Object)request.getAttribute(string), (Matcher)CoreMatchers.notNullValue());
                MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " has wrong value for attribute '" + string + "'"), (Object)request.getAttribute(string), (Matcher)CoreMatchers.is((Object)request.getAttribute(string)));
            }
        }
        if (this.queryParams != null) {
            String queryString = request.getQueryString();
            List<NameValuePair> list = MockRequestMatcher.parseQueryString(queryString == null ? "" : queryString);
            for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
                MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " query string " + queryString + " is missing parameter '" + entry.getKey() + "'"), list, (Matcher)CoreMatchers.hasItem((Object)new BasicNameValuePair(entry.getKey(), entry.getValue())));
            }
        }
        if (this.formParams != null) {
            String paramString = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            List<NameValuePair> list = MockRequestMatcher.parseQueryString(paramString == null ? "" : paramString);
            for (Map.Entry<String, String[]> entry : this.formParams.entrySet()) {
                String[] expectedValues;
                for (String expectedValue : expectedValues = entry.getValue()) {
                    MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " form params " + paramString + " is missing a value " + expectedValue + " for parameter '" + entry.getKey() + "'"), list, (Matcher)CoreMatchers.hasItem((Object)new BasicNameValuePair(entry.getKey(), expectedValue)));
                }
            }
        }
        if (this.entity != null) {
            String expectEncoding;
            if (this.contentType != null && this.contentType.endsWith("/xml")) {
                expectEncoding = this.characterEncoding;
                String string = new String(this.entity, expectEncoding == null ? StandardCharsets.UTF_8.name() : expectEncoding);
                String string2 = request.getCharacterEncoding();
                String string3 = IOUtils.toString((InputStream)request.getInputStream(), (String)(string2 == null ? StandardCharsets.UTF_8.name() : string2));
                MatcherAssert.assertThat((Object)XmlConverters.the((String)string3), (Matcher)XmlMatchers.isEquivalentTo((Source)XmlConverters.the((String)string)));
            } else if (this.contentType != null && this.contentType.endsWith("/json")) {
                expectEncoding = this.characterEncoding;
                String string = new String(this.entity, expectEncoding == null ? StandardCharsets.UTF_8.name() : expectEncoding);
                String string4 = request.getCharacterEncoding();
                String string5 = IOUtils.toString((InputStream)request.getInputStream(), (String)(string4 == null ? StandardCharsets.UTF_8.name() : string4));
                MatcherAssert.assertThat((Object)string5, (Matcher)SameJSONAs.sameJSONAs((String)string));
            } else if (this.characterEncoding == null || request.getCharacterEncoding() == null) {
                byte[] bytes = IOUtils.toByteArray((InputStream)request.getInputStream());
                MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " content does not match the expected content"), (Object)bytes, (Matcher)CoreMatchers.is((Object)this.entity));
            } else {
                String expect2 = new String(this.entity, this.characterEncoding);
                String string = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
                MatcherAssert.assertThat((String)("Request " + request.getMethod() + " " + request.getRequestURL() + " content does not match the expected content"), (Object)string, (Matcher)CoreMatchers.is((Object)expect2));
            }
        }
    }

    public String toString() {
        return "from=" + this.from + ", pathInfo=" + this.pathInfo + ", requestURI=" + this.requestURI;
    }

    private static List<NameValuePair> parseQueryString(String queryString) {
        return URLEncodedUtils.parse((String)queryString, (Charset)Charset.defaultCharset());
    }
}

