/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.test.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class MockResponseProvider {
    Integer errorCode;
    String errorMsg;
    Integer statusCode;
    String redirectUrl;
    Map<String, String> headers;
    Set<Cookie> cookies;
    byte[] entity;
    String contentType;
    String characterEncoding;
    Integer contentLength;

    public MockResponseProvider status(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public MockResponseProvider error(int code, String message) {
        this.errorCode = code;
        this.errorMsg = message;
        return this;
    }

    public MockResponseProvider redirect(String location) {
        this.redirectUrl = location;
        return this;
    }

    public MockResponseProvider header(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public MockResponseProvider cookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new HashSet<Cookie>();
        }
        this.cookies.add(cookie);
        return this;
    }

    public MockResponseProvider content(byte[] entity) {
        this.entity = entity;
        return this;
    }

    public MockResponseProvider content(String string, Charset charset) {
        this.entity = string.getBytes(charset);
        return this;
    }

    public MockResponseProvider content(URL url) throws IOException {
        this.content(url.openStream());
        return this;
    }

    public MockResponseProvider content(InputStream stream) throws IOException {
        this.content(IOUtils.toByteArray((InputStream)stream));
        return this;
    }

    public MockResponseProvider contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public MockResponseProvider contentLength(int contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public MockResponseProvider characterEncoding(String charset) {
        this.characterEncoding = charset;
        return this;
    }

    public void apply(HttpServletResponse response) throws IOException {
        if (this.statusCode != null) {
            response.setStatus(this.statusCode.intValue());
        } else {
            response.setStatus(200);
        }
        if (this.errorCode != null) {
            if (this.errorMsg != null) {
                response.sendError(this.errorCode.intValue(), this.errorMsg);
            } else {
                response.sendError(this.errorCode.intValue());
            }
        }
        if (this.redirectUrl != null) {
            response.sendRedirect(this.redirectUrl);
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                response.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (this.cookies != null) {
            for (Cookie cookie : this.cookies) {
                response.addCookie(cookie);
            }
        }
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
        if (this.characterEncoding != null) {
            response.setCharacterEncoding(this.characterEncoding);
        }
        if (this.contentLength != null) {
            response.setContentLength(this.contentLength.intValue());
        }
        response.flushBuffer();
        if (this.entity != null) {
            try (ServletOutputStream outputStream = response.getOutputStream();){
                outputStream.write(this.entity);
            }
        }
    }
}

