/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class Console {
    PrintStream oldOut;
    PrintStream newOut;
    PrintStream oldErr;
    PrintStream newErr;
    ByteArrayOutputStream newOutBuf;
    ByteArrayOutputStream newErrBuf;

    public void capture() throws UnsupportedEncodingException {
        this.oldErr = System.err;
        this.newErrBuf = new ByteArrayOutputStream();
        this.newErr = new PrintStream((OutputStream)this.newErrBuf, false, StandardCharsets.UTF_8.name());
        this.oldOut = System.out;
        this.newOutBuf = new ByteArrayOutputStream();
        this.newOut = new PrintStream((OutputStream)this.newOutBuf, false, StandardCharsets.UTF_8.name());
        System.setErr(this.newErr);
        System.setOut(this.newOut);
    }

    public byte[] getOut() {
        return this.newOutBuf.toByteArray();
    }

    public byte[] getErr() {
        return this.newErrBuf.toByteArray();
    }

    public void release() {
        System.setErr(this.oldErr);
        System.setOut(this.oldOut);
        this.newErr.close();
        this.newOut.close();
    }
}

