/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.knox.gateway.launcher.Forker;
import org.apache.knox.gateway.launcher.Invoker;

class Command {
    private static final String MAIN_CLASS = "main.class";
    private static final String MAIN_METHOD = "main.method";
    private static final String MAIN_ARGS = "main.args";
    private static final String CLASS_PATH = "class.path";
    private static final String CLASS_PATH_DELIM = ",;";
    private static final String FORK = "fork";
    private static final String REDIRECT = "redirect";
    private static final String RESTREAM = "restream";
    private static final String ENV_PREFIX = "env.";
    private static final int ENV_PREFIX_LENGTH = "env.".length();
    File base;
    String mainClass;
    String mainMethod = "main";
    String[] mainArgs;
    List<URL> classPath;
    Properties props;
    Map<String, String> vars;
    Boolean fork = Boolean.FALSE;
    Boolean redirect = Boolean.FALSE;
    Boolean restream = Boolean.TRUE;

    Command(File base, Properties config, String[] args) throws MalformedURLException {
        this.base = base;
        this.mainArgs = args;
        this.consumeConfig(config);
    }

    void consumeConfig(Properties config) throws MalformedURLException {
        this.mainClass = config.getProperty(MAIN_CLASS);
        config.remove(MAIN_CLASS);
        this.mainMethod = config.getProperty(MAIN_METHOD, this.mainMethod);
        config.remove(MAIN_METHOD);
        this.mainArgs = Command.loadMainArgs(this.mainArgs, config.getProperty(MAIN_ARGS));
        config.remove(MAIN_ARGS);
        this.classPath = Command.loadClassPath(this.base, config.getProperty(CLASS_PATH));
        config.remove(CLASS_PATH);
        this.fork = Boolean.valueOf(config.getProperty(FORK, this.fork.toString()));
        config.remove(FORK);
        this.redirect = Boolean.valueOf(config.getProperty(REDIRECT, this.redirect.toString()));
        config.remove(REDIRECT);
        this.restream = Boolean.valueOf(config.getProperty(RESTREAM, this.restream.toString()));
        config.remove(RESTREAM);
        this.consumeSysPropsAndEnvVars(config);
    }

    void consumeSysPropsAndEnvVars(Properties config) {
        this.props = new Properties();
        this.vars = new HashMap<String, String>();
        for (String name : config.stringPropertyNames()) {
            String value = config.getProperty(name);
            if (name.startsWith(ENV_PREFIX)) {
                this.vars.put(name.substring(ENV_PREFIX_LENGTH), value);
                continue;
            }
            this.props.setProperty(name, value);
        }
    }

    public void run() throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException {
        if (this.fork.booleanValue()) {
            Forker.fork(this);
        } else {
            Invoker.invoke(this);
        }
    }

    private static String[] loadMainArgs(String[] current, String override) {
        String[] args = current;
        if ((args == null || args.length == 0) && override != null) {
            args = override.split(" ");
        }
        return args;
    }

    private static List<URL> loadClassPath(File base, String classPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer parser = new StringTokenizer(classPath, CLASS_PATH_DELIM, false);
        while (parser.hasMoreTokens()) {
            File libDir;
            File[] libFiles;
            String libPath = parser.nextToken().trim();
            File libFile = new File(base, libPath);
            if (libFile.canRead() && (libFile.isFile() || libFile.isDirectory())) {
                urls.add(libFile.toURI().toURL());
                continue;
            }
            if (!libPath.endsWith("*") && !libPath.endsWith("*.jar") || (libFiles = (libDir = libFile.getParentFile()).listFiles(new WildcardFilenameFilter(libFile.getName()))) == null) continue;
            File[] fileArray = libFiles;
            int n = libFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                urls.add(file.toURI().toURL());
                ++n2;
            }
        }
        return urls;
    }

    private static class WildcardFilenameFilter
    implements FilenameFilter {
        private static String SAFE = new String(new char[1]);
        private Pattern pattern;

        WildcardFilenameFilter(String filter) {
            filter = filter.replace(".", SAFE);
            filter = filter.replace("*", ".*");
            filter = filter.replace(SAFE, "\\.");
            this.pattern = Pattern.compile(filter);
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.pattern.matcher(name).matches();
        }
    }
}

