/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.shaded.com.google.common.base.MoreObjects;
import org.apache.kudu.client.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.client.shaded.com.google.common.primitives.UnsignedBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@ThreadSafe
class TableLocationsCache {
    private static final Logger LOG = LoggerFactory.getLogger(TableLocationsCache.class);
    private static final Comparator<byte[]> COMPARATOR = UnsignedBytes.lexicographicalComparator();
    private final Object monitor = new Object();
    @GuardedBy(value="monitor")
    private final NavigableMap<byte[], Entry> entries = new TreeMap<byte[], Entry>(COMPARATOR);

    TableLocationsCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(byte[] partitionKey) {
        Map.Entry<byte[], Entry> entry;
        if (partitionKey == null) {
            Object object = this.monitor;
            synchronized (object) {
                Preconditions.checkState(this.entries.size() <= 1);
                return (Entry)this.entries.get(AsyncKuduClient.EMPTY_ARRAY);
            }
        }
        Object object = this.monitor;
        synchronized (object) {
            entry = this.entries.floorEntry(partitionKey);
        }
        if (entry == null || entry.getValue().getUpperBoundPartitionKey().length > 0 && Bytes.memcmp(partitionKey, entry.getValue().getUpperBoundPartitionKey()) >= 0 || entry.getValue().isStale()) {
            return null;
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheTabletLocations(List<AsyncKuduClient.RemoteTablet> tablets, byte[] requestPartitionKey, long ttl) {
        long deadline = System.nanoTime() + ttl * TimeUnit.MILLISECONDS.toNanos(1L);
        if (requestPartitionKey == null) {
            Preconditions.checkArgument(tablets.size() == 1);
            Entry entry = Entry.tablet(tablets.get(0), TimeUnit.DAYS.toMillis(1L));
            Object object = this.monitor;
            synchronized (object) {
                this.entries.clear();
                this.entries.put(AsyncKuduClient.EMPTY_ARRAY, entry);
            }
            return;
        }
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        if (tablets.isEmpty()) {
            newEntries.add(Entry.nonCoveredRange(AsyncKuduClient.EMPTY_ARRAY, AsyncKuduClient.EMPTY_ARRAY, deadline));
        } else {
            byte[] firstLowerBound = tablets.get(0).getPartition().getPartitionKeyStart();
            if (Bytes.memcmp(requestPartitionKey, firstLowerBound) < 0) {
                newEntries.add(Entry.nonCoveredRange(AsyncKuduClient.EMPTY_ARRAY, firstLowerBound, deadline));
            }
            byte[] lastUpperBound = firstLowerBound;
            for (AsyncKuduClient.RemoteTablet tablet : tablets) {
                byte[] tabletLowerBound = tablet.getPartition().getPartitionKeyStart();
                byte[] tabletUpperBound = tablet.getPartition().getPartitionKeyEnd();
                if (Bytes.memcmp(lastUpperBound, tabletLowerBound) < 0) {
                    newEntries.add(Entry.nonCoveredRange(lastUpperBound, tabletLowerBound, deadline));
                }
                lastUpperBound = tabletUpperBound;
                newEntries.add(Entry.tablet(tablet, deadline));
            }
            if (lastUpperBound.length > 0 && tablets.size() < 10) {
                newEntries.add(Entry.nonCoveredRange(lastUpperBound, AsyncKuduClient.EMPTY_ARRAY, deadline));
            }
        }
        byte[] discoveredlowerBound = ((Entry)newEntries.get(0)).getLowerBoundPartitionKey();
        byte[] discoveredUpperBound = ((Entry)newEntries.get(newEntries.size() - 1)).getUpperBoundPartitionKey();
        LOG.debug("Discovered table locations:\t{}", newEntries);
        Object object = this.monitor;
        synchronized (object) {
            Map.Entry<byte[], Entry> floorEntry = this.entries.floorEntry(discoveredlowerBound);
            if (floorEntry != null && Bytes.memcmp(requestPartitionKey, floorEntry.getValue().getUpperBoundPartitionKey()) < 0) {
                discoveredlowerBound = floorEntry.getKey();
            }
            NavigableMap<byte[], Entry> overlappingEntries = this.entries.tailMap(discoveredlowerBound, true);
            if (discoveredUpperBound.length > 0) {
                overlappingEntries = overlappingEntries.headMap(discoveredUpperBound, false);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Existing table locations:\t\t{}", this.entries.values());
                LOG.trace("Removing table locations:\t\t{}", overlappingEntries.values());
            }
            overlappingEntries.clear();
            for (Entry entry : newEntries) {
                this.entries.put(entry.getLowerBoundPartitionKey(), entry);
            }
        }
    }

    public String toString() {
        return this.entries.values().toString();
    }

    public static class Entry {
        private final AsyncKuduClient.RemoteTablet tablet;
        private final byte[] lowerBoundPartitionKey;
        private final byte[] upperBoundPartitionKey;
        private final long deadline;

        private Entry(AsyncKuduClient.RemoteTablet tablet, byte[] lowerBoundPartitionKey, byte[] upperBoundPartitionKey, long deadline) {
            this.tablet = tablet;
            this.lowerBoundPartitionKey = lowerBoundPartitionKey;
            this.upperBoundPartitionKey = upperBoundPartitionKey;
            this.deadline = deadline;
        }

        public static Entry nonCoveredRange(byte[] lowerBoundPartitionKey, byte[] upperBoundPartitionKey, long deadline) {
            return new Entry(null, lowerBoundPartitionKey, upperBoundPartitionKey, deadline);
        }

        public static Entry tablet(AsyncKuduClient.RemoteTablet tablet, long deadline) {
            return new Entry(tablet, null, null, deadline);
        }

        public boolean isNonCoveredRange() {
            return this.tablet == null;
        }

        public AsyncKuduClient.RemoteTablet getTablet() {
            return this.tablet;
        }

        public byte[] getLowerBoundPartitionKey() {
            return this.tablet == null ? this.lowerBoundPartitionKey : this.tablet.getPartition().getPartitionKeyStart();
        }

        public byte[] getUpperBoundPartitionKey() {
            return this.tablet == null ? this.upperBoundPartitionKey : this.tablet.getPartition().getPartitionKeyEnd();
        }

        private long ttl() {
            return TimeUnit.NANOSECONDS.toMillis(this.deadline - System.nanoTime());
        }

        public boolean isStale() {
            return this.ttl() <= 0L;
        }

        public String toString() {
            if (this.isNonCoveredRange()) {
                return MoreObjects.toStringHelper("NonCoveredRange").add("lowerBoundPartitionKey", Bytes.hex(this.lowerBoundPartitionKey)).add("upperBoundPartitionKey", Bytes.hex(this.upperBoundPartitionKey)).add("ttl", this.ttl()).toString();
            }
            return MoreObjects.toStringHelper("Tablet").add("lowerBoundPartitionKey", Bytes.hex(this.getLowerBoundPartitionKey())).add("upperBoundPartitionKey", Bytes.hex(this.getUpperBoundPartitionKey())).add("tablet-id", this.tablet.getTabletIdAsString()).add("ttl", this.ttl()).toString();
        }
    }
}

