/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.GetTableStatisticsResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.org.jboss.netty.util.Timer;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class GetTableStatisticsRequest
extends KuduRpc<GetTableStatisticsResponse> {
    static final String GET_TABLE_STATISTICS = "GetTableStatistics";
    private final String name;

    GetTableStatisticsRequest(KuduTable table, String name, Timer timer, long timeoutMillis) {
        super(table, timer, timeoutMillis);
        this.name = name;
    }

    @Override
    Message createRequestPB() {
        Master.GetTableStatisticsRequestPB.Builder builder = Master.GetTableStatisticsRequestPB.newBuilder();
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        builder.setTable(tableID);
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return GET_TABLE_STATISTICS;
    }

    @Override
    Pair<GetTableStatisticsResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.GetTableStatisticsResponsePB.Builder respBuilder = Master.GetTableStatisticsResponsePB.newBuilder();
        GetTableStatisticsRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        GetTableStatisticsResponse response = new GetTableStatisticsResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, respBuilder.getOnDiskSize(), respBuilder.getLiveRowCount());
        return new Pair<GetTableStatisticsResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

