/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.binder.system;

import java.io.File;
import java.util.Collections;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Gauge;
import org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Tag;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Tags;
import org.apache.kudu.shaded.io.micrometer.core.instrument.binder.MeterBinder;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullApi;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class DiskSpaceMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;
    private final File path;
    private final String absolutePath;

    public DiskSpaceMetrics(File path) {
        this(path, Collections.emptyList());
    }

    public DiskSpaceMetrics(File path, Iterable<Tag> tags) {
        this.path = path;
        this.absolutePath = path.getAbsolutePath();
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Tags tagsWithPath = Tags.concat(this.tags, "path", this.absolutePath);
        Gauge.builder("disk.free", this.path, File::getUsableSpace).tags(tagsWithPath).description("Usable space for path").baseUnit("bytes").strongReference(true).register(registry);
        Gauge.builder("disk.total", this.path, File::getTotalSpace).tags(tagsWithPath).description("Total space for path").baseUnit("bytes").strongReference(true).register(registry);
    }
}

