/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.List;
import org.apache.kudu.Common;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RangePartition;
import org.apache.kudu.client.RangePartitionBound;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RangePartitionWithCustomHashSchema
extends RangePartition {
    private Common.PartitionSchemaPB.RangeWithHashSchemaPB.Builder pb = Common.PartitionSchemaPB.RangeWithHashSchemaPB.newBuilder();

    public RangePartitionWithCustomHashSchema(PartialRow lowerBound, PartialRow upperBound, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
        super(lowerBound, upperBound, lowerBoundType, upperBoundType);
        this.pb.setRangeBounds(new Operation.OperationsEncoder().encodeLowerAndUpperBounds(lowerBound, upperBound, lowerBoundType, upperBoundType));
    }

    public RangePartition addHashPartitions(List<String> columns, int numBuckets, int seed) {
        Common.PartitionSchemaPB.HashBucketSchemaPB.Builder b = this.pb.addHashSchemaBuilder();
        for (String column : columns) {
            b.addColumnsBuilder().setName(column);
        }
        b.setNumBuckets(numBuckets);
        b.setSeed(seed);
        return this;
    }

    public Common.PartitionSchemaPB.RangeWithHashSchemaPB toPB() {
        return this.pb.build();
    }
}

