/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.Status;

@InterfaceAudience.Private
class NonCoveredRangeException
extends NonRecoverableException {
    private final byte[] nonCoveredRangeStart;
    private final byte[] nonCoveredRangeEnd;

    public NonCoveredRangeException(byte[] nonCoveredRangeStart, byte[] nonCoveredRangeEnd) {
        super(Status.NotFound("non-covered range"));
        this.nonCoveredRangeStart = nonCoveredRangeStart;
        this.nonCoveredRangeEnd = nonCoveredRangeEnd;
    }

    byte[] getNonCoveredRangeStart() {
        return this.nonCoveredRangeStart;
    }

    byte[] getNonCoveredRangeEnd() {
        return this.nonCoveredRangeEnd;
    }

    @Override
    public String toString() {
        return String.format("NonCoveredRangeException([%s, %s))", this.nonCoveredRangeStart.length == 0 ? "<start>" : Bytes.hex(this.nonCoveredRangeStart), this.nonCoveredRangeEnd.length == 0 ? "<end>" : Bytes.hex(this.nonCoveredRangeEnd));
    }
}

