/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client.shaded.org.jboss.netty.channel.socket.oio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.regex.Pattern;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channels;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.DefaultFileRegion;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.FileRegion;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.socket.oio.AbstractOioWorker;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.socket.oio.OioAcceptedSocketChannel;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.socket.oio.OioSocketChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OioWorker
extends AbstractOioWorker<OioSocketChannel> {
    private static final Pattern SOCKET_CLOSED_MESSAGE = Pattern.compile("^.*(?:Socket.*closed).*$", 2);

    OioWorker(OioSocketChannel channel) {
        super(channel);
    }

    @Override
    public void run() {
        boolean fireConnected = this.channel instanceof OioAcceptedSocketChannel;
        if (fireConnected && ((OioSocketChannel)this.channel).isOpen()) {
            Channels.fireChannelConnected(this.channel, (SocketAddress)((OioSocketChannel)this.channel).getRemoteAddress());
        }
        super.run();
    }

    @Override
    boolean process() throws IOException {
        PushbackInputStream in = ((OioSocketChannel)this.channel).getInputStream();
        int bytesToRead = in.available();
        if (bytesToRead <= 0) {
            int b = in.read();
            if (b < 0) {
                return false;
            }
            in.unread(b);
            return true;
        }
        byte[] buf = new byte[bytesToRead];
        int readBytes = in.read(buf);
        Channels.fireMessageReceived(this.channel, (Object)((OioSocketChannel)this.channel).getConfig().getBufferFactory().getBuffer(buf, 0, readBytes));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(OioSocketChannel channel, ChannelFuture future, Object message) {
        boolean iothread = OioWorker.isIoThread(channel);
        OutputStream out = channel.getOutputStream();
        if (out == null) {
            ClosedChannelException e = new ClosedChannelException();
            future.setFailure(e);
            if (iothread) {
                Channels.fireExceptionCaught(channel, (Throwable)e);
            } else {
                Channels.fireExceptionCaughtLater(channel, (Throwable)e);
            }
            return;
        }
        try {
            int length;
            block21: {
                block20: {
                    DefaultFileRegion dfr2;
                    length = 0;
                    if (!(message instanceof FileRegion)) break block20;
                    FileRegion fr = (FileRegion)message;
                    try {
                        OutputStream outputStream = out;
                        synchronized (outputStream) {
                            long i;
                            WritableByteChannel bchannel = java.nio.channels.Channels.newChannel(out);
                            while ((i = fr.transferTo(bchannel, length)) > 0L && (long)(length = (int)((long)length + i)) < fr.getCount()) {
                            }
                        }
                        Object var13_16 = null;
                    }
                    catch (Throwable throwable) {
                        DefaultFileRegion dfr2;
                        Object var13_17 = null;
                        if (fr instanceof DefaultFileRegion && (dfr2 = (DefaultFileRegion)fr).releaseAfterTransfer()) {
                            fr.releaseExternalResources();
                        }
                        throw throwable;
                    }
                    if (fr instanceof DefaultFileRegion && (dfr2 = (DefaultFileRegion)fr).releaseAfterTransfer()) {
                        fr.releaseExternalResources();
                    }
                    break block21;
                }
                ChannelBuffer a = (ChannelBuffer)message;
                length = a.readableBytes();
                OutputStream outputStream = out;
                synchronized (outputStream) {
                    a.getBytes(a.readerIndex(), out, length);
                }
            }
            future.setSuccess();
            if (iothread) {
                Channels.fireWriteComplete(channel, (long)length);
            } else {
                Channels.fireWriteCompleteLater(channel, length);
            }
        }
        catch (Throwable t2) {
            ClosedChannelException t2;
            if (t2 instanceof SocketException && SOCKET_CLOSED_MESSAGE.matcher(String.valueOf(t2.getMessage())).matches()) {
                t2 = new ClosedChannelException();
            }
            future.setFailure(t2);
            if (iothread) {
                Channels.fireExceptionCaught(channel, (Throwable)t2);
            }
            Channels.fireExceptionCaughtLater(channel, (Throwable)t2);
        }
    }
}

