/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class IsCreateTableDoneRequest
extends KuduRpc<Master.IsCreateTableDoneResponsePB> {
    private final String tableId;

    IsCreateTableDoneRequest(KuduTable table, String tableId) {
        super(table);
        this.tableId = tableId;
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "IsCreateTableDone";
    }

    @Override
    Pair<Master.IsCreateTableDoneResponsePB, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.IsCreateTableDoneResponsePB.Builder builder = Master.IsCreateTableDoneResponsePB.newBuilder();
        IsCreateTableDoneRequest.readProtobuf(callResponse.getPBMessage(), builder);
        Master.IsCreateTableDoneResponsePB resp = builder.build();
        return new Pair<Master.IsCreateTableDoneResponsePB, Object>(resp, builder.hasError() ? builder.getError() : null);
    }

    @Override
    Message createRequestPB() {
        Master.IsCreateTableDoneRequestPB.Builder builder = Master.IsCreateTableDoneRequestPB.newBuilder();
        builder.setTable(Master.TableIdentifierPB.newBuilder().setTableId(ByteString.copyFromUtf8(this.tableId)));
        return builder.build();
    }
}

