// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: kudu/tablet/metadata.proto

package org.apache.kudu.tablet;

public final class Metadata {
  private Metadata() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * State flags indicating whether the tablet is in the middle of being copied
   * and is therefore not possible to bring up, whether it has been deleted, or
   * whether the data is in a usable state.
   * </pre>
   *
   * Protobuf enum {@code kudu.tablet.TabletDataState}
   */
  public enum TabletDataState
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>TABLET_DATA_UNKNOWN = 999;</code>
     */
    TABLET_DATA_UNKNOWN(999),
    /**
     * <pre>
     * The tablet is set to TABLET_DATA_COPYING state when in the middle of
     * copying data files from a remote peer. If a tablet server crashes with
     * a tablet in this state, the tablet must be deleted and
     * the Tablet Copy process must be restarted for that tablet.
     * </pre>
     *
     * <code>TABLET_DATA_COPYING = 0;</code>
     */
    TABLET_DATA_COPYING(0),
    /**
     * <pre>
     * Fresh empty tablets and successfully copied tablets are set to the
     * TABLET_DATA_READY state.
     * </pre>
     *
     * <code>TABLET_DATA_READY = 1;</code>
     */
    TABLET_DATA_READY(1),
    /**
     * <pre>
     * This tablet is in the process of being deleted.
     * The tablet server should "roll forward" the deletion during boot,
     * rather than trying to load the tablet.
     * </pre>
     *
     * <code>TABLET_DATA_DELETED = 2;</code>
     */
    TABLET_DATA_DELETED(2),
    /**
     * <pre>
     * The tablet has been deleted, and now just consists of a "tombstone".
     * </pre>
     *
     * <code>TABLET_DATA_TOMBSTONED = 3;</code>
     */
    TABLET_DATA_TOMBSTONED(3),
    ;

    /**
     * <code>TABLET_DATA_UNKNOWN = 999;</code>
     */
    public static final int TABLET_DATA_UNKNOWN_VALUE = 999;
    /**
     * <pre>
     * The tablet is set to TABLET_DATA_COPYING state when in the middle of
     * copying data files from a remote peer. If a tablet server crashes with
     * a tablet in this state, the tablet must be deleted and
     * the Tablet Copy process must be restarted for that tablet.
     * </pre>
     *
     * <code>TABLET_DATA_COPYING = 0;</code>
     */
    public static final int TABLET_DATA_COPYING_VALUE = 0;
    /**
     * <pre>
     * Fresh empty tablets and successfully copied tablets are set to the
     * TABLET_DATA_READY state.
     * </pre>
     *
     * <code>TABLET_DATA_READY = 1;</code>
     */
    public static final int TABLET_DATA_READY_VALUE = 1;
    /**
     * <pre>
     * This tablet is in the process of being deleted.
     * The tablet server should "roll forward" the deletion during boot,
     * rather than trying to load the tablet.
     * </pre>
     *
     * <code>TABLET_DATA_DELETED = 2;</code>
     */
    public static final int TABLET_DATA_DELETED_VALUE = 2;
    /**
     * <pre>
     * The tablet has been deleted, and now just consists of a "tombstone".
     * </pre>
     *
     * <code>TABLET_DATA_TOMBSTONED = 3;</code>
     */
    public static final int TABLET_DATA_TOMBSTONED_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TabletDataState valueOf(int value) {
      return forNumber(value);
    }

    public static TabletDataState forNumber(int value) {
      switch (value) {
        case 999: return TABLET_DATA_UNKNOWN;
        case 0: return TABLET_DATA_COPYING;
        case 1: return TABLET_DATA_READY;
        case 2: return TABLET_DATA_DELETED;
        case 3: return TABLET_DATA_TOMBSTONED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TabletDataState>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        TabletDataState> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<TabletDataState>() {
            public TabletDataState findValueByNumber(int number) {
              return TabletDataState.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.kudu.tablet.Metadata.getDescriptor().getEnumTypes().get(0);
    }

    private static final TabletDataState[] VALUES = values();

    public static TabletDataState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TabletDataState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:kudu.tablet.TabletDataState)
  }

  /**
   * <pre>
   * Tablet states represent stages of a TabletReplica's object lifecycle and are
   * reported to the master via tablet reports.
   * Legal state transitions for a single TabletReplica object:
   * NOT_INITIALIZED -&gt; INITIALIZED -&gt; BOOTSTRAPPING -&gt; RUNNING -&gt; STOPPING -&gt; STOPPED -&gt; SHUTDOWN
   *             |              |                |                  ^ ^ ^
   *             |              |                |                  | | |
   *             |              |                +------------------+ | |
   *             |              +-------------------------------------+ |
   *             +------------------------------------------------------+
   * Since a TabletReplica instance is replaced when a Tablet Copy operation
   * occurs, from a remote perspective it is possible for a tablet replica to
   * appear to transition from SHUTDOWN back to NOT_INITIALIZED.
   * </pre>
   *
   * Protobuf enum {@code kudu.tablet.TabletStatePB}
   */
  public enum TabletStatePB
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN = 999;</code>
     */
    UNKNOWN(999),
    /**
     * <pre>
     * Tablet has not yet been initialized.
     * </pre>
     *
     * <code>NOT_INITIALIZED = 6;</code>
     */
    NOT_INITIALIZED(6),
    /**
     * <pre>
     * Tablet has been initialized but not yet started.
     * </pre>
     *
     * <code>INITIALIZED = 5;</code>
     */
    INITIALIZED(5),
    /**
     * <pre>
     * Indicates the Tablet is bootstrapping, i.e. that the Tablet is not
     * available for RPC.
     * </pre>
     *
     * <code>BOOTSTRAPPING = 0;</code>
     */
    BOOTSTRAPPING(0),
    /**
     * <pre>
     * Once the configuration phase is over Peers are in RUNNING state. In this
     * state Peers are available for client RPCs.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     * <pre>
     * The tablet failed to for some reason. TabletReplica::error() will return
     * the reason for the failure.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    /**
     * <pre>
     * The Tablet is shutting down, and will not accept further requests.
     * </pre>
     *
     * <code>STOPPING = 3;</code>
     */
    STOPPING(3),
    /**
     * <pre>
     * The tablet has been stopped, possibly because it has been tombstoned.
     * </pre>
     *
     * <code>STOPPED = 7;</code>
     */
    STOPPED(7),
    /**
     * <pre>
     * The Tablet has been completely shut down.
     * </pre>
     *
     * <code>SHUTDOWN = 4;</code>
     */
    SHUTDOWN(4),
    ;

    /**
     * <code>UNKNOWN = 999;</code>
     */
    public static final int UNKNOWN_VALUE = 999;
    /**
     * <pre>
     * Tablet has not yet been initialized.
     * </pre>
     *
     * <code>NOT_INITIALIZED = 6;</code>
     */
    public static final int NOT_INITIALIZED_VALUE = 6;
    /**
     * <pre>
     * Tablet has been initialized but not yet started.
     * </pre>
     *
     * <code>INITIALIZED = 5;</code>
     */
    public static final int INITIALIZED_VALUE = 5;
    /**
     * <pre>
     * Indicates the Tablet is bootstrapping, i.e. that the Tablet is not
     * available for RPC.
     * </pre>
     *
     * <code>BOOTSTRAPPING = 0;</code>
     */
    public static final int BOOTSTRAPPING_VALUE = 0;
    /**
     * <pre>
     * Once the configuration phase is over Peers are in RUNNING state. In this
     * state Peers are available for client RPCs.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;
    /**
     * <pre>
     * The tablet failed to for some reason. TabletReplica::error() will return
     * the reason for the failure.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;
    /**
     * <pre>
     * The Tablet is shutting down, and will not accept further requests.
     * </pre>
     *
     * <code>STOPPING = 3;</code>
     */
    public static final int STOPPING_VALUE = 3;
    /**
     * <pre>
     * The tablet has been stopped, possibly because it has been tombstoned.
     * </pre>
     *
     * <code>STOPPED = 7;</code>
     */
    public static final int STOPPED_VALUE = 7;
    /**
     * <pre>
     * The Tablet has been completely shut down.
     * </pre>
     *
     * <code>SHUTDOWN = 4;</code>
     */
    public static final int SHUTDOWN_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TabletStatePB valueOf(int value) {
      return forNumber(value);
    }

    public static TabletStatePB forNumber(int value) {
      switch (value) {
        case 999: return UNKNOWN;
        case 6: return NOT_INITIALIZED;
        case 5: return INITIALIZED;
        case 0: return BOOTSTRAPPING;
        case 1: return RUNNING;
        case 2: return FAILED;
        case 3: return STOPPING;
        case 7: return STOPPED;
        case 4: return SHUTDOWN;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TabletStatePB>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        TabletStatePB> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<TabletStatePB>() {
            public TabletStatePB findValueByNumber(int number) {
              return TabletStatePB.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.kudu.tablet.Metadata.getDescriptor().getEnumTypes().get(1);
    }

    private static final TabletStatePB[] VALUES = values();

    public static TabletStatePB valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TabletStatePB(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:kudu.tablet.TabletStatePB)
  }

  public interface ColumnDataPBOrBuilder extends
      // @@protoc_insertion_point(interface_extends:kudu.tablet.ColumnDataPB)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    boolean hasBlock();
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    org.apache.kudu.Fs.BlockIdPB getBlock();
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    org.apache.kudu.Fs.BlockIdPBOrBuilder getBlockOrBuilder();

    /**
     * <pre>
     * REMOVED: optional ColumnSchemaPB OBSOLETE_schema = 3;
     * </pre>
     *
     * <code>optional int32 column_id = 4;</code>
     */
    boolean hasColumnId();
    /**
     * <pre>
     * REMOVED: optional ColumnSchemaPB OBSOLETE_schema = 3;
     * </pre>
     *
     * <code>optional int32 column_id = 4;</code>
     */
    int getColumnId();
  }
  /**
   * Protobuf type {@code kudu.tablet.ColumnDataPB}
   */
  public  static final class ColumnDataPB extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:kudu.tablet.ColumnDataPB)
      ColumnDataPBOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ColumnDataPB.newBuilder() to construct.
    private ColumnDataPB(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ColumnDataPB() {
      columnId_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ColumnDataPB(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 18: {
              org.apache.kudu.Fs.BlockIdPB.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = block_.toBuilder();
              }
              block_ = input.readMessage(org.apache.kudu.Fs.BlockIdPB.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(block_);
                block_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 32: {
              bitField0_ |= 0x00000002;
              columnId_ = input.readInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_ColumnDataPB_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_ColumnDataPB_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.kudu.tablet.Metadata.ColumnDataPB.class, org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder.class);
    }

    private int bitField0_;
    public static final int BLOCK_FIELD_NUMBER = 2;
    private org.apache.kudu.Fs.BlockIdPB block_;
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    public boolean hasBlock() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    public org.apache.kudu.Fs.BlockIdPB getBlock() {
      return block_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : block_;
    }
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    public org.apache.kudu.Fs.BlockIdPBOrBuilder getBlockOrBuilder() {
      return block_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : block_;
    }

    public static final int COLUMN_ID_FIELD_NUMBER = 4;
    private int columnId_;
    /**
     * <pre>
     * REMOVED: optional ColumnSchemaPB OBSOLETE_schema = 3;
     * </pre>
     *
     * <code>optional int32 column_id = 4;</code>
     */
    public boolean hasColumnId() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <pre>
     * REMOVED: optional ColumnSchemaPB OBSOLETE_schema = 3;
     * </pre>
     *
     * <code>optional int32 column_id = 4;</code>
     */
    public int getColumnId() {
      return columnId_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasBlock()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getBlock().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(2, getBlock());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(4, columnId_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getBlock());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(4, columnId_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.kudu.tablet.Metadata.ColumnDataPB)) {
        return super.equals(obj);
      }
      org.apache.kudu.tablet.Metadata.ColumnDataPB other = (org.apache.kudu.tablet.Metadata.ColumnDataPB) obj;

      boolean result = true;
      result = result && (hasBlock() == other.hasBlock());
      if (hasBlock()) {
        result = result && getBlock()
            .equals(other.getBlock());
      }
      result = result && (hasColumnId() == other.hasColumnId());
      if (hasColumnId()) {
        result = result && (getColumnId()
            == other.getColumnId());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasBlock()) {
        hash = (37 * hash) + BLOCK_FIELD_NUMBER;
        hash = (53 * hash) + getBlock().hashCode();
      }
      if (hasColumnId()) {
        hash = (37 * hash) + COLUMN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getColumnId();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.ColumnDataPB parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.kudu.tablet.Metadata.ColumnDataPB prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code kudu.tablet.ColumnDataPB}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:kudu.tablet.ColumnDataPB)
        org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_ColumnDataPB_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_ColumnDataPB_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.kudu.tablet.Metadata.ColumnDataPB.class, org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder.class);
      }

      // Construct using org.apache.kudu.tablet.Metadata.ColumnDataPB.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getBlockFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (blockBuilder_ == null) {
          block_ = null;
        } else {
          blockBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        columnId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_ColumnDataPB_descriptor;
      }

      public org.apache.kudu.tablet.Metadata.ColumnDataPB getDefaultInstanceForType() {
        return org.apache.kudu.tablet.Metadata.ColumnDataPB.getDefaultInstance();
      }

      public org.apache.kudu.tablet.Metadata.ColumnDataPB build() {
        org.apache.kudu.tablet.Metadata.ColumnDataPB result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.kudu.tablet.Metadata.ColumnDataPB buildPartial() {
        org.apache.kudu.tablet.Metadata.ColumnDataPB result = new org.apache.kudu.tablet.Metadata.ColumnDataPB(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (blockBuilder_ == null) {
          result.block_ = block_;
        } else {
          result.block_ = blockBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.columnId_ = columnId_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.kudu.tablet.Metadata.ColumnDataPB) {
          return mergeFrom((org.apache.kudu.tablet.Metadata.ColumnDataPB)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.kudu.tablet.Metadata.ColumnDataPB other) {
        if (other == org.apache.kudu.tablet.Metadata.ColumnDataPB.getDefaultInstance()) return this;
        if (other.hasBlock()) {
          mergeBlock(other.getBlock());
        }
        if (other.hasColumnId()) {
          setColumnId(other.getColumnId());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        if (!hasBlock()) {
          return false;
        }
        if (!getBlock().isInitialized()) {
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.kudu.tablet.Metadata.ColumnDataPB parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.kudu.tablet.Metadata.ColumnDataPB) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private org.apache.kudu.Fs.BlockIdPB block_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> blockBuilder_;
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public boolean hasBlock() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB getBlock() {
        if (blockBuilder_ == null) {
          return block_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : block_;
        } else {
          return blockBuilder_.getMessage();
        }
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public Builder setBlock(org.apache.kudu.Fs.BlockIdPB value) {
        if (blockBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          block_ = value;
          onChanged();
        } else {
          blockBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public Builder setBlock(
          org.apache.kudu.Fs.BlockIdPB.Builder builderForValue) {
        if (blockBuilder_ == null) {
          block_ = builderForValue.build();
          onChanged();
        } else {
          blockBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public Builder mergeBlock(org.apache.kudu.Fs.BlockIdPB value) {
        if (blockBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              block_ != null &&
              block_ != org.apache.kudu.Fs.BlockIdPB.getDefaultInstance()) {
            block_ =
              org.apache.kudu.Fs.BlockIdPB.newBuilder(block_).mergeFrom(value).buildPartial();
          } else {
            block_ = value;
          }
          onChanged();
        } else {
          blockBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public Builder clearBlock() {
        if (blockBuilder_ == null) {
          block_ = null;
          onChanged();
        } else {
          blockBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB.Builder getBlockBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getBlockFieldBuilder().getBuilder();
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public org.apache.kudu.Fs.BlockIdPBOrBuilder getBlockOrBuilder() {
        if (blockBuilder_ != null) {
          return blockBuilder_.getMessageOrBuilder();
        } else {
          return block_ == null ?
              org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : block_;
        }
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> 
          getBlockFieldBuilder() {
        if (blockBuilder_ == null) {
          blockBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder>(
                  getBlock(),
                  getParentForChildren(),
                  isClean());
          block_ = null;
        }
        return blockBuilder_;
      }

      private int columnId_ ;
      /**
       * <pre>
       * REMOVED: optional ColumnSchemaPB OBSOLETE_schema = 3;
       * </pre>
       *
       * <code>optional int32 column_id = 4;</code>
       */
      public boolean hasColumnId() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <pre>
       * REMOVED: optional ColumnSchemaPB OBSOLETE_schema = 3;
       * </pre>
       *
       * <code>optional int32 column_id = 4;</code>
       */
      public int getColumnId() {
        return columnId_;
      }
      /**
       * <pre>
       * REMOVED: optional ColumnSchemaPB OBSOLETE_schema = 3;
       * </pre>
       *
       * <code>optional int32 column_id = 4;</code>
       */
      public Builder setColumnId(int value) {
        bitField0_ |= 0x00000002;
        columnId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * REMOVED: optional ColumnSchemaPB OBSOLETE_schema = 3;
       * </pre>
       *
       * <code>optional int32 column_id = 4;</code>
       */
      public Builder clearColumnId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        columnId_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:kudu.tablet.ColumnDataPB)
    }

    // @@protoc_insertion_point(class_scope:kudu.tablet.ColumnDataPB)
    private static final org.apache.kudu.tablet.Metadata.ColumnDataPB DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.kudu.tablet.Metadata.ColumnDataPB();
    }

    public static org.apache.kudu.tablet.Metadata.ColumnDataPB getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<ColumnDataPB>
        PARSER = new com.google.protobuf.AbstractParser<ColumnDataPB>() {
      public ColumnDataPB parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
          return new ColumnDataPB(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ColumnDataPB> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnDataPB> getParserForType() {
      return PARSER;
    }

    public org.apache.kudu.tablet.Metadata.ColumnDataPB getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DeltaDataPBOrBuilder extends
      // @@protoc_insertion_point(interface_extends:kudu.tablet.DeltaDataPB)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    boolean hasBlock();
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    org.apache.kudu.Fs.BlockIdPB getBlock();
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    org.apache.kudu.Fs.BlockIdPBOrBuilder getBlockOrBuilder();
  }
  /**
   * Protobuf type {@code kudu.tablet.DeltaDataPB}
   */
  public  static final class DeltaDataPB extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:kudu.tablet.DeltaDataPB)
      DeltaDataPBOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use DeltaDataPB.newBuilder() to construct.
    private DeltaDataPB(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private DeltaDataPB() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private DeltaDataPB(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 18: {
              org.apache.kudu.Fs.BlockIdPB.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = block_.toBuilder();
              }
              block_ = input.readMessage(org.apache.kudu.Fs.BlockIdPB.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(block_);
                block_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_DeltaDataPB_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_DeltaDataPB_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.kudu.tablet.Metadata.DeltaDataPB.class, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder.class);
    }

    private int bitField0_;
    public static final int BLOCK_FIELD_NUMBER = 2;
    private org.apache.kudu.Fs.BlockIdPB block_;
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    public boolean hasBlock() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    public org.apache.kudu.Fs.BlockIdPB getBlock() {
      return block_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : block_;
    }
    /**
     * <code>required .kudu.BlockIdPB block = 2;</code>
     */
    public org.apache.kudu.Fs.BlockIdPBOrBuilder getBlockOrBuilder() {
      return block_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : block_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasBlock()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getBlock().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(2, getBlock());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getBlock());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.kudu.tablet.Metadata.DeltaDataPB)) {
        return super.equals(obj);
      }
      org.apache.kudu.tablet.Metadata.DeltaDataPB other = (org.apache.kudu.tablet.Metadata.DeltaDataPB) obj;

      boolean result = true;
      result = result && (hasBlock() == other.hasBlock());
      if (hasBlock()) {
        result = result && getBlock()
            .equals(other.getBlock());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasBlock()) {
        hash = (37 * hash) + BLOCK_FIELD_NUMBER;
        hash = (53 * hash) + getBlock().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.DeltaDataPB parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.kudu.tablet.Metadata.DeltaDataPB prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code kudu.tablet.DeltaDataPB}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:kudu.tablet.DeltaDataPB)
        org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_DeltaDataPB_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_DeltaDataPB_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.kudu.tablet.Metadata.DeltaDataPB.class, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder.class);
      }

      // Construct using org.apache.kudu.tablet.Metadata.DeltaDataPB.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getBlockFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (blockBuilder_ == null) {
          block_ = null;
        } else {
          blockBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_DeltaDataPB_descriptor;
      }

      public org.apache.kudu.tablet.Metadata.DeltaDataPB getDefaultInstanceForType() {
        return org.apache.kudu.tablet.Metadata.DeltaDataPB.getDefaultInstance();
      }

      public org.apache.kudu.tablet.Metadata.DeltaDataPB build() {
        org.apache.kudu.tablet.Metadata.DeltaDataPB result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.kudu.tablet.Metadata.DeltaDataPB buildPartial() {
        org.apache.kudu.tablet.Metadata.DeltaDataPB result = new org.apache.kudu.tablet.Metadata.DeltaDataPB(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (blockBuilder_ == null) {
          result.block_ = block_;
        } else {
          result.block_ = blockBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.kudu.tablet.Metadata.DeltaDataPB) {
          return mergeFrom((org.apache.kudu.tablet.Metadata.DeltaDataPB)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.kudu.tablet.Metadata.DeltaDataPB other) {
        if (other == org.apache.kudu.tablet.Metadata.DeltaDataPB.getDefaultInstance()) return this;
        if (other.hasBlock()) {
          mergeBlock(other.getBlock());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        if (!hasBlock()) {
          return false;
        }
        if (!getBlock().isInitialized()) {
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.kudu.tablet.Metadata.DeltaDataPB parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.kudu.tablet.Metadata.DeltaDataPB) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private org.apache.kudu.Fs.BlockIdPB block_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> blockBuilder_;
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public boolean hasBlock() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB getBlock() {
        if (blockBuilder_ == null) {
          return block_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : block_;
        } else {
          return blockBuilder_.getMessage();
        }
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public Builder setBlock(org.apache.kudu.Fs.BlockIdPB value) {
        if (blockBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          block_ = value;
          onChanged();
        } else {
          blockBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public Builder setBlock(
          org.apache.kudu.Fs.BlockIdPB.Builder builderForValue) {
        if (blockBuilder_ == null) {
          block_ = builderForValue.build();
          onChanged();
        } else {
          blockBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public Builder mergeBlock(org.apache.kudu.Fs.BlockIdPB value) {
        if (blockBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              block_ != null &&
              block_ != org.apache.kudu.Fs.BlockIdPB.getDefaultInstance()) {
            block_ =
              org.apache.kudu.Fs.BlockIdPB.newBuilder(block_).mergeFrom(value).buildPartial();
          } else {
            block_ = value;
          }
          onChanged();
        } else {
          blockBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public Builder clearBlock() {
        if (blockBuilder_ == null) {
          block_ = null;
          onChanged();
        } else {
          blockBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB.Builder getBlockBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getBlockFieldBuilder().getBuilder();
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      public org.apache.kudu.Fs.BlockIdPBOrBuilder getBlockOrBuilder() {
        if (blockBuilder_ != null) {
          return blockBuilder_.getMessageOrBuilder();
        } else {
          return block_ == null ?
              org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : block_;
        }
      }
      /**
       * <code>required .kudu.BlockIdPB block = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> 
          getBlockFieldBuilder() {
        if (blockBuilder_ == null) {
          blockBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder>(
                  getBlock(),
                  getParentForChildren(),
                  isClean());
          block_ = null;
        }
        return blockBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:kudu.tablet.DeltaDataPB)
    }

    // @@protoc_insertion_point(class_scope:kudu.tablet.DeltaDataPB)
    private static final org.apache.kudu.tablet.Metadata.DeltaDataPB DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.kudu.tablet.Metadata.DeltaDataPB();
    }

    public static org.apache.kudu.tablet.Metadata.DeltaDataPB getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<DeltaDataPB>
        PARSER = new com.google.protobuf.AbstractParser<DeltaDataPB>() {
      public DeltaDataPB parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
          return new DeltaDataPB(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<DeltaDataPB> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeltaDataPB> getParserForType() {
      return PARSER;
    }

    public org.apache.kudu.tablet.Metadata.DeltaDataPB getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RowSetDataPBOrBuilder extends
      // @@protoc_insertion_point(interface_extends:kudu.tablet.RowSetDataPB)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required uint64 id = 1;</code>
     */
    boolean hasId();
    /**
     * <code>required uint64 id = 1;</code>
     */
    long getId();

    /**
     * <code>required int64 last_durable_dms_id = 2;</code>
     */
    boolean hasLastDurableDmsId();
    /**
     * <code>required int64 last_durable_dms_id = 2;</code>
     */
    long getLastDurableDmsId();

    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    java.util.List<org.apache.kudu.tablet.Metadata.ColumnDataPB> 
        getColumnsList();
    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    org.apache.kudu.tablet.Metadata.ColumnDataPB getColumns(int index);
    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    int getColumnsCount();
    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    java.util.List<? extends org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder> 
        getColumnsOrBuilderList();
    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder getColumnsOrBuilder(
        int index);

    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> 
        getRedoDeltasList();
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    org.apache.kudu.tablet.Metadata.DeltaDataPB getRedoDeltas(int index);
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    int getRedoDeltasCount();
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    java.util.List<? extends org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> 
        getRedoDeltasOrBuilderList();
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder getRedoDeltasOrBuilder(
        int index);

    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> 
        getUndoDeltasList();
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    org.apache.kudu.tablet.Metadata.DeltaDataPB getUndoDeltas(int index);
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    int getUndoDeltasCount();
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    java.util.List<? extends org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> 
        getUndoDeltasOrBuilderList();
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder getUndoDeltasOrBuilder(
        int index);

    /**
     * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
     */
    boolean hasBloomBlock();
    /**
     * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
     */
    org.apache.kudu.Fs.BlockIdPB getBloomBlock();
    /**
     * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
     */
    org.apache.kudu.Fs.BlockIdPBOrBuilder getBloomBlockOrBuilder();

    /**
     * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
     */
    boolean hasAdhocIndexBlock();
    /**
     * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
     */
    org.apache.kudu.Fs.BlockIdPB getAdhocIndexBlock();
    /**
     * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
     */
    org.apache.kudu.Fs.BlockIdPBOrBuilder getAdhocIndexBlockOrBuilder();
  }
  /**
   * Protobuf type {@code kudu.tablet.RowSetDataPB}
   */
  public  static final class RowSetDataPB extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:kudu.tablet.RowSetDataPB)
      RowSetDataPBOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use RowSetDataPB.newBuilder() to construct.
    private RowSetDataPB(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private RowSetDataPB() {
      id_ = 0L;
      lastDurableDmsId_ = 0L;
      columns_ = java.util.Collections.emptyList();
      redoDeltas_ = java.util.Collections.emptyList();
      undoDeltas_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private RowSetDataPB(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              id_ = input.readUInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              lastDurableDmsId_ = input.readInt64();
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                columns_ = new java.util.ArrayList<org.apache.kudu.tablet.Metadata.ColumnDataPB>();
                mutable_bitField0_ |= 0x00000004;
              }
              columns_.add(
                  input.readMessage(org.apache.kudu.tablet.Metadata.ColumnDataPB.PARSER, extensionRegistry));
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                redoDeltas_ = new java.util.ArrayList<org.apache.kudu.tablet.Metadata.DeltaDataPB>();
                mutable_bitField0_ |= 0x00000008;
              }
              redoDeltas_.add(
                  input.readMessage(org.apache.kudu.tablet.Metadata.DeltaDataPB.PARSER, extensionRegistry));
              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                undoDeltas_ = new java.util.ArrayList<org.apache.kudu.tablet.Metadata.DeltaDataPB>();
                mutable_bitField0_ |= 0x00000010;
              }
              undoDeltas_.add(
                  input.readMessage(org.apache.kudu.tablet.Metadata.DeltaDataPB.PARSER, extensionRegistry));
              break;
            }
            case 50: {
              org.apache.kudu.Fs.BlockIdPB.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) == 0x00000004)) {
                subBuilder = bloomBlock_.toBuilder();
              }
              bloomBlock_ = input.readMessage(org.apache.kudu.Fs.BlockIdPB.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(bloomBlock_);
                bloomBlock_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 58: {
              org.apache.kudu.Fs.BlockIdPB.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) == 0x00000008)) {
                subBuilder = adhocIndexBlock_.toBuilder();
              }
              adhocIndexBlock_ = input.readMessage(org.apache.kudu.Fs.BlockIdPB.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(adhocIndexBlock_);
                adhocIndexBlock_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          columns_ = java.util.Collections.unmodifiableList(columns_);
        }
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          redoDeltas_ = java.util.Collections.unmodifiableList(redoDeltas_);
        }
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          undoDeltas_ = java.util.Collections.unmodifiableList(undoDeltas_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_RowSetDataPB_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_RowSetDataPB_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.kudu.tablet.Metadata.RowSetDataPB.class, org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private long id_;
    /**
     * <code>required uint64 id = 1;</code>
     */
    public boolean hasId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint64 id = 1;</code>
     */
    public long getId() {
      return id_;
    }

    public static final int LAST_DURABLE_DMS_ID_FIELD_NUMBER = 2;
    private long lastDurableDmsId_;
    /**
     * <code>required int64 last_durable_dms_id = 2;</code>
     */
    public boolean hasLastDurableDmsId() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required int64 last_durable_dms_id = 2;</code>
     */
    public long getLastDurableDmsId() {
      return lastDurableDmsId_;
    }

    public static final int COLUMNS_FIELD_NUMBER = 3;
    private java.util.List<org.apache.kudu.tablet.Metadata.ColumnDataPB> columns_;
    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    public java.util.List<org.apache.kudu.tablet.Metadata.ColumnDataPB> getColumnsList() {
      return columns_;
    }
    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    public java.util.List<? extends org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder> 
        getColumnsOrBuilderList() {
      return columns_;
    }
    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    public int getColumnsCount() {
      return columns_.size();
    }
    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    public org.apache.kudu.tablet.Metadata.ColumnDataPB getColumns(int index) {
      return columns_.get(index);
    }
    /**
     * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
     */
    public org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder getColumnsOrBuilder(
        int index) {
      return columns_.get(index);
    }

    public static final int REDO_DELTAS_FIELD_NUMBER = 4;
    private java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> redoDeltas_;
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    public java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> getRedoDeltasList() {
      return redoDeltas_;
    }
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    public java.util.List<? extends org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> 
        getRedoDeltasOrBuilderList() {
      return redoDeltas_;
    }
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    public int getRedoDeltasCount() {
      return redoDeltas_.size();
    }
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    public org.apache.kudu.tablet.Metadata.DeltaDataPB getRedoDeltas(int index) {
      return redoDeltas_.get(index);
    }
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
     */
    public org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder getRedoDeltasOrBuilder(
        int index) {
      return redoDeltas_.get(index);
    }

    public static final int UNDO_DELTAS_FIELD_NUMBER = 5;
    private java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> undoDeltas_;
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    public java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> getUndoDeltasList() {
      return undoDeltas_;
    }
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    public java.util.List<? extends org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> 
        getUndoDeltasOrBuilderList() {
      return undoDeltas_;
    }
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    public int getUndoDeltasCount() {
      return undoDeltas_.size();
    }
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    public org.apache.kudu.tablet.Metadata.DeltaDataPB getUndoDeltas(int index) {
      return undoDeltas_.get(index);
    }
    /**
     * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
     */
    public org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder getUndoDeltasOrBuilder(
        int index) {
      return undoDeltas_.get(index);
    }

    public static final int BLOOM_BLOCK_FIELD_NUMBER = 6;
    private org.apache.kudu.Fs.BlockIdPB bloomBlock_;
    /**
     * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
     */
    public boolean hasBloomBlock() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
     */
    public org.apache.kudu.Fs.BlockIdPB getBloomBlock() {
      return bloomBlock_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : bloomBlock_;
    }
    /**
     * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
     */
    public org.apache.kudu.Fs.BlockIdPBOrBuilder getBloomBlockOrBuilder() {
      return bloomBlock_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : bloomBlock_;
    }

    public static final int ADHOC_INDEX_BLOCK_FIELD_NUMBER = 7;
    private org.apache.kudu.Fs.BlockIdPB adhocIndexBlock_;
    /**
     * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
     */
    public boolean hasAdhocIndexBlock() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
     */
    public org.apache.kudu.Fs.BlockIdPB getAdhocIndexBlock() {
      return adhocIndexBlock_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : adhocIndexBlock_;
    }
    /**
     * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
     */
    public org.apache.kudu.Fs.BlockIdPBOrBuilder getAdhocIndexBlockOrBuilder() {
      return adhocIndexBlock_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : adhocIndexBlock_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasLastDurableDmsId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getColumnsCount(); i++) {
        if (!getColumns(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getRedoDeltasCount(); i++) {
        if (!getRedoDeltas(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getUndoDeltasCount(); i++) {
        if (!getUndoDeltas(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasBloomBlock()) {
        if (!getBloomBlock().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasAdhocIndexBlock()) {
        if (!getAdhocIndexBlock().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt64(1, id_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt64(2, lastDurableDmsId_);
      }
      for (int i = 0; i < columns_.size(); i++) {
        output.writeMessage(3, columns_.get(i));
      }
      for (int i = 0; i < redoDeltas_.size(); i++) {
        output.writeMessage(4, redoDeltas_.get(i));
      }
      for (int i = 0; i < undoDeltas_.size(); i++) {
        output.writeMessage(5, undoDeltas_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(6, getBloomBlock());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(7, getAdhocIndexBlock());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, id_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(2, lastDurableDmsId_);
      }
      for (int i = 0; i < columns_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, columns_.get(i));
      }
      for (int i = 0; i < redoDeltas_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, redoDeltas_.get(i));
      }
      for (int i = 0; i < undoDeltas_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, undoDeltas_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getBloomBlock());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, getAdhocIndexBlock());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.kudu.tablet.Metadata.RowSetDataPB)) {
        return super.equals(obj);
      }
      org.apache.kudu.tablet.Metadata.RowSetDataPB other = (org.apache.kudu.tablet.Metadata.RowSetDataPB) obj;

      boolean result = true;
      result = result && (hasId() == other.hasId());
      if (hasId()) {
        result = result && (getId()
            == other.getId());
      }
      result = result && (hasLastDurableDmsId() == other.hasLastDurableDmsId());
      if (hasLastDurableDmsId()) {
        result = result && (getLastDurableDmsId()
            == other.getLastDurableDmsId());
      }
      result = result && getColumnsList()
          .equals(other.getColumnsList());
      result = result && getRedoDeltasList()
          .equals(other.getRedoDeltasList());
      result = result && getUndoDeltasList()
          .equals(other.getUndoDeltasList());
      result = result && (hasBloomBlock() == other.hasBloomBlock());
      if (hasBloomBlock()) {
        result = result && getBloomBlock()
            .equals(other.getBloomBlock());
      }
      result = result && (hasAdhocIndexBlock() == other.hasAdhocIndexBlock());
      if (hasAdhocIndexBlock()) {
        result = result && getAdhocIndexBlock()
            .equals(other.getAdhocIndexBlock());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasId()) {
        hash = (37 * hash) + ID_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getId());
      }
      if (hasLastDurableDmsId()) {
        hash = (37 * hash) + LAST_DURABLE_DMS_ID_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getLastDurableDmsId());
      }
      if (getColumnsCount() > 0) {
        hash = (37 * hash) + COLUMNS_FIELD_NUMBER;
        hash = (53 * hash) + getColumnsList().hashCode();
      }
      if (getRedoDeltasCount() > 0) {
        hash = (37 * hash) + REDO_DELTAS_FIELD_NUMBER;
        hash = (53 * hash) + getRedoDeltasList().hashCode();
      }
      if (getUndoDeltasCount() > 0) {
        hash = (37 * hash) + UNDO_DELTAS_FIELD_NUMBER;
        hash = (53 * hash) + getUndoDeltasList().hashCode();
      }
      if (hasBloomBlock()) {
        hash = (37 * hash) + BLOOM_BLOCK_FIELD_NUMBER;
        hash = (53 * hash) + getBloomBlock().hashCode();
      }
      if (hasAdhocIndexBlock()) {
        hash = (37 * hash) + ADHOC_INDEX_BLOCK_FIELD_NUMBER;
        hash = (53 * hash) + getAdhocIndexBlock().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.RowSetDataPB parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.kudu.tablet.Metadata.RowSetDataPB prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code kudu.tablet.RowSetDataPB}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:kudu.tablet.RowSetDataPB)
        org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_RowSetDataPB_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_RowSetDataPB_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.kudu.tablet.Metadata.RowSetDataPB.class, org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder.class);
      }

      // Construct using org.apache.kudu.tablet.Metadata.RowSetDataPB.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getColumnsFieldBuilder();
          getRedoDeltasFieldBuilder();
          getUndoDeltasFieldBuilder();
          getBloomBlockFieldBuilder();
          getAdhocIndexBlockFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        id_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        lastDurableDmsId_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          columnsBuilder_.clear();
        }
        if (redoDeltasBuilder_ == null) {
          redoDeltas_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          redoDeltasBuilder_.clear();
        }
        if (undoDeltasBuilder_ == null) {
          undoDeltas_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          undoDeltasBuilder_.clear();
        }
        if (bloomBlockBuilder_ == null) {
          bloomBlock_ = null;
        } else {
          bloomBlockBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        if (adhocIndexBlockBuilder_ == null) {
          adhocIndexBlock_ = null;
        } else {
          adhocIndexBlockBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_RowSetDataPB_descriptor;
      }

      public org.apache.kudu.tablet.Metadata.RowSetDataPB getDefaultInstanceForType() {
        return org.apache.kudu.tablet.Metadata.RowSetDataPB.getDefaultInstance();
      }

      public org.apache.kudu.tablet.Metadata.RowSetDataPB build() {
        org.apache.kudu.tablet.Metadata.RowSetDataPB result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.kudu.tablet.Metadata.RowSetDataPB buildPartial() {
        org.apache.kudu.tablet.Metadata.RowSetDataPB result = new org.apache.kudu.tablet.Metadata.RowSetDataPB(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.id_ = id_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.lastDurableDmsId_ = lastDurableDmsId_;
        if (columnsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            columns_ = java.util.Collections.unmodifiableList(columns_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.columns_ = columns_;
        } else {
          result.columns_ = columnsBuilder_.build();
        }
        if (redoDeltasBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            redoDeltas_ = java.util.Collections.unmodifiableList(redoDeltas_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.redoDeltas_ = redoDeltas_;
        } else {
          result.redoDeltas_ = redoDeltasBuilder_.build();
        }
        if (undoDeltasBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010)) {
            undoDeltas_ = java.util.Collections.unmodifiableList(undoDeltas_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.undoDeltas_ = undoDeltas_;
        } else {
          result.undoDeltas_ = undoDeltasBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000004;
        }
        if (bloomBlockBuilder_ == null) {
          result.bloomBlock_ = bloomBlock_;
        } else {
          result.bloomBlock_ = bloomBlockBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000008;
        }
        if (adhocIndexBlockBuilder_ == null) {
          result.adhocIndexBlock_ = adhocIndexBlock_;
        } else {
          result.adhocIndexBlock_ = adhocIndexBlockBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.kudu.tablet.Metadata.RowSetDataPB) {
          return mergeFrom((org.apache.kudu.tablet.Metadata.RowSetDataPB)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.kudu.tablet.Metadata.RowSetDataPB other) {
        if (other == org.apache.kudu.tablet.Metadata.RowSetDataPB.getDefaultInstance()) return this;
        if (other.hasId()) {
          setId(other.getId());
        }
        if (other.hasLastDurableDmsId()) {
          setLastDurableDmsId(other.getLastDurableDmsId());
        }
        if (columnsBuilder_ == null) {
          if (!other.columns_.isEmpty()) {
            if (columns_.isEmpty()) {
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureColumnsIsMutable();
              columns_.addAll(other.columns_);
            }
            onChanged();
          }
        } else {
          if (!other.columns_.isEmpty()) {
            if (columnsBuilder_.isEmpty()) {
              columnsBuilder_.dispose();
              columnsBuilder_ = null;
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000004);
              columnsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getColumnsFieldBuilder() : null;
            } else {
              columnsBuilder_.addAllMessages(other.columns_);
            }
          }
        }
        if (redoDeltasBuilder_ == null) {
          if (!other.redoDeltas_.isEmpty()) {
            if (redoDeltas_.isEmpty()) {
              redoDeltas_ = other.redoDeltas_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureRedoDeltasIsMutable();
              redoDeltas_.addAll(other.redoDeltas_);
            }
            onChanged();
          }
        } else {
          if (!other.redoDeltas_.isEmpty()) {
            if (redoDeltasBuilder_.isEmpty()) {
              redoDeltasBuilder_.dispose();
              redoDeltasBuilder_ = null;
              redoDeltas_ = other.redoDeltas_;
              bitField0_ = (bitField0_ & ~0x00000008);
              redoDeltasBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getRedoDeltasFieldBuilder() : null;
            } else {
              redoDeltasBuilder_.addAllMessages(other.redoDeltas_);
            }
          }
        }
        if (undoDeltasBuilder_ == null) {
          if (!other.undoDeltas_.isEmpty()) {
            if (undoDeltas_.isEmpty()) {
              undoDeltas_ = other.undoDeltas_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureUndoDeltasIsMutable();
              undoDeltas_.addAll(other.undoDeltas_);
            }
            onChanged();
          }
        } else {
          if (!other.undoDeltas_.isEmpty()) {
            if (undoDeltasBuilder_.isEmpty()) {
              undoDeltasBuilder_.dispose();
              undoDeltasBuilder_ = null;
              undoDeltas_ = other.undoDeltas_;
              bitField0_ = (bitField0_ & ~0x00000010);
              undoDeltasBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getUndoDeltasFieldBuilder() : null;
            } else {
              undoDeltasBuilder_.addAllMessages(other.undoDeltas_);
            }
          }
        }
        if (other.hasBloomBlock()) {
          mergeBloomBlock(other.getBloomBlock());
        }
        if (other.hasAdhocIndexBlock()) {
          mergeAdhocIndexBlock(other.getAdhocIndexBlock());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        if (!hasId()) {
          return false;
        }
        if (!hasLastDurableDmsId()) {
          return false;
        }
        for (int i = 0; i < getColumnsCount(); i++) {
          if (!getColumns(i).isInitialized()) {
            return false;
          }
        }
        for (int i = 0; i < getRedoDeltasCount(); i++) {
          if (!getRedoDeltas(i).isInitialized()) {
            return false;
          }
        }
        for (int i = 0; i < getUndoDeltasCount(); i++) {
          if (!getUndoDeltas(i).isInitialized()) {
            return false;
          }
        }
        if (hasBloomBlock()) {
          if (!getBloomBlock().isInitialized()) {
            return false;
          }
        }
        if (hasAdhocIndexBlock()) {
          if (!getAdhocIndexBlock().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.kudu.tablet.Metadata.RowSetDataPB parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.kudu.tablet.Metadata.RowSetDataPB) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long id_ ;
      /**
       * <code>required uint64 id = 1;</code>
       */
      public boolean hasId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint64 id = 1;</code>
       */
      public long getId() {
        return id_;
      }
      /**
       * <code>required uint64 id = 1;</code>
       */
      public Builder setId(long value) {
        bitField0_ |= 0x00000001;
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 id = 1;</code>
       */
      public Builder clearId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        id_ = 0L;
        onChanged();
        return this;
      }

      private long lastDurableDmsId_ ;
      /**
       * <code>required int64 last_durable_dms_id = 2;</code>
       */
      public boolean hasLastDurableDmsId() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required int64 last_durable_dms_id = 2;</code>
       */
      public long getLastDurableDmsId() {
        return lastDurableDmsId_;
      }
      /**
       * <code>required int64 last_durable_dms_id = 2;</code>
       */
      public Builder setLastDurableDmsId(long value) {
        bitField0_ |= 0x00000002;
        lastDurableDmsId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required int64 last_durable_dms_id = 2;</code>
       */
      public Builder clearLastDurableDmsId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        lastDurableDmsId_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.kudu.tablet.Metadata.ColumnDataPB> columns_ =
        java.util.Collections.emptyList();
      private void ensureColumnsIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          columns_ = new java.util.ArrayList<org.apache.kudu.tablet.Metadata.ColumnDataPB>(columns_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.tablet.Metadata.ColumnDataPB, org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder, org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder> columnsBuilder_;

      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public java.util.List<org.apache.kudu.tablet.Metadata.ColumnDataPB> getColumnsList() {
        if (columnsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(columns_);
        } else {
          return columnsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public int getColumnsCount() {
        if (columnsBuilder_ == null) {
          return columns_.size();
        } else {
          return columnsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public org.apache.kudu.tablet.Metadata.ColumnDataPB getColumns(int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);
        } else {
          return columnsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public Builder setColumns(
          int index, org.apache.kudu.tablet.Metadata.ColumnDataPB value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.set(index, value);
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public Builder setColumns(
          int index, org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.set(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public Builder addColumns(org.apache.kudu.tablet.Metadata.ColumnDataPB value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public Builder addColumns(
          int index, org.apache.kudu.tablet.Metadata.ColumnDataPB value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(index, value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public Builder addColumns(
          org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public Builder addColumns(
          int index, org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public Builder addAllColumns(
          java.lang.Iterable<? extends org.apache.kudu.tablet.Metadata.ColumnDataPB> values) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, columns_);
          onChanged();
        } else {
          columnsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public Builder clearColumns() {
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          columnsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public Builder removeColumns(int index) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.remove(index);
          onChanged();
        } else {
          columnsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder getColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder getColumnsOrBuilder(
          int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);  } else {
          return columnsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public java.util.List<? extends org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder> 
           getColumnsOrBuilderList() {
        if (columnsBuilder_ != null) {
          return columnsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(columns_);
        }
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder addColumnsBuilder() {
        return getColumnsFieldBuilder().addBuilder(
            org.apache.kudu.tablet.Metadata.ColumnDataPB.getDefaultInstance());
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder addColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().addBuilder(
            index, org.apache.kudu.tablet.Metadata.ColumnDataPB.getDefaultInstance());
      }
      /**
       * <code>repeated .kudu.tablet.ColumnDataPB columns = 3;</code>
       */
      public java.util.List<org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder> 
           getColumnsBuilderList() {
        return getColumnsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.tablet.Metadata.ColumnDataPB, org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder, org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder> 
          getColumnsFieldBuilder() {
        if (columnsBuilder_ == null) {
          columnsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.kudu.tablet.Metadata.ColumnDataPB, org.apache.kudu.tablet.Metadata.ColumnDataPB.Builder, org.apache.kudu.tablet.Metadata.ColumnDataPBOrBuilder>(
                  columns_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          columns_ = null;
        }
        return columnsBuilder_;
      }

      private java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> redoDeltas_ =
        java.util.Collections.emptyList();
      private void ensureRedoDeltasIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          redoDeltas_ = new java.util.ArrayList<org.apache.kudu.tablet.Metadata.DeltaDataPB>(redoDeltas_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.tablet.Metadata.DeltaDataPB, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder, org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> redoDeltasBuilder_;

      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> getRedoDeltasList() {
        if (redoDeltasBuilder_ == null) {
          return java.util.Collections.unmodifiableList(redoDeltas_);
        } else {
          return redoDeltasBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public int getRedoDeltasCount() {
        if (redoDeltasBuilder_ == null) {
          return redoDeltas_.size();
        } else {
          return redoDeltasBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPB getRedoDeltas(int index) {
        if (redoDeltasBuilder_ == null) {
          return redoDeltas_.get(index);
        } else {
          return redoDeltasBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public Builder setRedoDeltas(
          int index, org.apache.kudu.tablet.Metadata.DeltaDataPB value) {
        if (redoDeltasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRedoDeltasIsMutable();
          redoDeltas_.set(index, value);
          onChanged();
        } else {
          redoDeltasBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public Builder setRedoDeltas(
          int index, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder builderForValue) {
        if (redoDeltasBuilder_ == null) {
          ensureRedoDeltasIsMutable();
          redoDeltas_.set(index, builderForValue.build());
          onChanged();
        } else {
          redoDeltasBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public Builder addRedoDeltas(org.apache.kudu.tablet.Metadata.DeltaDataPB value) {
        if (redoDeltasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRedoDeltasIsMutable();
          redoDeltas_.add(value);
          onChanged();
        } else {
          redoDeltasBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public Builder addRedoDeltas(
          int index, org.apache.kudu.tablet.Metadata.DeltaDataPB value) {
        if (redoDeltasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRedoDeltasIsMutable();
          redoDeltas_.add(index, value);
          onChanged();
        } else {
          redoDeltasBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public Builder addRedoDeltas(
          org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder builderForValue) {
        if (redoDeltasBuilder_ == null) {
          ensureRedoDeltasIsMutable();
          redoDeltas_.add(builderForValue.build());
          onChanged();
        } else {
          redoDeltasBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public Builder addRedoDeltas(
          int index, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder builderForValue) {
        if (redoDeltasBuilder_ == null) {
          ensureRedoDeltasIsMutable();
          redoDeltas_.add(index, builderForValue.build());
          onChanged();
        } else {
          redoDeltasBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public Builder addAllRedoDeltas(
          java.lang.Iterable<? extends org.apache.kudu.tablet.Metadata.DeltaDataPB> values) {
        if (redoDeltasBuilder_ == null) {
          ensureRedoDeltasIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, redoDeltas_);
          onChanged();
        } else {
          redoDeltasBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public Builder clearRedoDeltas() {
        if (redoDeltasBuilder_ == null) {
          redoDeltas_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          redoDeltasBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public Builder removeRedoDeltas(int index) {
        if (redoDeltasBuilder_ == null) {
          ensureRedoDeltasIsMutable();
          redoDeltas_.remove(index);
          onChanged();
        } else {
          redoDeltasBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder getRedoDeltasBuilder(
          int index) {
        return getRedoDeltasFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder getRedoDeltasOrBuilder(
          int index) {
        if (redoDeltasBuilder_ == null) {
          return redoDeltas_.get(index);  } else {
          return redoDeltasBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public java.util.List<? extends org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> 
           getRedoDeltasOrBuilderList() {
        if (redoDeltasBuilder_ != null) {
          return redoDeltasBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(redoDeltas_);
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder addRedoDeltasBuilder() {
        return getRedoDeltasFieldBuilder().addBuilder(
            org.apache.kudu.tablet.Metadata.DeltaDataPB.getDefaultInstance());
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder addRedoDeltasBuilder(
          int index) {
        return getRedoDeltasFieldBuilder().addBuilder(
            index, org.apache.kudu.tablet.Metadata.DeltaDataPB.getDefaultInstance());
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB redo_deltas = 4;</code>
       */
      public java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder> 
           getRedoDeltasBuilderList() {
        return getRedoDeltasFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.tablet.Metadata.DeltaDataPB, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder, org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> 
          getRedoDeltasFieldBuilder() {
        if (redoDeltasBuilder_ == null) {
          redoDeltasBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.kudu.tablet.Metadata.DeltaDataPB, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder, org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder>(
                  redoDeltas_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          redoDeltas_ = null;
        }
        return redoDeltasBuilder_;
      }

      private java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> undoDeltas_ =
        java.util.Collections.emptyList();
      private void ensureUndoDeltasIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          undoDeltas_ = new java.util.ArrayList<org.apache.kudu.tablet.Metadata.DeltaDataPB>(undoDeltas_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.tablet.Metadata.DeltaDataPB, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder, org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> undoDeltasBuilder_;

      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB> getUndoDeltasList() {
        if (undoDeltasBuilder_ == null) {
          return java.util.Collections.unmodifiableList(undoDeltas_);
        } else {
          return undoDeltasBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public int getUndoDeltasCount() {
        if (undoDeltasBuilder_ == null) {
          return undoDeltas_.size();
        } else {
          return undoDeltasBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPB getUndoDeltas(int index) {
        if (undoDeltasBuilder_ == null) {
          return undoDeltas_.get(index);
        } else {
          return undoDeltasBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public Builder setUndoDeltas(
          int index, org.apache.kudu.tablet.Metadata.DeltaDataPB value) {
        if (undoDeltasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUndoDeltasIsMutable();
          undoDeltas_.set(index, value);
          onChanged();
        } else {
          undoDeltasBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public Builder setUndoDeltas(
          int index, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder builderForValue) {
        if (undoDeltasBuilder_ == null) {
          ensureUndoDeltasIsMutable();
          undoDeltas_.set(index, builderForValue.build());
          onChanged();
        } else {
          undoDeltasBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public Builder addUndoDeltas(org.apache.kudu.tablet.Metadata.DeltaDataPB value) {
        if (undoDeltasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUndoDeltasIsMutable();
          undoDeltas_.add(value);
          onChanged();
        } else {
          undoDeltasBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public Builder addUndoDeltas(
          int index, org.apache.kudu.tablet.Metadata.DeltaDataPB value) {
        if (undoDeltasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUndoDeltasIsMutable();
          undoDeltas_.add(index, value);
          onChanged();
        } else {
          undoDeltasBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public Builder addUndoDeltas(
          org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder builderForValue) {
        if (undoDeltasBuilder_ == null) {
          ensureUndoDeltasIsMutable();
          undoDeltas_.add(builderForValue.build());
          onChanged();
        } else {
          undoDeltasBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public Builder addUndoDeltas(
          int index, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder builderForValue) {
        if (undoDeltasBuilder_ == null) {
          ensureUndoDeltasIsMutable();
          undoDeltas_.add(index, builderForValue.build());
          onChanged();
        } else {
          undoDeltasBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public Builder addAllUndoDeltas(
          java.lang.Iterable<? extends org.apache.kudu.tablet.Metadata.DeltaDataPB> values) {
        if (undoDeltasBuilder_ == null) {
          ensureUndoDeltasIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, undoDeltas_);
          onChanged();
        } else {
          undoDeltasBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public Builder clearUndoDeltas() {
        if (undoDeltasBuilder_ == null) {
          undoDeltas_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          undoDeltasBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public Builder removeUndoDeltas(int index) {
        if (undoDeltasBuilder_ == null) {
          ensureUndoDeltasIsMutable();
          undoDeltas_.remove(index);
          onChanged();
        } else {
          undoDeltasBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder getUndoDeltasBuilder(
          int index) {
        return getUndoDeltasFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder getUndoDeltasOrBuilder(
          int index) {
        if (undoDeltasBuilder_ == null) {
          return undoDeltas_.get(index);  } else {
          return undoDeltasBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public java.util.List<? extends org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> 
           getUndoDeltasOrBuilderList() {
        if (undoDeltasBuilder_ != null) {
          return undoDeltasBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(undoDeltas_);
        }
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder addUndoDeltasBuilder() {
        return getUndoDeltasFieldBuilder().addBuilder(
            org.apache.kudu.tablet.Metadata.DeltaDataPB.getDefaultInstance());
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder addUndoDeltasBuilder(
          int index) {
        return getUndoDeltasFieldBuilder().addBuilder(
            index, org.apache.kudu.tablet.Metadata.DeltaDataPB.getDefaultInstance());
      }
      /**
       * <code>repeated .kudu.tablet.DeltaDataPB undo_deltas = 5;</code>
       */
      public java.util.List<org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder> 
           getUndoDeltasBuilderList() {
        return getUndoDeltasFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.tablet.Metadata.DeltaDataPB, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder, org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder> 
          getUndoDeltasFieldBuilder() {
        if (undoDeltasBuilder_ == null) {
          undoDeltasBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.kudu.tablet.Metadata.DeltaDataPB, org.apache.kudu.tablet.Metadata.DeltaDataPB.Builder, org.apache.kudu.tablet.Metadata.DeltaDataPBOrBuilder>(
                  undoDeltas_,
                  ((bitField0_ & 0x00000010) == 0x00000010),
                  getParentForChildren(),
                  isClean());
          undoDeltas_ = null;
        }
        return undoDeltasBuilder_;
      }

      private org.apache.kudu.Fs.BlockIdPB bloomBlock_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> bloomBlockBuilder_;
      /**
       * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
       */
      public boolean hasBloomBlock() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB getBloomBlock() {
        if (bloomBlockBuilder_ == null) {
          return bloomBlock_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : bloomBlock_;
        } else {
          return bloomBlockBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
       */
      public Builder setBloomBlock(org.apache.kudu.Fs.BlockIdPB value) {
        if (bloomBlockBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          bloomBlock_ = value;
          onChanged();
        } else {
          bloomBlockBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
       */
      public Builder setBloomBlock(
          org.apache.kudu.Fs.BlockIdPB.Builder builderForValue) {
        if (bloomBlockBuilder_ == null) {
          bloomBlock_ = builderForValue.build();
          onChanged();
        } else {
          bloomBlockBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
       */
      public Builder mergeBloomBlock(org.apache.kudu.Fs.BlockIdPB value) {
        if (bloomBlockBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020) &&
              bloomBlock_ != null &&
              bloomBlock_ != org.apache.kudu.Fs.BlockIdPB.getDefaultInstance()) {
            bloomBlock_ =
              org.apache.kudu.Fs.BlockIdPB.newBuilder(bloomBlock_).mergeFrom(value).buildPartial();
          } else {
            bloomBlock_ = value;
          }
          onChanged();
        } else {
          bloomBlockBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
       */
      public Builder clearBloomBlock() {
        if (bloomBlockBuilder_ == null) {
          bloomBlock_ = null;
          onChanged();
        } else {
          bloomBlockBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }
      /**
       * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB.Builder getBloomBlockBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getBloomBlockFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
       */
      public org.apache.kudu.Fs.BlockIdPBOrBuilder getBloomBlockOrBuilder() {
        if (bloomBlockBuilder_ != null) {
          return bloomBlockBuilder_.getMessageOrBuilder();
        } else {
          return bloomBlock_ == null ?
              org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : bloomBlock_;
        }
      }
      /**
       * <code>optional .kudu.BlockIdPB bloom_block = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> 
          getBloomBlockFieldBuilder() {
        if (bloomBlockBuilder_ == null) {
          bloomBlockBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder>(
                  getBloomBlock(),
                  getParentForChildren(),
                  isClean());
          bloomBlock_ = null;
        }
        return bloomBlockBuilder_;
      }

      private org.apache.kudu.Fs.BlockIdPB adhocIndexBlock_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> adhocIndexBlockBuilder_;
      /**
       * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
       */
      public boolean hasAdhocIndexBlock() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB getAdhocIndexBlock() {
        if (adhocIndexBlockBuilder_ == null) {
          return adhocIndexBlock_ == null ? org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : adhocIndexBlock_;
        } else {
          return adhocIndexBlockBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
       */
      public Builder setAdhocIndexBlock(org.apache.kudu.Fs.BlockIdPB value) {
        if (adhocIndexBlockBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          adhocIndexBlock_ = value;
          onChanged();
        } else {
          adhocIndexBlockBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
       */
      public Builder setAdhocIndexBlock(
          org.apache.kudu.Fs.BlockIdPB.Builder builderForValue) {
        if (adhocIndexBlockBuilder_ == null) {
          adhocIndexBlock_ = builderForValue.build();
          onChanged();
        } else {
          adhocIndexBlockBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
       */
      public Builder mergeAdhocIndexBlock(org.apache.kudu.Fs.BlockIdPB value) {
        if (adhocIndexBlockBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040) &&
              adhocIndexBlock_ != null &&
              adhocIndexBlock_ != org.apache.kudu.Fs.BlockIdPB.getDefaultInstance()) {
            adhocIndexBlock_ =
              org.apache.kudu.Fs.BlockIdPB.newBuilder(adhocIndexBlock_).mergeFrom(value).buildPartial();
          } else {
            adhocIndexBlock_ = value;
          }
          onChanged();
        } else {
          adhocIndexBlockBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
       */
      public Builder clearAdhocIndexBlock() {
        if (adhocIndexBlockBuilder_ == null) {
          adhocIndexBlock_ = null;
          onChanged();
        } else {
          adhocIndexBlockBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }
      /**
       * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB.Builder getAdhocIndexBlockBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getAdhocIndexBlockFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
       */
      public org.apache.kudu.Fs.BlockIdPBOrBuilder getAdhocIndexBlockOrBuilder() {
        if (adhocIndexBlockBuilder_ != null) {
          return adhocIndexBlockBuilder_.getMessageOrBuilder();
        } else {
          return adhocIndexBlock_ == null ?
              org.apache.kudu.Fs.BlockIdPB.getDefaultInstance() : adhocIndexBlock_;
        }
      }
      /**
       * <code>optional .kudu.BlockIdPB adhoc_index_block = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> 
          getAdhocIndexBlockFieldBuilder() {
        if (adhocIndexBlockBuilder_ == null) {
          adhocIndexBlockBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder>(
                  getAdhocIndexBlock(),
                  getParentForChildren(),
                  isClean());
          adhocIndexBlock_ = null;
        }
        return adhocIndexBlockBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:kudu.tablet.RowSetDataPB)
    }

    // @@protoc_insertion_point(class_scope:kudu.tablet.RowSetDataPB)
    private static final org.apache.kudu.tablet.Metadata.RowSetDataPB DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.kudu.tablet.Metadata.RowSetDataPB();
    }

    public static org.apache.kudu.tablet.Metadata.RowSetDataPB getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<RowSetDataPB>
        PARSER = new com.google.protobuf.AbstractParser<RowSetDataPB>() {
      public RowSetDataPB parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
          return new RowSetDataPB(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<RowSetDataPB> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RowSetDataPB> getParserForType() {
      return PARSER;
    }

    public org.apache.kudu.tablet.Metadata.RowSetDataPB getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TabletSuperBlockPBOrBuilder extends
      // @@protoc_insertion_point(interface_extends:kudu.tablet.TabletSuperBlockPB)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Table ID of the table this tablet is part of.
     * </pre>
     *
     * <code>required bytes table_id = 1;</code>
     */
    boolean hasTableId();
    /**
     * <pre>
     * Table ID of the table this tablet is part of.
     * </pre>
     *
     * <code>required bytes table_id = 1;</code>
     */
    com.google.protobuf.ByteString getTableId();

    /**
     * <pre>
     * Tablet Id
     * </pre>
     *
     * <code>required bytes tablet_id = 2;</code>
     */
    boolean hasTabletId();
    /**
     * <pre>
     * Tablet Id
     * </pre>
     *
     * <code>required bytes tablet_id = 2;</code>
     */
    com.google.protobuf.ByteString getTabletId();

    /**
     * <pre>
     * The latest durable MemRowSet id
     * </pre>
     *
     * <code>required int64 last_durable_mrs_id = 3;</code>
     */
    boolean hasLastDurableMrsId();
    /**
     * <pre>
     * The latest durable MemRowSet id
     * </pre>
     *
     * <code>required int64 last_durable_mrs_id = 3;</code>
     */
    long getLastDurableMrsId();

    /**
     * <pre>
     * DEPRECATED.
     * </pre>
     *
     * <code>optional bytes start_key = 4;</code>
     */
    boolean hasStartKey();
    /**
     * <pre>
     * DEPRECATED.
     * </pre>
     *
     * <code>optional bytes start_key = 4;</code>
     */
    com.google.protobuf.ByteString getStartKey();

    /**
     * <pre>
     * DEPRECATED.
     * </pre>
     *
     * <code>optional bytes end_key = 5;</code>
     */
    boolean hasEndKey();
    /**
     * <pre>
     * DEPRECATED.
     * </pre>
     *
     * <code>optional bytes end_key = 5;</code>
     */
    com.google.protobuf.ByteString getEndKey();

    /**
     * <pre>
     * The partition of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionPB partition = 13;</code>
     */
    boolean hasPartition();
    /**
     * <pre>
     * The partition of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionPB partition = 13;</code>
     */
    org.apache.kudu.Common.PartitionPB getPartition();
    /**
     * <pre>
     * The partition of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionPB partition = 13;</code>
     */
    org.apache.kudu.Common.PartitionPBOrBuilder getPartitionOrBuilder();

    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    java.util.List<org.apache.kudu.tablet.Metadata.RowSetDataPB> 
        getRowsetsList();
    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    org.apache.kudu.tablet.Metadata.RowSetDataPB getRowsets(int index);
    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    int getRowsetsCount();
    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    java.util.List<? extends org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder> 
        getRowsetsOrBuilderList();
    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder getRowsetsOrBuilder(
        int index);

    /**
     * <pre>
     * The latest schema
     * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
     * into use throughout the code. Using the simpler one for now.
     * </pre>
     *
     * <code>required string table_name = 7;</code>
     */
    boolean hasTableName();
    /**
     * <pre>
     * The latest schema
     * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
     * into use throughout the code. Using the simpler one for now.
     * </pre>
     *
     * <code>required string table_name = 7;</code>
     */
    java.lang.String getTableName();
    /**
     * <pre>
     * The latest schema
     * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
     * into use throughout the code. Using the simpler one for now.
     * </pre>
     *
     * <code>required string table_name = 7;</code>
     */
    com.google.protobuf.ByteString
        getTableNameBytes();

    /**
     * <code>required .kudu.SchemaPB schema = 8;</code>
     */
    boolean hasSchema();
    /**
     * <code>required .kudu.SchemaPB schema = 8;</code>
     */
    org.apache.kudu.Common.SchemaPB getSchema();
    /**
     * <code>required .kudu.SchemaPB schema = 8;</code>
     */
    org.apache.kudu.Common.SchemaPBOrBuilder getSchemaOrBuilder();

    /**
     * <code>required uint32 schema_version = 9;</code>
     */
    boolean hasSchemaVersion();
    /**
     * <code>required uint32 schema_version = 9;</code>
     */
    int getSchemaVersion();

    /**
     * <pre>
     * The partition schema of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
     */
    boolean hasPartitionSchema();
    /**
     * <pre>
     * The partition schema of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
     */
    org.apache.kudu.Common.PartitionSchemaPB getPartitionSchema();
    /**
     * <pre>
     * The partition schema of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
     */
    org.apache.kudu.Common.PartitionSchemaPBOrBuilder getPartitionSchemaOrBuilder();

    /**
     * <pre>
     * The current state of the tablet's data.
     * </pre>
     *
     * <code>optional .kudu.tablet.TabletDataState tablet_data_state = 10 [default = TABLET_DATA_UNKNOWN];</code>
     */
    boolean hasTabletDataState();
    /**
     * <pre>
     * The current state of the tablet's data.
     * </pre>
     *
     * <code>optional .kudu.tablet.TabletDataState tablet_data_state = 10 [default = TABLET_DATA_UNKNOWN];</code>
     */
    org.apache.kudu.tablet.Metadata.TabletDataState getTabletDataState();

    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    java.util.List<org.apache.kudu.Fs.BlockIdPB> 
        getOrphanedBlocksList();
    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    org.apache.kudu.Fs.BlockIdPB getOrphanedBlocks(int index);
    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    int getOrphanedBlocksCount();
    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    java.util.List<? extends org.apache.kudu.Fs.BlockIdPBOrBuilder> 
        getOrphanedBlocksOrBuilderList();
    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    org.apache.kudu.Fs.BlockIdPBOrBuilder getOrphanedBlocksOrBuilder(
        int index);

    /**
     * <pre>
     * For tablets that have been tombstoned, stores the last OpId stored in the
     * WAL before tombstoning.
     * Only relevant for TOMBSTONED tablets.
     * </pre>
     *
     * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
     */
    boolean hasTombstoneLastLoggedOpid();
    /**
     * <pre>
     * For tablets that have been tombstoned, stores the last OpId stored in the
     * WAL before tombstoning.
     * Only relevant for TOMBSTONED tablets.
     * </pre>
     *
     * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
     */
    org.apache.kudu.consensus.Opid.OpId getTombstoneLastLoggedOpid();
    /**
     * <pre>
     * For tablets that have been tombstoned, stores the last OpId stored in the
     * WAL before tombstoning.
     * Only relevant for TOMBSTONED tablets.
     * </pre>
     *
     * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
     */
    org.apache.kudu.consensus.Opid.OpIdOrBuilder getTombstoneLastLoggedOpidOrBuilder();

    /**
     * <pre>
     * Tablet data is spread across a data directory group. If this is not set
     * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
     * from a version of Kudu before 1.5.0. In this case, a new group will be
     * created spanning all data directories.
     * </pre>
     *
     * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
     */
    boolean hasDataDirGroup();
    /**
     * <pre>
     * Tablet data is spread across a data directory group. If this is not set
     * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
     * from a version of Kudu before 1.5.0. In this case, a new group will be
     * created spanning all data directories.
     * </pre>
     *
     * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
     */
    org.apache.kudu.Fs.DataDirGroupPB getDataDirGroup();
    /**
     * <pre>
     * Tablet data is spread across a data directory group. If this is not set
     * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
     * from a version of Kudu before 1.5.0. In this case, a new group will be
     * created spanning all data directories.
     * </pre>
     *
     * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
     */
    org.apache.kudu.Fs.DataDirGroupPBOrBuilder getDataDirGroupOrBuilder();
  }
  /**
   * <pre>
   * The super-block keeps track of the tablet data blocks.
   * A tablet contains one or more RowSets, which contain
   * a set of blocks (one for each column), a set of delta blocks
   * and optionally a block containing the bloom filter
   * and a block containing the compound-keys.
   * </pre>
   *
   * Protobuf type {@code kudu.tablet.TabletSuperBlockPB}
   */
  public  static final class TabletSuperBlockPB extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:kudu.tablet.TabletSuperBlockPB)
      TabletSuperBlockPBOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TabletSuperBlockPB.newBuilder() to construct.
    private TabletSuperBlockPB(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TabletSuperBlockPB() {
      tableId_ = com.google.protobuf.ByteString.EMPTY;
      tabletId_ = com.google.protobuf.ByteString.EMPTY;
      lastDurableMrsId_ = 0L;
      startKey_ = com.google.protobuf.ByteString.EMPTY;
      endKey_ = com.google.protobuf.ByteString.EMPTY;
      rowsets_ = java.util.Collections.emptyList();
      tableName_ = "";
      schemaVersion_ = 0;
      tabletDataState_ = 999;
      orphanedBlocks_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private TabletSuperBlockPB(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              tableId_ = input.readBytes();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              tabletId_ = input.readBytes();
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              lastDurableMrsId_ = input.readInt64();
              break;
            }
            case 34: {
              bitField0_ |= 0x00000008;
              startKey_ = input.readBytes();
              break;
            }
            case 42: {
              bitField0_ |= 0x00000010;
              endKey_ = input.readBytes();
              break;
            }
            case 50: {
              if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                rowsets_ = new java.util.ArrayList<org.apache.kudu.tablet.Metadata.RowSetDataPB>();
                mutable_bitField0_ |= 0x00000040;
              }
              rowsets_.add(
                  input.readMessage(org.apache.kudu.tablet.Metadata.RowSetDataPB.PARSER, extensionRegistry));
              break;
            }
            case 58: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000040;
              tableName_ = bs;
              break;
            }
            case 66: {
              org.apache.kudu.Common.SchemaPB.Builder subBuilder = null;
              if (((bitField0_ & 0x00000080) == 0x00000080)) {
                subBuilder = schema_.toBuilder();
              }
              schema_ = input.readMessage(org.apache.kudu.Common.SchemaPB.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(schema_);
                schema_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000080;
              break;
            }
            case 72: {
              bitField0_ |= 0x00000100;
              schemaVersion_ = input.readUInt32();
              break;
            }
            case 80: {
              int rawValue = input.readEnum();
              org.apache.kudu.tablet.Metadata.TabletDataState value = org.apache.kudu.tablet.Metadata.TabletDataState.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(10, rawValue);
              } else {
                bitField0_ |= 0x00000400;
                tabletDataState_ = rawValue;
              }
              break;
            }
            case 90: {
              if (!((mutable_bitField0_ & 0x00001000) == 0x00001000)) {
                orphanedBlocks_ = new java.util.ArrayList<org.apache.kudu.Fs.BlockIdPB>();
                mutable_bitField0_ |= 0x00001000;
              }
              orphanedBlocks_.add(
                  input.readMessage(org.apache.kudu.Fs.BlockIdPB.PARSER, extensionRegistry));
              break;
            }
            case 98: {
              org.apache.kudu.consensus.Opid.OpId.Builder subBuilder = null;
              if (((bitField0_ & 0x00000800) == 0x00000800)) {
                subBuilder = tombstoneLastLoggedOpid_.toBuilder();
              }
              tombstoneLastLoggedOpid_ = input.readMessage(org.apache.kudu.consensus.Opid.OpId.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(tombstoneLastLoggedOpid_);
                tombstoneLastLoggedOpid_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000800;
              break;
            }
            case 106: {
              org.apache.kudu.Common.PartitionPB.Builder subBuilder = null;
              if (((bitField0_ & 0x00000020) == 0x00000020)) {
                subBuilder = partition_.toBuilder();
              }
              partition_ = input.readMessage(org.apache.kudu.Common.PartitionPB.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(partition_);
                partition_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000020;
              break;
            }
            case 114: {
              org.apache.kudu.Common.PartitionSchemaPB.Builder subBuilder = null;
              if (((bitField0_ & 0x00000200) == 0x00000200)) {
                subBuilder = partitionSchema_.toBuilder();
              }
              partitionSchema_ = input.readMessage(org.apache.kudu.Common.PartitionSchemaPB.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(partitionSchema_);
                partitionSchema_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000200;
              break;
            }
            case 122: {
              org.apache.kudu.Fs.DataDirGroupPB.Builder subBuilder = null;
              if (((bitField0_ & 0x00001000) == 0x00001000)) {
                subBuilder = dataDirGroup_.toBuilder();
              }
              dataDirGroup_ = input.readMessage(org.apache.kudu.Fs.DataDirGroupPB.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(dataDirGroup_);
                dataDirGroup_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00001000;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
          rowsets_ = java.util.Collections.unmodifiableList(rowsets_);
        }
        if (((mutable_bitField0_ & 0x00001000) == 0x00001000)) {
          orphanedBlocks_ = java.util.Collections.unmodifiableList(orphanedBlocks_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_TabletSuperBlockPB_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_TabletSuperBlockPB_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.kudu.tablet.Metadata.TabletSuperBlockPB.class, org.apache.kudu.tablet.Metadata.TabletSuperBlockPB.Builder.class);
    }

    private int bitField0_;
    public static final int TABLE_ID_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString tableId_;
    /**
     * <pre>
     * Table ID of the table this tablet is part of.
     * </pre>
     *
     * <code>required bytes table_id = 1;</code>
     */
    public boolean hasTableId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <pre>
     * Table ID of the table this tablet is part of.
     * </pre>
     *
     * <code>required bytes table_id = 1;</code>
     */
    public com.google.protobuf.ByteString getTableId() {
      return tableId_;
    }

    public static final int TABLET_ID_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString tabletId_;
    /**
     * <pre>
     * Tablet Id
     * </pre>
     *
     * <code>required bytes tablet_id = 2;</code>
     */
    public boolean hasTabletId() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <pre>
     * Tablet Id
     * </pre>
     *
     * <code>required bytes tablet_id = 2;</code>
     */
    public com.google.protobuf.ByteString getTabletId() {
      return tabletId_;
    }

    public static final int LAST_DURABLE_MRS_ID_FIELD_NUMBER = 3;
    private long lastDurableMrsId_;
    /**
     * <pre>
     * The latest durable MemRowSet id
     * </pre>
     *
     * <code>required int64 last_durable_mrs_id = 3;</code>
     */
    public boolean hasLastDurableMrsId() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <pre>
     * The latest durable MemRowSet id
     * </pre>
     *
     * <code>required int64 last_durable_mrs_id = 3;</code>
     */
    public long getLastDurableMrsId() {
      return lastDurableMrsId_;
    }

    public static final int START_KEY_FIELD_NUMBER = 4;
    private com.google.protobuf.ByteString startKey_;
    /**
     * <pre>
     * DEPRECATED.
     * </pre>
     *
     * <code>optional bytes start_key = 4;</code>
     */
    public boolean hasStartKey() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <pre>
     * DEPRECATED.
     * </pre>
     *
     * <code>optional bytes start_key = 4;</code>
     */
    public com.google.protobuf.ByteString getStartKey() {
      return startKey_;
    }

    public static final int END_KEY_FIELD_NUMBER = 5;
    private com.google.protobuf.ByteString endKey_;
    /**
     * <pre>
     * DEPRECATED.
     * </pre>
     *
     * <code>optional bytes end_key = 5;</code>
     */
    public boolean hasEndKey() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <pre>
     * DEPRECATED.
     * </pre>
     *
     * <code>optional bytes end_key = 5;</code>
     */
    public com.google.protobuf.ByteString getEndKey() {
      return endKey_;
    }

    public static final int PARTITION_FIELD_NUMBER = 13;
    private org.apache.kudu.Common.PartitionPB partition_;
    /**
     * <pre>
     * The partition of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionPB partition = 13;</code>
     */
    public boolean hasPartition() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <pre>
     * The partition of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionPB partition = 13;</code>
     */
    public org.apache.kudu.Common.PartitionPB getPartition() {
      return partition_ == null ? org.apache.kudu.Common.PartitionPB.getDefaultInstance() : partition_;
    }
    /**
     * <pre>
     * The partition of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionPB partition = 13;</code>
     */
    public org.apache.kudu.Common.PartitionPBOrBuilder getPartitionOrBuilder() {
      return partition_ == null ? org.apache.kudu.Common.PartitionPB.getDefaultInstance() : partition_;
    }

    public static final int ROWSETS_FIELD_NUMBER = 6;
    private java.util.List<org.apache.kudu.tablet.Metadata.RowSetDataPB> rowsets_;
    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    public java.util.List<org.apache.kudu.tablet.Metadata.RowSetDataPB> getRowsetsList() {
      return rowsets_;
    }
    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    public java.util.List<? extends org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder> 
        getRowsetsOrBuilderList() {
      return rowsets_;
    }
    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    public int getRowsetsCount() {
      return rowsets_.size();
    }
    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    public org.apache.kudu.tablet.Metadata.RowSetDataPB getRowsets(int index) {
      return rowsets_.get(index);
    }
    /**
     * <pre>
     * Tablet RowSets
     * </pre>
     *
     * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
     */
    public org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder getRowsetsOrBuilder(
        int index) {
      return rowsets_.get(index);
    }

    public static final int TABLE_NAME_FIELD_NUMBER = 7;
    private volatile java.lang.Object tableName_;
    /**
     * <pre>
     * The latest schema
     * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
     * into use throughout the code. Using the simpler one for now.
     * </pre>
     *
     * <code>required string table_name = 7;</code>
     */
    public boolean hasTableName() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <pre>
     * The latest schema
     * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
     * into use throughout the code. Using the simpler one for now.
     * </pre>
     *
     * <code>required string table_name = 7;</code>
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          tableName_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The latest schema
     * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
     * into use throughout the code. Using the simpler one for now.
     * </pre>
     *
     * <code>required string table_name = 7;</code>
     */
    public com.google.protobuf.ByteString
        getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_FIELD_NUMBER = 8;
    private org.apache.kudu.Common.SchemaPB schema_;
    /**
     * <code>required .kudu.SchemaPB schema = 8;</code>
     */
    public boolean hasSchema() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>required .kudu.SchemaPB schema = 8;</code>
     */
    public org.apache.kudu.Common.SchemaPB getSchema() {
      return schema_ == null ? org.apache.kudu.Common.SchemaPB.getDefaultInstance() : schema_;
    }
    /**
     * <code>required .kudu.SchemaPB schema = 8;</code>
     */
    public org.apache.kudu.Common.SchemaPBOrBuilder getSchemaOrBuilder() {
      return schema_ == null ? org.apache.kudu.Common.SchemaPB.getDefaultInstance() : schema_;
    }

    public static final int SCHEMA_VERSION_FIELD_NUMBER = 9;
    private int schemaVersion_;
    /**
     * <code>required uint32 schema_version = 9;</code>
     */
    public boolean hasSchemaVersion() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>required uint32 schema_version = 9;</code>
     */
    public int getSchemaVersion() {
      return schemaVersion_;
    }

    public static final int PARTITION_SCHEMA_FIELD_NUMBER = 14;
    private org.apache.kudu.Common.PartitionSchemaPB partitionSchema_;
    /**
     * <pre>
     * The partition schema of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
     */
    public boolean hasPartitionSchema() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <pre>
     * The partition schema of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
     */
    public org.apache.kudu.Common.PartitionSchemaPB getPartitionSchema() {
      return partitionSchema_ == null ? org.apache.kudu.Common.PartitionSchemaPB.getDefaultInstance() : partitionSchema_;
    }
    /**
     * <pre>
     * The partition schema of the table.
     * </pre>
     *
     * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
     */
    public org.apache.kudu.Common.PartitionSchemaPBOrBuilder getPartitionSchemaOrBuilder() {
      return partitionSchema_ == null ? org.apache.kudu.Common.PartitionSchemaPB.getDefaultInstance() : partitionSchema_;
    }

    public static final int TABLET_DATA_STATE_FIELD_NUMBER = 10;
    private int tabletDataState_;
    /**
     * <pre>
     * The current state of the tablet's data.
     * </pre>
     *
     * <code>optional .kudu.tablet.TabletDataState tablet_data_state = 10 [default = TABLET_DATA_UNKNOWN];</code>
     */
    public boolean hasTabletDataState() {
      return ((bitField0_ & 0x00000400) == 0x00000400);
    }
    /**
     * <pre>
     * The current state of the tablet's data.
     * </pre>
     *
     * <code>optional .kudu.tablet.TabletDataState tablet_data_state = 10 [default = TABLET_DATA_UNKNOWN];</code>
     */
    public org.apache.kudu.tablet.Metadata.TabletDataState getTabletDataState() {
      org.apache.kudu.tablet.Metadata.TabletDataState result = org.apache.kudu.tablet.Metadata.TabletDataState.valueOf(tabletDataState_);
      return result == null ? org.apache.kudu.tablet.Metadata.TabletDataState.TABLET_DATA_UNKNOWN : result;
    }

    public static final int ORPHANED_BLOCKS_FIELD_NUMBER = 11;
    private java.util.List<org.apache.kudu.Fs.BlockIdPB> orphanedBlocks_;
    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    public java.util.List<org.apache.kudu.Fs.BlockIdPB> getOrphanedBlocksList() {
      return orphanedBlocks_;
    }
    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    public java.util.List<? extends org.apache.kudu.Fs.BlockIdPBOrBuilder> 
        getOrphanedBlocksOrBuilderList() {
      return orphanedBlocks_;
    }
    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    public int getOrphanedBlocksCount() {
      return orphanedBlocks_.size();
    }
    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    public org.apache.kudu.Fs.BlockIdPB getOrphanedBlocks(int index) {
      return orphanedBlocks_.get(index);
    }
    /**
     * <pre>
     * Blocks that became orphans after flushing this superblock. In other
     * words, the set difference of the blocks belonging to the previous
     * superblock and this one.
     * It's always safe to delete the blocks found here.
     * </pre>
     *
     * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
     */
    public org.apache.kudu.Fs.BlockIdPBOrBuilder getOrphanedBlocksOrBuilder(
        int index) {
      return orphanedBlocks_.get(index);
    }

    public static final int TOMBSTONE_LAST_LOGGED_OPID_FIELD_NUMBER = 12;
    private org.apache.kudu.consensus.Opid.OpId tombstoneLastLoggedOpid_;
    /**
     * <pre>
     * For tablets that have been tombstoned, stores the last OpId stored in the
     * WAL before tombstoning.
     * Only relevant for TOMBSTONED tablets.
     * </pre>
     *
     * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
     */
    public boolean hasTombstoneLastLoggedOpid() {
      return ((bitField0_ & 0x00000800) == 0x00000800);
    }
    /**
     * <pre>
     * For tablets that have been tombstoned, stores the last OpId stored in the
     * WAL before tombstoning.
     * Only relevant for TOMBSTONED tablets.
     * </pre>
     *
     * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
     */
    public org.apache.kudu.consensus.Opid.OpId getTombstoneLastLoggedOpid() {
      return tombstoneLastLoggedOpid_ == null ? org.apache.kudu.consensus.Opid.OpId.getDefaultInstance() : tombstoneLastLoggedOpid_;
    }
    /**
     * <pre>
     * For tablets that have been tombstoned, stores the last OpId stored in the
     * WAL before tombstoning.
     * Only relevant for TOMBSTONED tablets.
     * </pre>
     *
     * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
     */
    public org.apache.kudu.consensus.Opid.OpIdOrBuilder getTombstoneLastLoggedOpidOrBuilder() {
      return tombstoneLastLoggedOpid_ == null ? org.apache.kudu.consensus.Opid.OpId.getDefaultInstance() : tombstoneLastLoggedOpid_;
    }

    public static final int DATA_DIR_GROUP_FIELD_NUMBER = 15;
    private org.apache.kudu.Fs.DataDirGroupPB dataDirGroup_;
    /**
     * <pre>
     * Tablet data is spread across a data directory group. If this is not set
     * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
     * from a version of Kudu before 1.5.0. In this case, a new group will be
     * created spanning all data directories.
     * </pre>
     *
     * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
     */
    public boolean hasDataDirGroup() {
      return ((bitField0_ & 0x00001000) == 0x00001000);
    }
    /**
     * <pre>
     * Tablet data is spread across a data directory group. If this is not set
     * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
     * from a version of Kudu before 1.5.0. In this case, a new group will be
     * created spanning all data directories.
     * </pre>
     *
     * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
     */
    public org.apache.kudu.Fs.DataDirGroupPB getDataDirGroup() {
      return dataDirGroup_ == null ? org.apache.kudu.Fs.DataDirGroupPB.getDefaultInstance() : dataDirGroup_;
    }
    /**
     * <pre>
     * Tablet data is spread across a data directory group. If this is not set
     * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
     * from a version of Kudu before 1.5.0. In this case, a new group will be
     * created spanning all data directories.
     * </pre>
     *
     * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
     */
    public org.apache.kudu.Fs.DataDirGroupPBOrBuilder getDataDirGroupOrBuilder() {
      return dataDirGroup_ == null ? org.apache.kudu.Fs.DataDirGroupPB.getDefaultInstance() : dataDirGroup_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasTableId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasTabletId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasLastDurableMrsId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasTableName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasSchema()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasSchemaVersion()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getRowsetsCount(); i++) {
        if (!getRowsets(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (!getSchema().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasPartitionSchema()) {
        if (!getPartitionSchema().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getOrphanedBlocksCount(); i++) {
        if (!getOrphanedBlocks(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasTombstoneLastLoggedOpid()) {
        if (!getTombstoneLastLoggedOpid().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, tableId_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, tabletId_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt64(3, lastDurableMrsId_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, startKey_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeBytes(5, endKey_);
      }
      for (int i = 0; i < rowsets_.size(); i++) {
        output.writeMessage(6, rowsets_.get(i));
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, tableName_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeMessage(8, getSchema());
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeUInt32(9, schemaVersion_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        output.writeEnum(10, tabletDataState_);
      }
      for (int i = 0; i < orphanedBlocks_.size(); i++) {
        output.writeMessage(11, orphanedBlocks_.get(i));
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        output.writeMessage(12, getTombstoneLastLoggedOpid());
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeMessage(13, getPartition());
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        output.writeMessage(14, getPartitionSchema());
      }
      if (((bitField0_ & 0x00001000) == 0x00001000)) {
        output.writeMessage(15, getDataDirGroup());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, tableId_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, tabletId_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(3, lastDurableMrsId_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, startKey_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(5, endKey_);
      }
      for (int i = 0; i < rowsets_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, rowsets_.get(i));
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, tableName_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, getSchema());
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(9, schemaVersion_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(10, tabletDataState_);
      }
      for (int i = 0; i < orphanedBlocks_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, orphanedBlocks_.get(i));
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(12, getTombstoneLastLoggedOpid());
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(13, getPartition());
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(14, getPartitionSchema());
      }
      if (((bitField0_ & 0x00001000) == 0x00001000)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(15, getDataDirGroup());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.kudu.tablet.Metadata.TabletSuperBlockPB)) {
        return super.equals(obj);
      }
      org.apache.kudu.tablet.Metadata.TabletSuperBlockPB other = (org.apache.kudu.tablet.Metadata.TabletSuperBlockPB) obj;

      boolean result = true;
      result = result && (hasTableId() == other.hasTableId());
      if (hasTableId()) {
        result = result && getTableId()
            .equals(other.getTableId());
      }
      result = result && (hasTabletId() == other.hasTabletId());
      if (hasTabletId()) {
        result = result && getTabletId()
            .equals(other.getTabletId());
      }
      result = result && (hasLastDurableMrsId() == other.hasLastDurableMrsId());
      if (hasLastDurableMrsId()) {
        result = result && (getLastDurableMrsId()
            == other.getLastDurableMrsId());
      }
      result = result && (hasStartKey() == other.hasStartKey());
      if (hasStartKey()) {
        result = result && getStartKey()
            .equals(other.getStartKey());
      }
      result = result && (hasEndKey() == other.hasEndKey());
      if (hasEndKey()) {
        result = result && getEndKey()
            .equals(other.getEndKey());
      }
      result = result && (hasPartition() == other.hasPartition());
      if (hasPartition()) {
        result = result && getPartition()
            .equals(other.getPartition());
      }
      result = result && getRowsetsList()
          .equals(other.getRowsetsList());
      result = result && (hasTableName() == other.hasTableName());
      if (hasTableName()) {
        result = result && getTableName()
            .equals(other.getTableName());
      }
      result = result && (hasSchema() == other.hasSchema());
      if (hasSchema()) {
        result = result && getSchema()
            .equals(other.getSchema());
      }
      result = result && (hasSchemaVersion() == other.hasSchemaVersion());
      if (hasSchemaVersion()) {
        result = result && (getSchemaVersion()
            == other.getSchemaVersion());
      }
      result = result && (hasPartitionSchema() == other.hasPartitionSchema());
      if (hasPartitionSchema()) {
        result = result && getPartitionSchema()
            .equals(other.getPartitionSchema());
      }
      result = result && (hasTabletDataState() == other.hasTabletDataState());
      if (hasTabletDataState()) {
        result = result && tabletDataState_ == other.tabletDataState_;
      }
      result = result && getOrphanedBlocksList()
          .equals(other.getOrphanedBlocksList());
      result = result && (hasTombstoneLastLoggedOpid() == other.hasTombstoneLastLoggedOpid());
      if (hasTombstoneLastLoggedOpid()) {
        result = result && getTombstoneLastLoggedOpid()
            .equals(other.getTombstoneLastLoggedOpid());
      }
      result = result && (hasDataDirGroup() == other.hasDataDirGroup());
      if (hasDataDirGroup()) {
        result = result && getDataDirGroup()
            .equals(other.getDataDirGroup());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTableId()) {
        hash = (37 * hash) + TABLE_ID_FIELD_NUMBER;
        hash = (53 * hash) + getTableId().hashCode();
      }
      if (hasTabletId()) {
        hash = (37 * hash) + TABLET_ID_FIELD_NUMBER;
        hash = (53 * hash) + getTabletId().hashCode();
      }
      if (hasLastDurableMrsId()) {
        hash = (37 * hash) + LAST_DURABLE_MRS_ID_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getLastDurableMrsId());
      }
      if (hasStartKey()) {
        hash = (37 * hash) + START_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getStartKey().hashCode();
      }
      if (hasEndKey()) {
        hash = (37 * hash) + END_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getEndKey().hashCode();
      }
      if (hasPartition()) {
        hash = (37 * hash) + PARTITION_FIELD_NUMBER;
        hash = (53 * hash) + getPartition().hashCode();
      }
      if (getRowsetsCount() > 0) {
        hash = (37 * hash) + ROWSETS_FIELD_NUMBER;
        hash = (53 * hash) + getRowsetsList().hashCode();
      }
      if (hasTableName()) {
        hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getTableName().hashCode();
      }
      if (hasSchema()) {
        hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getSchema().hashCode();
      }
      if (hasSchemaVersion()) {
        hash = (37 * hash) + SCHEMA_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getSchemaVersion();
      }
      if (hasPartitionSchema()) {
        hash = (37 * hash) + PARTITION_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getPartitionSchema().hashCode();
      }
      if (hasTabletDataState()) {
        hash = (37 * hash) + TABLET_DATA_STATE_FIELD_NUMBER;
        hash = (53 * hash) + tabletDataState_;
      }
      if (getOrphanedBlocksCount() > 0) {
        hash = (37 * hash) + ORPHANED_BLOCKS_FIELD_NUMBER;
        hash = (53 * hash) + getOrphanedBlocksList().hashCode();
      }
      if (hasTombstoneLastLoggedOpid()) {
        hash = (37 * hash) + TOMBSTONE_LAST_LOGGED_OPID_FIELD_NUMBER;
        hash = (53 * hash) + getTombstoneLastLoggedOpid().hashCode();
      }
      if (hasDataDirGroup()) {
        hash = (37 * hash) + DATA_DIR_GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getDataDirGroup().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.kudu.tablet.Metadata.TabletSuperBlockPB prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * The super-block keeps track of the tablet data blocks.
     * A tablet contains one or more RowSets, which contain
     * a set of blocks (one for each column), a set of delta blocks
     * and optionally a block containing the bloom filter
     * and a block containing the compound-keys.
     * </pre>
     *
     * Protobuf type {@code kudu.tablet.TabletSuperBlockPB}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:kudu.tablet.TabletSuperBlockPB)
        org.apache.kudu.tablet.Metadata.TabletSuperBlockPBOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_TabletSuperBlockPB_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_TabletSuperBlockPB_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.kudu.tablet.Metadata.TabletSuperBlockPB.class, org.apache.kudu.tablet.Metadata.TabletSuperBlockPB.Builder.class);
      }

      // Construct using org.apache.kudu.tablet.Metadata.TabletSuperBlockPB.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPartitionFieldBuilder();
          getRowsetsFieldBuilder();
          getSchemaFieldBuilder();
          getPartitionSchemaFieldBuilder();
          getOrphanedBlocksFieldBuilder();
          getTombstoneLastLoggedOpidFieldBuilder();
          getDataDirGroupFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        tableId_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        tabletId_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        lastDurableMrsId_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        startKey_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        endKey_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000010);
        if (partitionBuilder_ == null) {
          partition_ = null;
        } else {
          partitionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        if (rowsetsBuilder_ == null) {
          rowsets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          rowsetsBuilder_.clear();
        }
        tableName_ = "";
        bitField0_ = (bitField0_ & ~0x00000080);
        if (schemaBuilder_ == null) {
          schema_ = null;
        } else {
          schemaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        schemaVersion_ = 0;
        bitField0_ = (bitField0_ & ~0x00000200);
        if (partitionSchemaBuilder_ == null) {
          partitionSchema_ = null;
        } else {
          partitionSchemaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000400);
        tabletDataState_ = 999;
        bitField0_ = (bitField0_ & ~0x00000800);
        if (orphanedBlocksBuilder_ == null) {
          orphanedBlocks_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00001000);
        } else {
          orphanedBlocksBuilder_.clear();
        }
        if (tombstoneLastLoggedOpidBuilder_ == null) {
          tombstoneLastLoggedOpid_ = null;
        } else {
          tombstoneLastLoggedOpidBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00002000);
        if (dataDirGroupBuilder_ == null) {
          dataDirGroup_ = null;
        } else {
          dataDirGroupBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00004000);
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.kudu.tablet.Metadata.internal_static_kudu_tablet_TabletSuperBlockPB_descriptor;
      }

      public org.apache.kudu.tablet.Metadata.TabletSuperBlockPB getDefaultInstanceForType() {
        return org.apache.kudu.tablet.Metadata.TabletSuperBlockPB.getDefaultInstance();
      }

      public org.apache.kudu.tablet.Metadata.TabletSuperBlockPB build() {
        org.apache.kudu.tablet.Metadata.TabletSuperBlockPB result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.kudu.tablet.Metadata.TabletSuperBlockPB buildPartial() {
        org.apache.kudu.tablet.Metadata.TabletSuperBlockPB result = new org.apache.kudu.tablet.Metadata.TabletSuperBlockPB(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.tableId_ = tableId_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.tabletId_ = tabletId_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.lastDurableMrsId_ = lastDurableMrsId_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.startKey_ = startKey_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.endKey_ = endKey_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        if (partitionBuilder_ == null) {
          result.partition_ = partition_;
        } else {
          result.partition_ = partitionBuilder_.build();
        }
        if (rowsetsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040)) {
            rowsets_ = java.util.Collections.unmodifiableList(rowsets_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.rowsets_ = rowsets_;
        } else {
          result.rowsets_ = rowsetsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000040;
        }
        result.tableName_ = tableName_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000080;
        }
        if (schemaBuilder_ == null) {
          result.schema_ = schema_;
        } else {
          result.schema_ = schemaBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000100;
        }
        result.schemaVersion_ = schemaVersion_;
        if (((from_bitField0_ & 0x00000400) == 0x00000400)) {
          to_bitField0_ |= 0x00000200;
        }
        if (partitionSchemaBuilder_ == null) {
          result.partitionSchema_ = partitionSchema_;
        } else {
          result.partitionSchema_ = partitionSchemaBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000800) == 0x00000800)) {
          to_bitField0_ |= 0x00000400;
        }
        result.tabletDataState_ = tabletDataState_;
        if (orphanedBlocksBuilder_ == null) {
          if (((bitField0_ & 0x00001000) == 0x00001000)) {
            orphanedBlocks_ = java.util.Collections.unmodifiableList(orphanedBlocks_);
            bitField0_ = (bitField0_ & ~0x00001000);
          }
          result.orphanedBlocks_ = orphanedBlocks_;
        } else {
          result.orphanedBlocks_ = orphanedBlocksBuilder_.build();
        }
        if (((from_bitField0_ & 0x00002000) == 0x00002000)) {
          to_bitField0_ |= 0x00000800;
        }
        if (tombstoneLastLoggedOpidBuilder_ == null) {
          result.tombstoneLastLoggedOpid_ = tombstoneLastLoggedOpid_;
        } else {
          result.tombstoneLastLoggedOpid_ = tombstoneLastLoggedOpidBuilder_.build();
        }
        if (((from_bitField0_ & 0x00004000) == 0x00004000)) {
          to_bitField0_ |= 0x00001000;
        }
        if (dataDirGroupBuilder_ == null) {
          result.dataDirGroup_ = dataDirGroup_;
        } else {
          result.dataDirGroup_ = dataDirGroupBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.kudu.tablet.Metadata.TabletSuperBlockPB) {
          return mergeFrom((org.apache.kudu.tablet.Metadata.TabletSuperBlockPB)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.kudu.tablet.Metadata.TabletSuperBlockPB other) {
        if (other == org.apache.kudu.tablet.Metadata.TabletSuperBlockPB.getDefaultInstance()) return this;
        if (other.hasTableId()) {
          setTableId(other.getTableId());
        }
        if (other.hasTabletId()) {
          setTabletId(other.getTabletId());
        }
        if (other.hasLastDurableMrsId()) {
          setLastDurableMrsId(other.getLastDurableMrsId());
        }
        if (other.hasStartKey()) {
          setStartKey(other.getStartKey());
        }
        if (other.hasEndKey()) {
          setEndKey(other.getEndKey());
        }
        if (other.hasPartition()) {
          mergePartition(other.getPartition());
        }
        if (rowsetsBuilder_ == null) {
          if (!other.rowsets_.isEmpty()) {
            if (rowsets_.isEmpty()) {
              rowsets_ = other.rowsets_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureRowsetsIsMutable();
              rowsets_.addAll(other.rowsets_);
            }
            onChanged();
          }
        } else {
          if (!other.rowsets_.isEmpty()) {
            if (rowsetsBuilder_.isEmpty()) {
              rowsetsBuilder_.dispose();
              rowsetsBuilder_ = null;
              rowsets_ = other.rowsets_;
              bitField0_ = (bitField0_ & ~0x00000040);
              rowsetsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getRowsetsFieldBuilder() : null;
            } else {
              rowsetsBuilder_.addAllMessages(other.rowsets_);
            }
          }
        }
        if (other.hasTableName()) {
          bitField0_ |= 0x00000080;
          tableName_ = other.tableName_;
          onChanged();
        }
        if (other.hasSchema()) {
          mergeSchema(other.getSchema());
        }
        if (other.hasSchemaVersion()) {
          setSchemaVersion(other.getSchemaVersion());
        }
        if (other.hasPartitionSchema()) {
          mergePartitionSchema(other.getPartitionSchema());
        }
        if (other.hasTabletDataState()) {
          setTabletDataState(other.getTabletDataState());
        }
        if (orphanedBlocksBuilder_ == null) {
          if (!other.orphanedBlocks_.isEmpty()) {
            if (orphanedBlocks_.isEmpty()) {
              orphanedBlocks_ = other.orphanedBlocks_;
              bitField0_ = (bitField0_ & ~0x00001000);
            } else {
              ensureOrphanedBlocksIsMutable();
              orphanedBlocks_.addAll(other.orphanedBlocks_);
            }
            onChanged();
          }
        } else {
          if (!other.orphanedBlocks_.isEmpty()) {
            if (orphanedBlocksBuilder_.isEmpty()) {
              orphanedBlocksBuilder_.dispose();
              orphanedBlocksBuilder_ = null;
              orphanedBlocks_ = other.orphanedBlocks_;
              bitField0_ = (bitField0_ & ~0x00001000);
              orphanedBlocksBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getOrphanedBlocksFieldBuilder() : null;
            } else {
              orphanedBlocksBuilder_.addAllMessages(other.orphanedBlocks_);
            }
          }
        }
        if (other.hasTombstoneLastLoggedOpid()) {
          mergeTombstoneLastLoggedOpid(other.getTombstoneLastLoggedOpid());
        }
        if (other.hasDataDirGroup()) {
          mergeDataDirGroup(other.getDataDirGroup());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        if (!hasTableId()) {
          return false;
        }
        if (!hasTabletId()) {
          return false;
        }
        if (!hasLastDurableMrsId()) {
          return false;
        }
        if (!hasTableName()) {
          return false;
        }
        if (!hasSchema()) {
          return false;
        }
        if (!hasSchemaVersion()) {
          return false;
        }
        for (int i = 0; i < getRowsetsCount(); i++) {
          if (!getRowsets(i).isInitialized()) {
            return false;
          }
        }
        if (!getSchema().isInitialized()) {
          return false;
        }
        if (hasPartitionSchema()) {
          if (!getPartitionSchema().isInitialized()) {
            return false;
          }
        }
        for (int i = 0; i < getOrphanedBlocksCount(); i++) {
          if (!getOrphanedBlocks(i).isInitialized()) {
            return false;
          }
        }
        if (hasTombstoneLastLoggedOpid()) {
          if (!getTombstoneLastLoggedOpid().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.kudu.tablet.Metadata.TabletSuperBlockPB parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.kudu.tablet.Metadata.TabletSuperBlockPB) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.ByteString tableId_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       * Table ID of the table this tablet is part of.
       * </pre>
       *
       * <code>required bytes table_id = 1;</code>
       */
      public boolean hasTableId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <pre>
       * Table ID of the table this tablet is part of.
       * </pre>
       *
       * <code>required bytes table_id = 1;</code>
       */
      public com.google.protobuf.ByteString getTableId() {
        return tableId_;
      }
      /**
       * <pre>
       * Table ID of the table this tablet is part of.
       * </pre>
       *
       * <code>required bytes table_id = 1;</code>
       */
      public Builder setTableId(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        tableId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Table ID of the table this tablet is part of.
       * </pre>
       *
       * <code>required bytes table_id = 1;</code>
       */
      public Builder clearTableId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        tableId_ = getDefaultInstance().getTableId();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString tabletId_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       * Tablet Id
       * </pre>
       *
       * <code>required bytes tablet_id = 2;</code>
       */
      public boolean hasTabletId() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <pre>
       * Tablet Id
       * </pre>
       *
       * <code>required bytes tablet_id = 2;</code>
       */
      public com.google.protobuf.ByteString getTabletId() {
        return tabletId_;
      }
      /**
       * <pre>
       * Tablet Id
       * </pre>
       *
       * <code>required bytes tablet_id = 2;</code>
       */
      public Builder setTabletId(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        tabletId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Tablet Id
       * </pre>
       *
       * <code>required bytes tablet_id = 2;</code>
       */
      public Builder clearTabletId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        tabletId_ = getDefaultInstance().getTabletId();
        onChanged();
        return this;
      }

      private long lastDurableMrsId_ ;
      /**
       * <pre>
       * The latest durable MemRowSet id
       * </pre>
       *
       * <code>required int64 last_durable_mrs_id = 3;</code>
       */
      public boolean hasLastDurableMrsId() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <pre>
       * The latest durable MemRowSet id
       * </pre>
       *
       * <code>required int64 last_durable_mrs_id = 3;</code>
       */
      public long getLastDurableMrsId() {
        return lastDurableMrsId_;
      }
      /**
       * <pre>
       * The latest durable MemRowSet id
       * </pre>
       *
       * <code>required int64 last_durable_mrs_id = 3;</code>
       */
      public Builder setLastDurableMrsId(long value) {
        bitField0_ |= 0x00000004;
        lastDurableMrsId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The latest durable MemRowSet id
       * </pre>
       *
       * <code>required int64 last_durable_mrs_id = 3;</code>
       */
      public Builder clearLastDurableMrsId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        lastDurableMrsId_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString startKey_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       * DEPRECATED.
       * </pre>
       *
       * <code>optional bytes start_key = 4;</code>
       */
      public boolean hasStartKey() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <pre>
       * DEPRECATED.
       * </pre>
       *
       * <code>optional bytes start_key = 4;</code>
       */
      public com.google.protobuf.ByteString getStartKey() {
        return startKey_;
      }
      /**
       * <pre>
       * DEPRECATED.
       * </pre>
       *
       * <code>optional bytes start_key = 4;</code>
       */
      public Builder setStartKey(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        startKey_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * DEPRECATED.
       * </pre>
       *
       * <code>optional bytes start_key = 4;</code>
       */
      public Builder clearStartKey() {
        bitField0_ = (bitField0_ & ~0x00000008);
        startKey_ = getDefaultInstance().getStartKey();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString endKey_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       * DEPRECATED.
       * </pre>
       *
       * <code>optional bytes end_key = 5;</code>
       */
      public boolean hasEndKey() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <pre>
       * DEPRECATED.
       * </pre>
       *
       * <code>optional bytes end_key = 5;</code>
       */
      public com.google.protobuf.ByteString getEndKey() {
        return endKey_;
      }
      /**
       * <pre>
       * DEPRECATED.
       * </pre>
       *
       * <code>optional bytes end_key = 5;</code>
       */
      public Builder setEndKey(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        endKey_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * DEPRECATED.
       * </pre>
       *
       * <code>optional bytes end_key = 5;</code>
       */
      public Builder clearEndKey() {
        bitField0_ = (bitField0_ & ~0x00000010);
        endKey_ = getDefaultInstance().getEndKey();
        onChanged();
        return this;
      }

      private org.apache.kudu.Common.PartitionPB partition_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Common.PartitionPB, org.apache.kudu.Common.PartitionPB.Builder, org.apache.kudu.Common.PartitionPBOrBuilder> partitionBuilder_;
      /**
       * <pre>
       * The partition of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionPB partition = 13;</code>
       */
      public boolean hasPartition() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <pre>
       * The partition of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionPB partition = 13;</code>
       */
      public org.apache.kudu.Common.PartitionPB getPartition() {
        if (partitionBuilder_ == null) {
          return partition_ == null ? org.apache.kudu.Common.PartitionPB.getDefaultInstance() : partition_;
        } else {
          return partitionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The partition of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionPB partition = 13;</code>
       */
      public Builder setPartition(org.apache.kudu.Common.PartitionPB value) {
        if (partitionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          partition_ = value;
          onChanged();
        } else {
          partitionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <pre>
       * The partition of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionPB partition = 13;</code>
       */
      public Builder setPartition(
          org.apache.kudu.Common.PartitionPB.Builder builderForValue) {
        if (partitionBuilder_ == null) {
          partition_ = builderForValue.build();
          onChanged();
        } else {
          partitionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <pre>
       * The partition of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionPB partition = 13;</code>
       */
      public Builder mergePartition(org.apache.kudu.Common.PartitionPB value) {
        if (partitionBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020) &&
              partition_ != null &&
              partition_ != org.apache.kudu.Common.PartitionPB.getDefaultInstance()) {
            partition_ =
              org.apache.kudu.Common.PartitionPB.newBuilder(partition_).mergeFrom(value).buildPartial();
          } else {
            partition_ = value;
          }
          onChanged();
        } else {
          partitionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <pre>
       * The partition of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionPB partition = 13;</code>
       */
      public Builder clearPartition() {
        if (partitionBuilder_ == null) {
          partition_ = null;
          onChanged();
        } else {
          partitionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }
      /**
       * <pre>
       * The partition of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionPB partition = 13;</code>
       */
      public org.apache.kudu.Common.PartitionPB.Builder getPartitionBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getPartitionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The partition of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionPB partition = 13;</code>
       */
      public org.apache.kudu.Common.PartitionPBOrBuilder getPartitionOrBuilder() {
        if (partitionBuilder_ != null) {
          return partitionBuilder_.getMessageOrBuilder();
        } else {
          return partition_ == null ?
              org.apache.kudu.Common.PartitionPB.getDefaultInstance() : partition_;
        }
      }
      /**
       * <pre>
       * The partition of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionPB partition = 13;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Common.PartitionPB, org.apache.kudu.Common.PartitionPB.Builder, org.apache.kudu.Common.PartitionPBOrBuilder> 
          getPartitionFieldBuilder() {
        if (partitionBuilder_ == null) {
          partitionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.kudu.Common.PartitionPB, org.apache.kudu.Common.PartitionPB.Builder, org.apache.kudu.Common.PartitionPBOrBuilder>(
                  getPartition(),
                  getParentForChildren(),
                  isClean());
          partition_ = null;
        }
        return partitionBuilder_;
      }

      private java.util.List<org.apache.kudu.tablet.Metadata.RowSetDataPB> rowsets_ =
        java.util.Collections.emptyList();
      private void ensureRowsetsIsMutable() {
        if (!((bitField0_ & 0x00000040) == 0x00000040)) {
          rowsets_ = new java.util.ArrayList<org.apache.kudu.tablet.Metadata.RowSetDataPB>(rowsets_);
          bitField0_ |= 0x00000040;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.tablet.Metadata.RowSetDataPB, org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder, org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder> rowsetsBuilder_;

      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public java.util.List<org.apache.kudu.tablet.Metadata.RowSetDataPB> getRowsetsList() {
        if (rowsetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(rowsets_);
        } else {
          return rowsetsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public int getRowsetsCount() {
        if (rowsetsBuilder_ == null) {
          return rowsets_.size();
        } else {
          return rowsetsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public org.apache.kudu.tablet.Metadata.RowSetDataPB getRowsets(int index) {
        if (rowsetsBuilder_ == null) {
          return rowsets_.get(index);
        } else {
          return rowsetsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public Builder setRowsets(
          int index, org.apache.kudu.tablet.Metadata.RowSetDataPB value) {
        if (rowsetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowsetsIsMutable();
          rowsets_.set(index, value);
          onChanged();
        } else {
          rowsetsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public Builder setRowsets(
          int index, org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder builderForValue) {
        if (rowsetsBuilder_ == null) {
          ensureRowsetsIsMutable();
          rowsets_.set(index, builderForValue.build());
          onChanged();
        } else {
          rowsetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public Builder addRowsets(org.apache.kudu.tablet.Metadata.RowSetDataPB value) {
        if (rowsetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowsetsIsMutable();
          rowsets_.add(value);
          onChanged();
        } else {
          rowsetsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public Builder addRowsets(
          int index, org.apache.kudu.tablet.Metadata.RowSetDataPB value) {
        if (rowsetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowsetsIsMutable();
          rowsets_.add(index, value);
          onChanged();
        } else {
          rowsetsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public Builder addRowsets(
          org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder builderForValue) {
        if (rowsetsBuilder_ == null) {
          ensureRowsetsIsMutable();
          rowsets_.add(builderForValue.build());
          onChanged();
        } else {
          rowsetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public Builder addRowsets(
          int index, org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder builderForValue) {
        if (rowsetsBuilder_ == null) {
          ensureRowsetsIsMutable();
          rowsets_.add(index, builderForValue.build());
          onChanged();
        } else {
          rowsetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public Builder addAllRowsets(
          java.lang.Iterable<? extends org.apache.kudu.tablet.Metadata.RowSetDataPB> values) {
        if (rowsetsBuilder_ == null) {
          ensureRowsetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, rowsets_);
          onChanged();
        } else {
          rowsetsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public Builder clearRowsets() {
        if (rowsetsBuilder_ == null) {
          rowsets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          rowsetsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public Builder removeRowsets(int index) {
        if (rowsetsBuilder_ == null) {
          ensureRowsetsIsMutable();
          rowsets_.remove(index);
          onChanged();
        } else {
          rowsetsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder getRowsetsBuilder(
          int index) {
        return getRowsetsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder getRowsetsOrBuilder(
          int index) {
        if (rowsetsBuilder_ == null) {
          return rowsets_.get(index);  } else {
          return rowsetsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public java.util.List<? extends org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder> 
           getRowsetsOrBuilderList() {
        if (rowsetsBuilder_ != null) {
          return rowsetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(rowsets_);
        }
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder addRowsetsBuilder() {
        return getRowsetsFieldBuilder().addBuilder(
            org.apache.kudu.tablet.Metadata.RowSetDataPB.getDefaultInstance());
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder addRowsetsBuilder(
          int index) {
        return getRowsetsFieldBuilder().addBuilder(
            index, org.apache.kudu.tablet.Metadata.RowSetDataPB.getDefaultInstance());
      }
      /**
       * <pre>
       * Tablet RowSets
       * </pre>
       *
       * <code>repeated .kudu.tablet.RowSetDataPB rowsets = 6;</code>
       */
      public java.util.List<org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder> 
           getRowsetsBuilderList() {
        return getRowsetsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.tablet.Metadata.RowSetDataPB, org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder, org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder> 
          getRowsetsFieldBuilder() {
        if (rowsetsBuilder_ == null) {
          rowsetsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.kudu.tablet.Metadata.RowSetDataPB, org.apache.kudu.tablet.Metadata.RowSetDataPB.Builder, org.apache.kudu.tablet.Metadata.RowSetDataPBOrBuilder>(
                  rowsets_,
                  ((bitField0_ & 0x00000040) == 0x00000040),
                  getParentForChildren(),
                  isClean());
          rowsets_ = null;
        }
        return rowsetsBuilder_;
      }

      private java.lang.Object tableName_ = "";
      /**
       * <pre>
       * The latest schema
       * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
       * into use throughout the code. Using the simpler one for now.
       * </pre>
       *
       * <code>required string table_name = 7;</code>
       */
      public boolean hasTableName() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <pre>
       * The latest schema
       * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
       * into use throughout the code. Using the simpler one for now.
       * </pre>
       *
       * <code>required string table_name = 7;</code>
       */
      public java.lang.String getTableName() {
        java.lang.Object ref = tableName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            tableName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The latest schema
       * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
       * into use throughout the code. Using the simpler one for now.
       * </pre>
       *
       * <code>required string table_name = 7;</code>
       */
      public com.google.protobuf.ByteString
          getTableNameBytes() {
        java.lang.Object ref = tableName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tableName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The latest schema
       * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
       * into use throughout the code. Using the simpler one for now.
       * </pre>
       *
       * <code>required string table_name = 7;</code>
       */
      public Builder setTableName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        tableName_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The latest schema
       * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
       * into use throughout the code. Using the simpler one for now.
       * </pre>
       *
       * <code>required string table_name = 7;</code>
       */
      public Builder clearTableName() {
        bitField0_ = (bitField0_ & ~0x00000080);
        tableName_ = getDefaultInstance().getTableName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The latest schema
       * TODO: maybe this should be TableSchemaPB? Need to actually put those attributes
       * into use throughout the code. Using the simpler one for now.
       * </pre>
       *
       * <code>required string table_name = 7;</code>
       */
      public Builder setTableNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        tableName_ = value;
        onChanged();
        return this;
      }

      private org.apache.kudu.Common.SchemaPB schema_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Common.SchemaPB, org.apache.kudu.Common.SchemaPB.Builder, org.apache.kudu.Common.SchemaPBOrBuilder> schemaBuilder_;
      /**
       * <code>required .kudu.SchemaPB schema = 8;</code>
       */
      public boolean hasSchema() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>required .kudu.SchemaPB schema = 8;</code>
       */
      public org.apache.kudu.Common.SchemaPB getSchema() {
        if (schemaBuilder_ == null) {
          return schema_ == null ? org.apache.kudu.Common.SchemaPB.getDefaultInstance() : schema_;
        } else {
          return schemaBuilder_.getMessage();
        }
      }
      /**
       * <code>required .kudu.SchemaPB schema = 8;</code>
       */
      public Builder setSchema(org.apache.kudu.Common.SchemaPB value) {
        if (schemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          schema_ = value;
          onChanged();
        } else {
          schemaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>required .kudu.SchemaPB schema = 8;</code>
       */
      public Builder setSchema(
          org.apache.kudu.Common.SchemaPB.Builder builderForValue) {
        if (schemaBuilder_ == null) {
          schema_ = builderForValue.build();
          onChanged();
        } else {
          schemaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>required .kudu.SchemaPB schema = 8;</code>
       */
      public Builder mergeSchema(org.apache.kudu.Common.SchemaPB value) {
        if (schemaBuilder_ == null) {
          if (((bitField0_ & 0x00000100) == 0x00000100) &&
              schema_ != null &&
              schema_ != org.apache.kudu.Common.SchemaPB.getDefaultInstance()) {
            schema_ =
              org.apache.kudu.Common.SchemaPB.newBuilder(schema_).mergeFrom(value).buildPartial();
          } else {
            schema_ = value;
          }
          onChanged();
        } else {
          schemaBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>required .kudu.SchemaPB schema = 8;</code>
       */
      public Builder clearSchema() {
        if (schemaBuilder_ == null) {
          schema_ = null;
          onChanged();
        } else {
          schemaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }
      /**
       * <code>required .kudu.SchemaPB schema = 8;</code>
       */
      public org.apache.kudu.Common.SchemaPB.Builder getSchemaBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getSchemaFieldBuilder().getBuilder();
      }
      /**
       * <code>required .kudu.SchemaPB schema = 8;</code>
       */
      public org.apache.kudu.Common.SchemaPBOrBuilder getSchemaOrBuilder() {
        if (schemaBuilder_ != null) {
          return schemaBuilder_.getMessageOrBuilder();
        } else {
          return schema_ == null ?
              org.apache.kudu.Common.SchemaPB.getDefaultInstance() : schema_;
        }
      }
      /**
       * <code>required .kudu.SchemaPB schema = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Common.SchemaPB, org.apache.kudu.Common.SchemaPB.Builder, org.apache.kudu.Common.SchemaPBOrBuilder> 
          getSchemaFieldBuilder() {
        if (schemaBuilder_ == null) {
          schemaBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.kudu.Common.SchemaPB, org.apache.kudu.Common.SchemaPB.Builder, org.apache.kudu.Common.SchemaPBOrBuilder>(
                  getSchema(),
                  getParentForChildren(),
                  isClean());
          schema_ = null;
        }
        return schemaBuilder_;
      }

      private int schemaVersion_ ;
      /**
       * <code>required uint32 schema_version = 9;</code>
       */
      public boolean hasSchemaVersion() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>required uint32 schema_version = 9;</code>
       */
      public int getSchemaVersion() {
        return schemaVersion_;
      }
      /**
       * <code>required uint32 schema_version = 9;</code>
       */
      public Builder setSchemaVersion(int value) {
        bitField0_ |= 0x00000200;
        schemaVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 schema_version = 9;</code>
       */
      public Builder clearSchemaVersion() {
        bitField0_ = (bitField0_ & ~0x00000200);
        schemaVersion_ = 0;
        onChanged();
        return this;
      }

      private org.apache.kudu.Common.PartitionSchemaPB partitionSchema_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Common.PartitionSchemaPB, org.apache.kudu.Common.PartitionSchemaPB.Builder, org.apache.kudu.Common.PartitionSchemaPBOrBuilder> partitionSchemaBuilder_;
      /**
       * <pre>
       * The partition schema of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
       */
      public boolean hasPartitionSchema() {
        return ((bitField0_ & 0x00000400) == 0x00000400);
      }
      /**
       * <pre>
       * The partition schema of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
       */
      public org.apache.kudu.Common.PartitionSchemaPB getPartitionSchema() {
        if (partitionSchemaBuilder_ == null) {
          return partitionSchema_ == null ? org.apache.kudu.Common.PartitionSchemaPB.getDefaultInstance() : partitionSchema_;
        } else {
          return partitionSchemaBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The partition schema of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
       */
      public Builder setPartitionSchema(org.apache.kudu.Common.PartitionSchemaPB value) {
        if (partitionSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          partitionSchema_ = value;
          onChanged();
        } else {
          partitionSchemaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000400;
        return this;
      }
      /**
       * <pre>
       * The partition schema of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
       */
      public Builder setPartitionSchema(
          org.apache.kudu.Common.PartitionSchemaPB.Builder builderForValue) {
        if (partitionSchemaBuilder_ == null) {
          partitionSchema_ = builderForValue.build();
          onChanged();
        } else {
          partitionSchemaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000400;
        return this;
      }
      /**
       * <pre>
       * The partition schema of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
       */
      public Builder mergePartitionSchema(org.apache.kudu.Common.PartitionSchemaPB value) {
        if (partitionSchemaBuilder_ == null) {
          if (((bitField0_ & 0x00000400) == 0x00000400) &&
              partitionSchema_ != null &&
              partitionSchema_ != org.apache.kudu.Common.PartitionSchemaPB.getDefaultInstance()) {
            partitionSchema_ =
              org.apache.kudu.Common.PartitionSchemaPB.newBuilder(partitionSchema_).mergeFrom(value).buildPartial();
          } else {
            partitionSchema_ = value;
          }
          onChanged();
        } else {
          partitionSchemaBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000400;
        return this;
      }
      /**
       * <pre>
       * The partition schema of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
       */
      public Builder clearPartitionSchema() {
        if (partitionSchemaBuilder_ == null) {
          partitionSchema_ = null;
          onChanged();
        } else {
          partitionSchemaBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000400);
        return this;
      }
      /**
       * <pre>
       * The partition schema of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
       */
      public org.apache.kudu.Common.PartitionSchemaPB.Builder getPartitionSchemaBuilder() {
        bitField0_ |= 0x00000400;
        onChanged();
        return getPartitionSchemaFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The partition schema of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
       */
      public org.apache.kudu.Common.PartitionSchemaPBOrBuilder getPartitionSchemaOrBuilder() {
        if (partitionSchemaBuilder_ != null) {
          return partitionSchemaBuilder_.getMessageOrBuilder();
        } else {
          return partitionSchema_ == null ?
              org.apache.kudu.Common.PartitionSchemaPB.getDefaultInstance() : partitionSchema_;
        }
      }
      /**
       * <pre>
       * The partition schema of the table.
       * </pre>
       *
       * <code>optional .kudu.PartitionSchemaPB partition_schema = 14;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Common.PartitionSchemaPB, org.apache.kudu.Common.PartitionSchemaPB.Builder, org.apache.kudu.Common.PartitionSchemaPBOrBuilder> 
          getPartitionSchemaFieldBuilder() {
        if (partitionSchemaBuilder_ == null) {
          partitionSchemaBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.kudu.Common.PartitionSchemaPB, org.apache.kudu.Common.PartitionSchemaPB.Builder, org.apache.kudu.Common.PartitionSchemaPBOrBuilder>(
                  getPartitionSchema(),
                  getParentForChildren(),
                  isClean());
          partitionSchema_ = null;
        }
        return partitionSchemaBuilder_;
      }

      private int tabletDataState_ = 999;
      /**
       * <pre>
       * The current state of the tablet's data.
       * </pre>
       *
       * <code>optional .kudu.tablet.TabletDataState tablet_data_state = 10 [default = TABLET_DATA_UNKNOWN];</code>
       */
      public boolean hasTabletDataState() {
        return ((bitField0_ & 0x00000800) == 0x00000800);
      }
      /**
       * <pre>
       * The current state of the tablet's data.
       * </pre>
       *
       * <code>optional .kudu.tablet.TabletDataState tablet_data_state = 10 [default = TABLET_DATA_UNKNOWN];</code>
       */
      public org.apache.kudu.tablet.Metadata.TabletDataState getTabletDataState() {
        org.apache.kudu.tablet.Metadata.TabletDataState result = org.apache.kudu.tablet.Metadata.TabletDataState.valueOf(tabletDataState_);
        return result == null ? org.apache.kudu.tablet.Metadata.TabletDataState.TABLET_DATA_UNKNOWN : result;
      }
      /**
       * <pre>
       * The current state of the tablet's data.
       * </pre>
       *
       * <code>optional .kudu.tablet.TabletDataState tablet_data_state = 10 [default = TABLET_DATA_UNKNOWN];</code>
       */
      public Builder setTabletDataState(org.apache.kudu.tablet.Metadata.TabletDataState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000800;
        tabletDataState_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The current state of the tablet's data.
       * </pre>
       *
       * <code>optional .kudu.tablet.TabletDataState tablet_data_state = 10 [default = TABLET_DATA_UNKNOWN];</code>
       */
      public Builder clearTabletDataState() {
        bitField0_ = (bitField0_ & ~0x00000800);
        tabletDataState_ = 999;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.kudu.Fs.BlockIdPB> orphanedBlocks_ =
        java.util.Collections.emptyList();
      private void ensureOrphanedBlocksIsMutable() {
        if (!((bitField0_ & 0x00001000) == 0x00001000)) {
          orphanedBlocks_ = new java.util.ArrayList<org.apache.kudu.Fs.BlockIdPB>(orphanedBlocks_);
          bitField0_ |= 0x00001000;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> orphanedBlocksBuilder_;

      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public java.util.List<org.apache.kudu.Fs.BlockIdPB> getOrphanedBlocksList() {
        if (orphanedBlocksBuilder_ == null) {
          return java.util.Collections.unmodifiableList(orphanedBlocks_);
        } else {
          return orphanedBlocksBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public int getOrphanedBlocksCount() {
        if (orphanedBlocksBuilder_ == null) {
          return orphanedBlocks_.size();
        } else {
          return orphanedBlocksBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB getOrphanedBlocks(int index) {
        if (orphanedBlocksBuilder_ == null) {
          return orphanedBlocks_.get(index);
        } else {
          return orphanedBlocksBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public Builder setOrphanedBlocks(
          int index, org.apache.kudu.Fs.BlockIdPB value) {
        if (orphanedBlocksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrphanedBlocksIsMutable();
          orphanedBlocks_.set(index, value);
          onChanged();
        } else {
          orphanedBlocksBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public Builder setOrphanedBlocks(
          int index, org.apache.kudu.Fs.BlockIdPB.Builder builderForValue) {
        if (orphanedBlocksBuilder_ == null) {
          ensureOrphanedBlocksIsMutable();
          orphanedBlocks_.set(index, builderForValue.build());
          onChanged();
        } else {
          orphanedBlocksBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public Builder addOrphanedBlocks(org.apache.kudu.Fs.BlockIdPB value) {
        if (orphanedBlocksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrphanedBlocksIsMutable();
          orphanedBlocks_.add(value);
          onChanged();
        } else {
          orphanedBlocksBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public Builder addOrphanedBlocks(
          int index, org.apache.kudu.Fs.BlockIdPB value) {
        if (orphanedBlocksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOrphanedBlocksIsMutable();
          orphanedBlocks_.add(index, value);
          onChanged();
        } else {
          orphanedBlocksBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public Builder addOrphanedBlocks(
          org.apache.kudu.Fs.BlockIdPB.Builder builderForValue) {
        if (orphanedBlocksBuilder_ == null) {
          ensureOrphanedBlocksIsMutable();
          orphanedBlocks_.add(builderForValue.build());
          onChanged();
        } else {
          orphanedBlocksBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public Builder addOrphanedBlocks(
          int index, org.apache.kudu.Fs.BlockIdPB.Builder builderForValue) {
        if (orphanedBlocksBuilder_ == null) {
          ensureOrphanedBlocksIsMutable();
          orphanedBlocks_.add(index, builderForValue.build());
          onChanged();
        } else {
          orphanedBlocksBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public Builder addAllOrphanedBlocks(
          java.lang.Iterable<? extends org.apache.kudu.Fs.BlockIdPB> values) {
        if (orphanedBlocksBuilder_ == null) {
          ensureOrphanedBlocksIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, orphanedBlocks_);
          onChanged();
        } else {
          orphanedBlocksBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public Builder clearOrphanedBlocks() {
        if (orphanedBlocksBuilder_ == null) {
          orphanedBlocks_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00001000);
          onChanged();
        } else {
          orphanedBlocksBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public Builder removeOrphanedBlocks(int index) {
        if (orphanedBlocksBuilder_ == null) {
          ensureOrphanedBlocksIsMutable();
          orphanedBlocks_.remove(index);
          onChanged();
        } else {
          orphanedBlocksBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB.Builder getOrphanedBlocksBuilder(
          int index) {
        return getOrphanedBlocksFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public org.apache.kudu.Fs.BlockIdPBOrBuilder getOrphanedBlocksOrBuilder(
          int index) {
        if (orphanedBlocksBuilder_ == null) {
          return orphanedBlocks_.get(index);  } else {
          return orphanedBlocksBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public java.util.List<? extends org.apache.kudu.Fs.BlockIdPBOrBuilder> 
           getOrphanedBlocksOrBuilderList() {
        if (orphanedBlocksBuilder_ != null) {
          return orphanedBlocksBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(orphanedBlocks_);
        }
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB.Builder addOrphanedBlocksBuilder() {
        return getOrphanedBlocksFieldBuilder().addBuilder(
            org.apache.kudu.Fs.BlockIdPB.getDefaultInstance());
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public org.apache.kudu.Fs.BlockIdPB.Builder addOrphanedBlocksBuilder(
          int index) {
        return getOrphanedBlocksFieldBuilder().addBuilder(
            index, org.apache.kudu.Fs.BlockIdPB.getDefaultInstance());
      }
      /**
       * <pre>
       * Blocks that became orphans after flushing this superblock. In other
       * words, the set difference of the blocks belonging to the previous
       * superblock and this one.
       * It's always safe to delete the blocks found here.
       * </pre>
       *
       * <code>repeated .kudu.BlockIdPB orphaned_blocks = 11;</code>
       */
      public java.util.List<org.apache.kudu.Fs.BlockIdPB.Builder> 
           getOrphanedBlocksBuilderList() {
        return getOrphanedBlocksFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder> 
          getOrphanedBlocksFieldBuilder() {
        if (orphanedBlocksBuilder_ == null) {
          orphanedBlocksBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.apache.kudu.Fs.BlockIdPB, org.apache.kudu.Fs.BlockIdPB.Builder, org.apache.kudu.Fs.BlockIdPBOrBuilder>(
                  orphanedBlocks_,
                  ((bitField0_ & 0x00001000) == 0x00001000),
                  getParentForChildren(),
                  isClean());
          orphanedBlocks_ = null;
        }
        return orphanedBlocksBuilder_;
      }

      private org.apache.kudu.consensus.Opid.OpId tombstoneLastLoggedOpid_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.consensus.Opid.OpId, org.apache.kudu.consensus.Opid.OpId.Builder, org.apache.kudu.consensus.Opid.OpIdOrBuilder> tombstoneLastLoggedOpidBuilder_;
      /**
       * <pre>
       * For tablets that have been tombstoned, stores the last OpId stored in the
       * WAL before tombstoning.
       * Only relevant for TOMBSTONED tablets.
       * </pre>
       *
       * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
       */
      public boolean hasTombstoneLastLoggedOpid() {
        return ((bitField0_ & 0x00002000) == 0x00002000);
      }
      /**
       * <pre>
       * For tablets that have been tombstoned, stores the last OpId stored in the
       * WAL before tombstoning.
       * Only relevant for TOMBSTONED tablets.
       * </pre>
       *
       * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
       */
      public org.apache.kudu.consensus.Opid.OpId getTombstoneLastLoggedOpid() {
        if (tombstoneLastLoggedOpidBuilder_ == null) {
          return tombstoneLastLoggedOpid_ == null ? org.apache.kudu.consensus.Opid.OpId.getDefaultInstance() : tombstoneLastLoggedOpid_;
        } else {
          return tombstoneLastLoggedOpidBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * For tablets that have been tombstoned, stores the last OpId stored in the
       * WAL before tombstoning.
       * Only relevant for TOMBSTONED tablets.
       * </pre>
       *
       * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
       */
      public Builder setTombstoneLastLoggedOpid(org.apache.kudu.consensus.Opid.OpId value) {
        if (tombstoneLastLoggedOpidBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tombstoneLastLoggedOpid_ = value;
          onChanged();
        } else {
          tombstoneLastLoggedOpidBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00002000;
        return this;
      }
      /**
       * <pre>
       * For tablets that have been tombstoned, stores the last OpId stored in the
       * WAL before tombstoning.
       * Only relevant for TOMBSTONED tablets.
       * </pre>
       *
       * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
       */
      public Builder setTombstoneLastLoggedOpid(
          org.apache.kudu.consensus.Opid.OpId.Builder builderForValue) {
        if (tombstoneLastLoggedOpidBuilder_ == null) {
          tombstoneLastLoggedOpid_ = builderForValue.build();
          onChanged();
        } else {
          tombstoneLastLoggedOpidBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00002000;
        return this;
      }
      /**
       * <pre>
       * For tablets that have been tombstoned, stores the last OpId stored in the
       * WAL before tombstoning.
       * Only relevant for TOMBSTONED tablets.
       * </pre>
       *
       * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
       */
      public Builder mergeTombstoneLastLoggedOpid(org.apache.kudu.consensus.Opid.OpId value) {
        if (tombstoneLastLoggedOpidBuilder_ == null) {
          if (((bitField0_ & 0x00002000) == 0x00002000) &&
              tombstoneLastLoggedOpid_ != null &&
              tombstoneLastLoggedOpid_ != org.apache.kudu.consensus.Opid.OpId.getDefaultInstance()) {
            tombstoneLastLoggedOpid_ =
              org.apache.kudu.consensus.Opid.OpId.newBuilder(tombstoneLastLoggedOpid_).mergeFrom(value).buildPartial();
          } else {
            tombstoneLastLoggedOpid_ = value;
          }
          onChanged();
        } else {
          tombstoneLastLoggedOpidBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00002000;
        return this;
      }
      /**
       * <pre>
       * For tablets that have been tombstoned, stores the last OpId stored in the
       * WAL before tombstoning.
       * Only relevant for TOMBSTONED tablets.
       * </pre>
       *
       * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
       */
      public Builder clearTombstoneLastLoggedOpid() {
        if (tombstoneLastLoggedOpidBuilder_ == null) {
          tombstoneLastLoggedOpid_ = null;
          onChanged();
        } else {
          tombstoneLastLoggedOpidBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00002000);
        return this;
      }
      /**
       * <pre>
       * For tablets that have been tombstoned, stores the last OpId stored in the
       * WAL before tombstoning.
       * Only relevant for TOMBSTONED tablets.
       * </pre>
       *
       * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
       */
      public org.apache.kudu.consensus.Opid.OpId.Builder getTombstoneLastLoggedOpidBuilder() {
        bitField0_ |= 0x00002000;
        onChanged();
        return getTombstoneLastLoggedOpidFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * For tablets that have been tombstoned, stores the last OpId stored in the
       * WAL before tombstoning.
       * Only relevant for TOMBSTONED tablets.
       * </pre>
       *
       * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
       */
      public org.apache.kudu.consensus.Opid.OpIdOrBuilder getTombstoneLastLoggedOpidOrBuilder() {
        if (tombstoneLastLoggedOpidBuilder_ != null) {
          return tombstoneLastLoggedOpidBuilder_.getMessageOrBuilder();
        } else {
          return tombstoneLastLoggedOpid_ == null ?
              org.apache.kudu.consensus.Opid.OpId.getDefaultInstance() : tombstoneLastLoggedOpid_;
        }
      }
      /**
       * <pre>
       * For tablets that have been tombstoned, stores the last OpId stored in the
       * WAL before tombstoning.
       * Only relevant for TOMBSTONED tablets.
       * </pre>
       *
       * <code>optional .kudu.consensus.OpId tombstone_last_logged_opid = 12;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.consensus.Opid.OpId, org.apache.kudu.consensus.Opid.OpId.Builder, org.apache.kudu.consensus.Opid.OpIdOrBuilder> 
          getTombstoneLastLoggedOpidFieldBuilder() {
        if (tombstoneLastLoggedOpidBuilder_ == null) {
          tombstoneLastLoggedOpidBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.kudu.consensus.Opid.OpId, org.apache.kudu.consensus.Opid.OpId.Builder, org.apache.kudu.consensus.Opid.OpIdOrBuilder>(
                  getTombstoneLastLoggedOpid(),
                  getParentForChildren(),
                  isClean());
          tombstoneLastLoggedOpid_ = null;
        }
        return tombstoneLastLoggedOpidBuilder_;
      }

      private org.apache.kudu.Fs.DataDirGroupPB dataDirGroup_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.DataDirGroupPB, org.apache.kudu.Fs.DataDirGroupPB.Builder, org.apache.kudu.Fs.DataDirGroupPBOrBuilder> dataDirGroupBuilder_;
      /**
       * <pre>
       * Tablet data is spread across a data directory group. If this is not set
       * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
       * from a version of Kudu before 1.5.0. In this case, a new group will be
       * created spanning all data directories.
       * </pre>
       *
       * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
       */
      public boolean hasDataDirGroup() {
        return ((bitField0_ & 0x00004000) == 0x00004000);
      }
      /**
       * <pre>
       * Tablet data is spread across a data directory group. If this is not set
       * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
       * from a version of Kudu before 1.5.0. In this case, a new group will be
       * created spanning all data directories.
       * </pre>
       *
       * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
       */
      public org.apache.kudu.Fs.DataDirGroupPB getDataDirGroup() {
        if (dataDirGroupBuilder_ == null) {
          return dataDirGroup_ == null ? org.apache.kudu.Fs.DataDirGroupPB.getDefaultInstance() : dataDirGroup_;
        } else {
          return dataDirGroupBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Tablet data is spread across a data directory group. If this is not set
       * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
       * from a version of Kudu before 1.5.0. In this case, a new group will be
       * created spanning all data directories.
       * </pre>
       *
       * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
       */
      public Builder setDataDirGroup(org.apache.kudu.Fs.DataDirGroupPB value) {
        if (dataDirGroupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataDirGroup_ = value;
          onChanged();
        } else {
          dataDirGroupBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00004000;
        return this;
      }
      /**
       * <pre>
       * Tablet data is spread across a data directory group. If this is not set
       * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
       * from a version of Kudu before 1.5.0. In this case, a new group will be
       * created spanning all data directories.
       * </pre>
       *
       * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
       */
      public Builder setDataDirGroup(
          org.apache.kudu.Fs.DataDirGroupPB.Builder builderForValue) {
        if (dataDirGroupBuilder_ == null) {
          dataDirGroup_ = builderForValue.build();
          onChanged();
        } else {
          dataDirGroupBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00004000;
        return this;
      }
      /**
       * <pre>
       * Tablet data is spread across a data directory group. If this is not set
       * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
       * from a version of Kudu before 1.5.0. In this case, a new group will be
       * created spanning all data directories.
       * </pre>
       *
       * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
       */
      public Builder mergeDataDirGroup(org.apache.kudu.Fs.DataDirGroupPB value) {
        if (dataDirGroupBuilder_ == null) {
          if (((bitField0_ & 0x00004000) == 0x00004000) &&
              dataDirGroup_ != null &&
              dataDirGroup_ != org.apache.kudu.Fs.DataDirGroupPB.getDefaultInstance()) {
            dataDirGroup_ =
              org.apache.kudu.Fs.DataDirGroupPB.newBuilder(dataDirGroup_).mergeFrom(value).buildPartial();
          } else {
            dataDirGroup_ = value;
          }
          onChanged();
        } else {
          dataDirGroupBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00004000;
        return this;
      }
      /**
       * <pre>
       * Tablet data is spread across a data directory group. If this is not set
       * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
       * from a version of Kudu before 1.5.0. In this case, a new group will be
       * created spanning all data directories.
       * </pre>
       *
       * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
       */
      public Builder clearDataDirGroup() {
        if (dataDirGroupBuilder_ == null) {
          dataDirGroup_ = null;
          onChanged();
        } else {
          dataDirGroupBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00004000);
        return this;
      }
      /**
       * <pre>
       * Tablet data is spread across a data directory group. If this is not set
       * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
       * from a version of Kudu before 1.5.0. In this case, a new group will be
       * created spanning all data directories.
       * </pre>
       *
       * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
       */
      public org.apache.kudu.Fs.DataDirGroupPB.Builder getDataDirGroupBuilder() {
        bitField0_ |= 0x00004000;
        onChanged();
        return getDataDirGroupFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Tablet data is spread across a data directory group. If this is not set
       * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
       * from a version of Kudu before 1.5.0. In this case, a new group will be
       * created spanning all data directories.
       * </pre>
       *
       * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
       */
      public org.apache.kudu.Fs.DataDirGroupPBOrBuilder getDataDirGroupOrBuilder() {
        if (dataDirGroupBuilder_ != null) {
          return dataDirGroupBuilder_.getMessageOrBuilder();
        } else {
          return dataDirGroup_ == null ?
              org.apache.kudu.Fs.DataDirGroupPB.getDefaultInstance() : dataDirGroup_;
        }
      }
      /**
       * <pre>
       * Tablet data is spread across a data directory group. If this is not set
       * and the tablet state is TABLET_DATA_READY, it is assumed that the data is
       * from a version of Kudu before 1.5.0. In this case, a new group will be
       * created spanning all data directories.
       * </pre>
       *
       * <code>optional .kudu.DataDirGroupPB data_dir_group = 15;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.apache.kudu.Fs.DataDirGroupPB, org.apache.kudu.Fs.DataDirGroupPB.Builder, org.apache.kudu.Fs.DataDirGroupPBOrBuilder> 
          getDataDirGroupFieldBuilder() {
        if (dataDirGroupBuilder_ == null) {
          dataDirGroupBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.apache.kudu.Fs.DataDirGroupPB, org.apache.kudu.Fs.DataDirGroupPB.Builder, org.apache.kudu.Fs.DataDirGroupPBOrBuilder>(
                  getDataDirGroup(),
                  getParentForChildren(),
                  isClean());
          dataDirGroup_ = null;
        }
        return dataDirGroupBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:kudu.tablet.TabletSuperBlockPB)
    }

    // @@protoc_insertion_point(class_scope:kudu.tablet.TabletSuperBlockPB)
    private static final org.apache.kudu.tablet.Metadata.TabletSuperBlockPB DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.kudu.tablet.Metadata.TabletSuperBlockPB();
    }

    public static org.apache.kudu.tablet.Metadata.TabletSuperBlockPB getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<TabletSuperBlockPB>
        PARSER = new com.google.protobuf.AbstractParser<TabletSuperBlockPB>() {
      public TabletSuperBlockPB parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
          return new TabletSuperBlockPB(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<TabletSuperBlockPB> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TabletSuperBlockPB> getParserForType() {
      return PARSER;
    }

    public org.apache.kudu.tablet.Metadata.TabletSuperBlockPB getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_kudu_tablet_ColumnDataPB_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_kudu_tablet_ColumnDataPB_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_kudu_tablet_DeltaDataPB_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_kudu_tablet_DeltaDataPB_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_kudu_tablet_RowSetDataPB_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_kudu_tablet_RowSetDataPB_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_kudu_tablet_TabletSuperBlockPB_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_kudu_tablet_TabletSuperBlockPB_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\032kudu/tablet/metadata.proto\022\013kudu.table" +
      "t\032\030kudu/common/common.proto\032\031kudu/consen" +
      "sus/opid.proto\032\020kudu/fs/fs.proto\"A\n\014Colu" +
      "mnDataPB\022\036\n\005block\030\002 \002(\0132\017.kudu.BlockIdPB" +
      "\022\021\n\tcolumn_id\030\004 \001(\005\"-\n\013DeltaDataPB\022\036\n\005bl" +
      "ock\030\002 \002(\0132\017.kudu.BlockIdPB\"\223\002\n\014RowSetDat" +
      "aPB\022\n\n\002id\030\001 \002(\004\022\033\n\023last_durable_dms_id\030\002" +
      " \002(\003\022*\n\007columns\030\003 \003(\0132\031.kudu.tablet.Colu" +
      "mnDataPB\022-\n\013redo_deltas\030\004 \003(\0132\030.kudu.tab" +
      "let.DeltaDataPB\022-\n\013undo_deltas\030\005 \003(\0132\030.k",
      "udu.tablet.DeltaDataPB\022$\n\013bloom_block\030\006 " +
      "\001(\0132\017.kudu.BlockIdPB\022*\n\021adhoc_index_bloc" +
      "k\030\007 \001(\0132\017.kudu.BlockIdPB\"\253\004\n\022TabletSuper" +
      "BlockPB\022\020\n\010table_id\030\001 \002(\014\022\021\n\ttablet_id\030\002" +
      " \002(\014\022\033\n\023last_durable_mrs_id\030\003 \002(\003\022\021\n\tsta" +
      "rt_key\030\004 \001(\014\022\017\n\007end_key\030\005 \001(\014\022$\n\tpartiti" +
      "on\030\r \001(\0132\021.kudu.PartitionPB\022*\n\007rowsets\030\006" +
      " \003(\0132\031.kudu.tablet.RowSetDataPB\022\022\n\ntable" +
      "_name\030\007 \002(\t\022\036\n\006schema\030\010 \002(\0132\016.kudu.Schem" +
      "aPB\022\026\n\016schema_version\030\t \002(\r\0221\n\020partition",
      "_schema\030\016 \001(\0132\027.kudu.PartitionSchemaPB\022L" +
      "\n\021tablet_data_state\030\n \001(\0162\034.kudu.tablet." +
      "TabletDataState:\023TABLET_DATA_UNKNOWN\022(\n\017" +
      "orphaned_blocks\030\013 \003(\0132\017.kudu.BlockIdPB\0228" +
      "\n\032tombstone_last_logged_opid\030\014 \001(\0132\024.kud" +
      "u.consensus.OpId\022,\n\016data_dir_group\030\017 \001(\013" +
      "2\024.kudu.DataDirGroupPB*\220\001\n\017TabletDataSta" +
      "te\022\030\n\023TABLET_DATA_UNKNOWN\020\347\007\022\027\n\023TABLET_D" +
      "ATA_COPYING\020\000\022\025\n\021TABLET_DATA_READY\020\001\022\027\n\023" +
      "TABLET_DATA_DELETED\020\002\022\032\n\026TABLET_DATA_TOM",
      "BSTONED\020\003*\230\001\n\rTabletStatePB\022\014\n\007UNKNOWN\020\347" +
      "\007\022\023\n\017NOT_INITIALIZED\020\006\022\017\n\013INITIALIZED\020\005\022" +
      "\021\n\rBOOTSTRAPPING\020\000\022\013\n\007RUNNING\020\001\022\n\n\006FAILE" +
      "D\020\002\022\014\n\010STOPPING\020\003\022\013\n\007STOPPED\020\007\022\014\n\010SHUTDO" +
      "WN\020\004B\030\n\026org.apache.kudu.tablet"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          org.apache.kudu.Common.getDescriptor(),
          org.apache.kudu.consensus.Opid.getDescriptor(),
          org.apache.kudu.Fs.getDescriptor(),
        }, assigner);
    internal_static_kudu_tablet_ColumnDataPB_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_kudu_tablet_ColumnDataPB_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_kudu_tablet_ColumnDataPB_descriptor,
        new java.lang.String[] { "Block", "ColumnId", });
    internal_static_kudu_tablet_DeltaDataPB_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_kudu_tablet_DeltaDataPB_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_kudu_tablet_DeltaDataPB_descriptor,
        new java.lang.String[] { "Block", });
    internal_static_kudu_tablet_RowSetDataPB_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_kudu_tablet_RowSetDataPB_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_kudu_tablet_RowSetDataPB_descriptor,
        new java.lang.String[] { "Id", "LastDurableDmsId", "Columns", "RedoDeltas", "UndoDeltas", "BloomBlock", "AdhocIndexBlock", });
    internal_static_kudu_tablet_TabletSuperBlockPB_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_kudu_tablet_TabletSuperBlockPB_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_kudu_tablet_TabletSuperBlockPB_descriptor,
        new java.lang.String[] { "TableId", "TabletId", "LastDurableMrsId", "StartKey", "EndKey", "Partition", "Rowsets", "TableName", "Schema", "SchemaVersion", "PartitionSchema", "TabletDataState", "OrphanedBlocks", "TombstoneLastLoggedOpid", "DataDirGroup", });
    org.apache.kudu.Common.getDescriptor();
    org.apache.kudu.consensus.Opid.getDescriptor();
    org.apache.kudu.Fs.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
