/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.List;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.client.Status;
import org.apache.kudu.shaded.com.google.common.base.MoreObjects;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RpcTraceFrame {
    private final String rpcMethod;
    private final Action action;
    private final ServerInfo serverInfo;
    private final long timestampMs;
    private final Status callStatus;

    private RpcTraceFrame(String rpcMethod, Action action, ServerInfo serverInfo, Status callStatus) {
        this.rpcMethod = rpcMethod;
        this.action = action;
        this.serverInfo = serverInfo;
        this.callStatus = callStatus;
        this.timestampMs = System.currentTimeMillis();
    }

    public String getRpcMethod() {
        return this.rpcMethod;
    }

    Action getAction() {
        return this.action;
    }

    ServerInfo getServer() {
        return this.serverInfo;
    }

    long getTimestampMs() {
        return this.timestampMs;
    }

    public Status getStatus() {
        return this.callStatus;
    }

    public static String getHumanReadableStringForTraces(List<RpcTraceFrame> traces) {
        if (traces.isEmpty()) {
            return "No traces";
        }
        RpcTraceFrame firstTrace = traces.get(0);
        String rootMethod = firstTrace.getRpcMethod();
        long baseTimestamp = firstTrace.getTimestampMs();
        StringBuilder sb = new StringBuilder("Traces: ");
        for (int i = 0; i < traces.size(); ++i) {
            RpcTraceFrame trace = traces.get(i);
            sb.append('[');
            sb.append(trace.getTimestampMs() - baseTimestamp);
            sb.append("ms] ");
            if (!rootMethod.equals(trace.getRpcMethod())) {
                sb.append("Sub rpc: ");
                sb.append(trace.getRpcMethod());
                sb.append(" ");
            }
            trace.getAction().appendToStringBuilder(trace, sb);
            if (i >= traces.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("rpcMethod", this.rpcMethod).add("timestampMs", this.timestampMs).add("action", (Object)this.action).add("serverInfo", this.serverInfo).add("callStatus", this.callStatus).toString();
    }

    static class RpcTraceFrameBuilder {
        private final String rpcMethod;
        private final Action action;
        private ServerInfo serverInfo;
        private Status callStatus;

        RpcTraceFrameBuilder(String rpcMethod, Action action) {
            this.rpcMethod = rpcMethod;
            this.action = action;
        }

        public RpcTraceFrameBuilder serverInfo(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            return this;
        }

        public RpcTraceFrameBuilder callStatus(Status callStatus) {
            this.callStatus = callStatus;
            return this;
        }

        public RpcTraceFrame build() {
            return new RpcTraceFrame(this.rpcMethod, this.action, this.serverInfo, this.callStatus);
        }
    }

    static enum Action {
        SEND_TO_SERVER{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append("sending RPC to server ");
                sb.append(trace.getServer().getUuid());
            }
        }
        ,
        RECEIVE_FROM_SERVER{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append("received from server ");
                sb.append(trace.getServer().getUuid());
                sb.append(" response ");
                sb.append(trace.getStatus());
            }
        }
        ,
        SLEEP_THEN_RETRY{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append("delaying RPC due to ");
                sb.append(trace.getStatus());
            }
        }
        ,
        GET_NEW_AUTHENTICATION_TOKEN_THEN_RETRY{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append("waiting for new authn token");
            }
        }
        ,
        QUERY_MASTER{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append("querying master");
            }
        }
        ,
        TRACE_TRUNCATED{

            @Override
            void appendToStringBuilder(RpcTraceFrame trace, StringBuilder sb) {
                sb.append("trace too long, truncated");
            }
        };


        abstract void appendToStringBuilder(RpcTraceFrame var1, StringBuilder var2);
    }
}

