/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.util.NetUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ServerInfo {
    private final String uuid;
    private final HostAndPort hostPort;
    private final InetSocketAddress resolvedAddr;
    private final boolean local;
    private static final ConcurrentHashMap<InetAddress, Boolean> isLocalAddressCache = new ConcurrentHashMap();

    public ServerInfo(String uuid, HostAndPort hostPort, InetAddress resolvedAddr) {
        Preconditions.checkNotNull(uuid);
        Preconditions.checkArgument(hostPort.getPort() > 0);
        this.uuid = uuid;
        this.hostPort = hostPort;
        this.resolvedAddr = new InetSocketAddress(resolvedAddr, hostPort.getPort());
        Boolean isLocal = isLocalAddressCache.get(resolvedAddr);
        if (isLocal == null) {
            isLocal = NetUtil.isLocalAddress(resolvedAddr);
            isLocalAddressCache.put(resolvedAddr, isLocal);
        }
        this.local = isLocal;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getAndCanonicalizeHostname() {
        try {
            return InetAddress.getByName(this.hostPort.getHost()).getCanonicalHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            return this.hostPort.getHost();
        }
    }

    public int getPort() {
        return this.hostPort.getPort();
    }

    public boolean isLocal() {
        return this.local;
    }

    public InetSocketAddress getResolvedAddress() {
        return this.resolvedAddr;
    }

    public String toString() {
        return this.uuid + "(" + this.hostPort + ")";
    }
}

