/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.org.jboss.netty.handler.execution;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelEvent;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelState;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.kudu.shaded.org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.apache.kudu.shaded.org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.apache.kudu.shaded.org.jboss.netty.util.ObjectSizeEstimator;
import org.apache.kudu.shaded.org.jboss.netty.util.internal.ConcurrentIdentityWeakKeyHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FairOrderedMemoryAwareThreadPoolExecutor
extends MemoryAwareThreadPoolExecutor {
    private final EventTask end = new EventTask(null);
    private final AtomicReferenceFieldUpdater<EventTask, EventTask> fieldUpdater = AtomicReferenceFieldUpdater.newUpdater(EventTask.class, EventTask.class, "next");
    protected final ConcurrentMap<Object, EventTask> map = this.newMap();

    public FairOrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize);
    }

    public FairOrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit);
    }

    public FairOrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, threadFactory);
    }

    public FairOrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ObjectSizeEstimator objectSizeEstimator, ThreadFactory threadFactory) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, objectSizeEstimator, threadFactory);
    }

    protected ConcurrentMap<Object, EventTask> newMap() {
        return new ConcurrentIdentityWeakKeyHashMap<Object, EventTask>();
    }

    @Override
    protected void doExecute(Runnable task) {
        if (task instanceof ChannelEventRunnable) {
            ChannelEventRunnable eventRunnable = (ChannelEventRunnable)task;
            EventTask newEventTask = new EventTask(eventRunnable);
            Object key = this.getKey(eventRunnable.getEvent());
            EventTask previousEventTask = this.map.put(key, newEventTask);
            this.removeIfClosed(eventRunnable, key);
            if (previousEventTask != null && this.compareAndSetNext(previousEventTask, null, newEventTask)) {
                return;
            }
            this.doUnorderedExecute(newEventTask);
        } else {
            this.doUnorderedExecute(task);
        }
    }

    private void removeIfClosed(ChannelEventRunnable eventRunnable, Object key) {
        ChannelStateEvent se;
        ChannelEvent event = eventRunnable.getEvent();
        if (event instanceof ChannelStateEvent && (se = (ChannelStateEvent)event).getState() == ChannelState.OPEN && !event.getChannel().isOpen()) {
            this.removeKey(key);
        }
    }

    protected boolean removeKey(Object key) {
        return this.map.remove(key) != null;
    }

    protected Object getKey(ChannelEvent e) {
        return e.getChannel();
    }

    @Override
    protected boolean shouldCount(Runnable task) {
        return !(task instanceof EventTask) && super.shouldCount(task);
    }

    protected final boolean compareAndSetNext(EventTask eventTask, EventTask expect, EventTask update) {
        return this.fieldUpdater.compareAndSet(eventTask, expect, update);
    }

    protected final class EventTask
    implements Runnable {
        volatile EventTask next;
        private final ChannelEventRunnable runnable;

        EventTask(ChannelEventRunnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                this.runnable.run();
                Object var2_1 = null;
                if (FairOrderedMemoryAwareThreadPoolExecutor.this.compareAndSetNext(this, null, FairOrderedMemoryAwareThreadPoolExecutor.this.end)) return;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (FairOrderedMemoryAwareThreadPoolExecutor.this.compareAndSetNext(this, null, FairOrderedMemoryAwareThreadPoolExecutor.this.end)) throw throwable;
                FairOrderedMemoryAwareThreadPoolExecutor.this.doUnorderedExecute(this.next);
                throw throwable;
            }
            FairOrderedMemoryAwareThreadPoolExecutor.this.doUnorderedExecute(this.next);
        }
    }
}

