/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.kudu;

import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.spark.kudu.KuduClientCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;

public final class KuduClientCache$ {
    public static final KuduClientCache$ MODULE$;
    private final Logger log;
    private final int ShutdownHookPriority;
    private final HashMap<String, KuduClientCache.CacheValue> clientCache;

    static {
        new KuduClientCache$();
    }

    public Logger log() {
        return this.log;
    }

    private int ShutdownHookPriority() {
        return this.ShutdownHookPriority;
    }

    private HashMap<String, KuduClientCache.CacheValue> clientCache() {
        return this.clientCache;
    }

    public void clearCacheForTests() {
        this.clientCache().values().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KuduClientCache.CacheValue x0$2) {
                KuduClientCache.CacheValue cacheValue = x0$2;
                try {
                    cacheValue.kuduClient().close();
                }
                catch (Exception exception) {
                    KuduClientCache$.MODULE$.log().warn("Error while shutting down the test client", exception);
                }
                boolean bl = ShutdownHookManager.get().removeShutdownHook(cacheValue.shutdownHookHandle());
                return bl;
            }
        });
        this.clientCache().clear();
    }

    public AsyncKuduClient getAsyncClient(String kuduMaster) {
        HashMap<String, KuduClientCache.CacheValue> hashMap = this.clientCache();
        synchronized (hashMap) {
            BoxedUnit boxedUnit;
            if (this.clientCache().contains((Object)kuduMaster)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                AsyncKuduClient asyncClient = new AsyncKuduClient.AsyncKuduClientBuilder(kuduMaster).build();
                Runnable hookHandle = new Runnable(asyncClient){
                    private final AsyncKuduClient asyncClient$1;

                    public void run() {
                        this.asyncClient$1.close();
                    }
                    {
                        this.asyncClient$1 = asyncClient$1;
                    }
                };
                ShutdownHookManager.get().addShutdownHook(hookHandle, this.ShutdownHookPriority());
                KuduClientCache.CacheValue cacheValue = new KuduClientCache.CacheValue(asyncClient, hookHandle);
                boxedUnit = this.clientCache().put((Object)kuduMaster, (Object)cacheValue);
            }
            return ((KuduClientCache.CacheValue)this.clientCache().apply((Object)kuduMaster)).kuduClient();
        }
    }

    private KuduClientCache$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.ShutdownHookPriority = 100;
        this.clientCache = new HashMap();
    }
}

