/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.util.Slice;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Slices {
    public static final Slice EMPTY_SLICE = new Slice(0);
    private static final ThreadLocal<Map<Charset, CharsetEncoder>> encoders = new ThreadLocal<Map<Charset, CharsetEncoder>>(){

        @Override
        protected Map<Charset, CharsetEncoder> initialValue() {
            return new IdentityHashMap<Charset, CharsetEncoder>();
        }
    };
    private static final ThreadLocal<Map<Charset, CharsetDecoder>> decoders = new ThreadLocal<Map<Charset, CharsetDecoder>>(){

        @Override
        protected Map<Charset, CharsetDecoder> initialValue() {
            return new IdentityHashMap<Charset, CharsetDecoder>();
        }
    };

    private Slices() {
    }

    public static Slice ensureSize(Slice existingSlice, int minWritableBytes) {
        int newCapacity;
        if (existingSlice == null) {
            existingSlice = EMPTY_SLICE;
        }
        if (minWritableBytes <= existingSlice.length()) {
            return existingSlice;
        }
        int minNewCapacity = existingSlice.length() + minWritableBytes;
        for (newCapacity = existingSlice.length() == 0 ? 1 : existingSlice.length(); newCapacity < minNewCapacity; newCapacity <<= 1) {
        }
        Slice newSlice = Slices.allocate(newCapacity);
        newSlice.setBytes(0, existingSlice, 0, existingSlice.length());
        return newSlice;
    }

    public static Slice allocate(int capacity) {
        if (capacity == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(capacity);
    }

    public static Slice wrappedBuffer(byte[] array) {
        if (array.length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array);
    }

    public static Slice copiedBuffer(ByteBuffer source, int sourceOffset, int length) {
        Preconditions.checkNotNull(source, "source is null");
        int newPosition = source.position() + sourceOffset;
        return Slices.copiedBuffer((ByteBuffer)source.duplicate().order(ByteOrder.LITTLE_ENDIAN).clear().limit(newPosition + length).position(newPosition));
    }

    public static Slice copiedBuffer(ByteBuffer source) {
        Preconditions.checkNotNull(source, "source is null");
        Slice copy2 = Slices.allocate(source.limit() - source.position());
        copy2.setBytes(0, source.duplicate().order(ByteOrder.LITTLE_ENDIAN));
        return copy2;
    }

    public static Slice copiedBuffer(String string, Charset charset) {
        Preconditions.checkNotNull(string, "string is null");
        Preconditions.checkNotNull(charset, "charset is null");
        return Slices.wrappedBuffer(string.getBytes(charset));
    }

    public static ByteBuffer encodeString(CharBuffer src, Charset charset) {
        CharsetEncoder encoder = Slices.getEncoder(charset);
        ByteBuffer dst = ByteBuffer.allocate((int)((double)src.remaining() * (double)encoder.maxBytesPerChar()));
        try {
            CoderResult cr = encoder.encode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = encoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        dst.flip();
        return dst;
    }

    public static String decodeString(ByteBuffer src, Charset charset) {
        CharsetDecoder decoder = Slices.getDecoder(charset);
        CharBuffer dst = CharBuffer.allocate((int)((double)src.remaining() * (double)decoder.maxCharsPerByte()));
        try {
            CoderResult cr = decoder.decode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = decoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        return dst.flip().toString();
    }

    private static CharsetEncoder getEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        Map<Charset, CharsetEncoder> map = encoders.get();
        CharsetEncoder e = map.get(charset);
        if (e != null) {
            e.reset();
            e.onMalformedInput(CodingErrorAction.REPLACE);
            e.onUnmappableCharacter(CodingErrorAction.REPLACE);
            return e;
        }
        e = charset.newEncoder();
        e.onMalformedInput(CodingErrorAction.REPLACE);
        e.onUnmappableCharacter(CodingErrorAction.REPLACE);
        map.put(charset, e);
        return e;
    }

    private static CharsetDecoder getDecoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        Map<Charset, CharsetDecoder> map = decoders.get();
        CharsetDecoder d = map.get(charset);
        if (d != null) {
            d.reset();
            d.onMalformedInput(CodingErrorAction.REPLACE);
            d.onUnmappableCharacter(CodingErrorAction.REPLACE);
            return d;
        }
        d = charset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPLACE);
        d.onUnmappableCharacter(CodingErrorAction.REPLACE);
        map.put(charset, d);
        return d;
    }
}

