/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test.cluster;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.gradle.osdetector.OsDetector;
import org.apache.kudu.test.cluster.KuduBinaryInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class KuduBinaryJarExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(KuduBinaryJarExtractor.class);
    private static final String KUDU_TEST_BIN_PROPS_PATH = "META-INF/apache-kudu-test-binary.properties";
    private static final OsDetector DETECTOR = new OsDetector();

    private static ClassLoader getCurrentClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return loader;
        }
        return KuduBinaryJarExtractor.class.getClassLoader();
    }

    private static Properties getBinaryProps() throws IOException {
        Enumeration<URL> resources = KuduBinaryJarExtractor.getCurrentClassLoader().getResources(KUDU_TEST_BIN_PROPS_PATH);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                Properties props = KuduBinaryJarExtractor.loadBinaryProps(url);
                if (!DETECTOR.getOs().equals(props.getProperty("artifact.os")) || !DETECTOR.getArch().equals(props.getProperty("artifact.arch"))) continue;
                return props;
            }
            catch (IOException ex) {
                LOG.warn("Unable to parse properties file from Kudu binary artifact", (Throwable)ex);
            }
        }
        return null;
    }

    private static Properties loadBinaryProps(URL url) throws IOException {
        Properties props = new Properties();
        props.load(url.openStream());
        return props;
    }

    public boolean isKuduBinaryJarOnClasspath() throws IOException {
        Properties binaryProps = KuduBinaryJarExtractor.getBinaryProps();
        return binaryProps != null;
    }

    public KuduBinaryInfo extractKuduBinaryArtifact(String destDir) throws IOException {
        Properties binaryProps = KuduBinaryJarExtractor.getBinaryProps();
        if (binaryProps == null) {
            throw new FileNotFoundException("Could not locate the Kudu binary test jar");
        }
        String prefix = binaryProps.getProperty("artifact.prefix");
        URL artifactPrefix = KuduBinaryJarExtractor.getCurrentClassLoader().getResource(prefix);
        if (artifactPrefix == null) {
            throw new FileNotFoundException("Cannot find Kudu artifact prefix dir: " + prefix);
        }
        try {
            Path artifactRoot = KuduBinaryJarExtractor.extractJar(artifactPrefix.toURI(), prefix, Paths.get(destDir, new String[0]));
            Path binDir = Paths.get(artifactRoot.toString(), "bin");
            if (!binDir.toFile().exists()) {
                throw new FileNotFoundException("Cannot find Kudu artifact bin dir: " + binDir.toString());
            }
            Path saslDir = Paths.get(artifactRoot.toString(), "lib", "sasl2");
            String saslDirString = null;
            if (saslDir.toFile().exists()) {
                saslDirString = saslDir.toAbsolutePath().toString();
            }
            return new KuduBinaryInfo(binDir.toString(), saslDirString);
        }
        catch (URISyntaxException e) {
            throw new IOException("Cannot unpack Kudu binary jar", e);
        }
    }

    static Path extractJar(URI src, String prefix, final Path target) throws IOException {
        Preconditions.checkArgument("jar".equals(src.getScheme()), "src URI must use a 'jar' scheme");
        if (Files.notExists(target, new LinkOption[0])) {
            Files.createDirectory(target, new FileAttribute[0]);
        }
        HashMap env = new HashMap();
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(src, env);){
            Path root = zipFileSystem.getPath(prefix, new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
                    Path newDir = Paths.get(target.toString(), dir.toString());
                    Files.copy(dir, newDir, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    Path newFile = Paths.get(target.toString(), file.toString());
                    Files.copy(file, newFile, StandardCopyOption.REPLACE_EXISTING);
                    if (file.getParent().endsWith("bin")) {
                        Set<PosixFilePermission> perms = Files.getPosixFilePermissions(newFile, new LinkOption[0]);
                        perms.add(PosixFilePermission.OWNER_EXECUTE);
                        Files.setPosixFilePermissions(newFile, perms);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return Paths.get(target.toString(), prefix).toAbsolutePath();
    }
}

