/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test.junit;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.test.CapturingToFileLogAppender;
import org.apache.kudu.test.junit.ResultReporter;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RetryRule
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(RetryRule.class);
    private static final int DEFAULT_RETRY_COUNT = 0;
    private static final Set<String> FLAKY_TESTS = new HashSet<String>();
    private final int retryCount;
    private final ResultReporter reporter;

    public RetryRule() {
        this(0, false);
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    RetryRule(int retryCount, boolean skipReporting) {
        Preconditions.checkArgument(retryCount >= 0);
        this.retryCount = retryCount;
        this.reporter = skipReporting ? null : new ResultReporter();
    }

    private static boolean retryAllTests() {
        String value = System.getenv("KUDU_RETRY_ALL_FAILED_TESTS");
        return value != null && !value.isEmpty();
    }

    private static boolean retryThisTest(String humanReadableTestName) {
        return FLAKY_TESTS.contains(humanReadableTestName);
    }

    private static int getActualRetryCount() {
        String value = System.getenv("KUDU_FLAKY_TEST_ATTEMPTS");
        if (value == null) {
            return 0;
        }
        try {
            int val = Integer.parseInt(value);
            if (val < 1) {
                throw new NumberFormatException(String.format("expected non-zero positive value, got %d", val));
            }
            return Integer.parseInt(value) - 1;
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse KUDU_FLAKY_TEST_ATTEMPTS, using default value ({})", (Object)0, (Object)e);
            return 0;
        }
    }

    public Statement apply(Statement base, Description description) {
        String humanReadableTestName = description.getClassName() + "." + description.getMethodName();
        boolean retryExplicit = this.retryCount != 0;
        boolean retryAll = RetryRule.retryAllTests();
        boolean retryThis = RetryRule.retryThisTest(humanReadableTestName);
        if (retryExplicit || retryAll || retryThis || this.reporter != null) {
            int actualRetryCount = retryAll || retryThis ? RetryRule.getActualRetryCount() : this.retryCount;
            LOG.info("Creating RetryStatement {} result reporter and retry count of {} ({})", new Object[]{this.reporter != null ? "with" : "without", actualRetryCount, retryExplicit ? "explicit" : (retryAll ? "all tests" : (retryThis ? "this test" : "no retries"))});
            return new RetryStatement(base, actualRetryCount, this.reporter, humanReadableTestName);
        }
        return base;
    }

    static {
        String value = System.getenv("KUDU_FLAKY_TEST_LIST");
        if (value != null) {
            try (BufferedReader br = Files.newBufferedReader(Paths.get(value, new String[0]), StandardCharsets.UTF_8);){
                String l = br.readLine();
                while (l != null) {
                    FLAKY_TESTS.add(l);
                    l = br.readLine();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class RetryStatement
    extends Statement {
        private final Statement base;
        private final int retryCount;
        private final ResultReporter reporter;
        private final String humanReadableTestName;

        RetryStatement(Statement base, int retryCount, ResultReporter reporter, String humanReadableTestName) {
            this.base = base;
            this.retryCount = retryCount;
            this.reporter = reporter;
            this.humanReadableTestName = humanReadableTestName;
        }

        private void report(ResultReporter.Result result, File logFile) {
            this.reporter.tryReportResult(this.humanReadableTestName, result, logFile);
        }

        private boolean wasClockUnsynchronized(File output) {
            ProcessBuilder pb = new ProcessBuilder(ImmutableList.of("zgrep", "-q", "Clock considered unsynchronized", output.getPath()));
            try {
                Process p = pb.start();
                return p.waitFor() == 0;
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private void doOneAttemptAndReport(int attempt) throws Throwable {
            CapturingToFileLogAppender capturer = new CapturingToFileLogAppender(true);
            Throwable throwable = null;
            try {
                try (Closeable c = capturer.attach();){
                    this.base.evaluate();
                }
                this.report(ResultReporter.Result.SUCCESS, null);
            }
            catch (Throwable t) {
                try {
                    try {
                        try (Closeable c = capturer.attach();){
                            LOG.error("{}: failed attempt {}", new Object[]{this.humanReadableTestName, attempt, t});
                        }
                        capturer.finish();
                        File output = capturer.getOutputFile();
                        if (this.wasClockUnsynchronized(output)) {
                            LOG.info("Not reporting test that failed due to NTP issues.");
                        } else {
                            this.report(ResultReporter.Result.FAILURE, output);
                        }
                        throw t;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    RetryStatement.$closeResource(throwable, capturer);
                    throw throwable3;
                }
            }
            RetryStatement.$closeResource(throwable, capturer);
            return;
        }

        private void doOneAttempt(int attempt) throws Throwable {
            try {
                this.base.evaluate();
            }
            catch (Throwable t) {
                LOG.error("{}: failed attempt {}", new Object[]{this.humanReadableTestName, attempt, t});
                throw t;
            }
        }

        public void evaluate() throws Throwable {
            int attempt = 0;
            while (true) {
                ++attempt;
                try {
                    if (this.reporter != null && this.reporter.isReportingEnabled()) {
                        this.doOneAttemptAndReport(attempt);
                    } else {
                        this.doOneAttempt(attempt);
                    }
                    return;
                }
                catch (Throwable t) {
                    Throwable lastException = t;
                    if (attempt <= this.retryCount) continue;
                    LOG.error("{}: giving up after {} attempts", (Object)this.humanReadableTestName, (Object)attempt);
                    throw lastException;
                }
                break;
            }
        }
    }
}

