/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test;

import java.util.Random;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RandomUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RandomUtils.class);
    private static final String TEST_RANDOM_SEED_PROP = "testRandomSeed";

    public static Random getRandom() {
        long seed = System.currentTimeMillis();
        if (System.getProperty(TEST_RANDOM_SEED_PROP) != null) {
            seed = Long.parseLong(System.getProperty(TEST_RANDOM_SEED_PROP));
            LOG.info("System property {} is defined. Overriding random seed: {}", (Object)TEST_RANDOM_SEED_PROP, (Object)seed);
        }
        LOG.info("Using random seed: {}", (Object)seed);
        return new Random(seed);
    }

    public static int nextIntInRange(Random random, int start, int end) {
        Preconditions.checkArgument(start < end, String.format("start must be strictly less than end (%d < %d)", start, end));
        return start + random.nextInt(end - start);
    }
}

