/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.BatchResponse;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.ResourceMetrics;
import org.apache.kudu.client.Statistics;
import org.apache.kudu.security.Token;
import org.apache.kudu.shaded.com.google.common.base.MoreObjects;
import org.apache.kudu.shaded.com.google.common.collect.Iterables;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class Batch
extends KuduRpc<BatchResponse> {
    final List<Operation> operations = new ArrayList<Operation>();
    final List<Integer> operationIndexes = new ArrayList<Integer>();
    private final LocatedTablet tablet;
    private Token.SignedTokenPB authzToken;
    private long rowOperationsSizeBytes = 0L;
    private final EnumSet<WireProtocol.AppStatusPB.ErrorCode> ignoredErrors;
    private final long txnId;
    private static Tserver.TabletServerErrorPB injectedError;
    private static int injectedlatencyMs;

    Batch(KuduTable table, LocatedTablet tablet, boolean ignoreAllDuplicateRows, boolean ignoreAllNotFoundRows, long txnId) {
        super(table, null, 0L);
        HashSet<WireProtocol.AppStatusPB.ErrorCode> ignoredErrors = new HashSet<WireProtocol.AppStatusPB.ErrorCode>();
        if (ignoreAllDuplicateRows) {
            ignoredErrors.add(WireProtocol.AppStatusPB.ErrorCode.ALREADY_PRESENT);
        }
        if (ignoreAllNotFoundRows) {
            ignoredErrors.add(WireProtocol.AppStatusPB.ErrorCode.NOT_FOUND);
        }
        this.ignoredErrors = ignoredErrors.isEmpty() ? EnumSet.noneOf(WireProtocol.AppStatusPB.ErrorCode.class) : EnumSet.copyOf(ignoredErrors);
        this.tablet = tablet;
        this.txnId = txnId;
    }

    void resetTimeoutMillis(Timer timer, long timeoutMillis) {
        this.timeoutTracker.reset();
        this.timeoutTracker.setTimeout(timeoutMillis);
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.timeoutTask = AsyncKuduClient.newTimeout(timer, new KuduRpc.RpcTimeoutTask(this), timeoutMillis);
    }

    long getRowOperationsSizeBytes() {
        if (this.rowOperationsSizeBytes == 0L) {
            throw new IllegalStateException("This row hasn't been serialized yet");
        }
        return this.rowOperationsSizeBytes;
    }

    public void add(Operation operation, int index) {
        assert (Bytes.memcmp(operation.partitionKey(), this.tablet.getPartition().getPartitionKeyStart()) >= 0 && (this.tablet.getPartition().getPartitionKeyEnd().length == 0 || Bytes.memcmp(operation.partitionKey(), this.tablet.getPartition().getPartitionKeyEnd()) < 0));
        this.operations.add(operation);
        this.operationIndexes.add(index);
    }

    @Override
    boolean needsAuthzToken() {
        return true;
    }

    @Override
    void bindAuthzToken(Token.SignedTokenPB token) {
        this.authzToken = token;
    }

    @Override
    Message createRequestPB() {
        Tserver.WriteRequestPB.Builder builder = Operation.createAndFillWriteRequestPB(this.operations);
        this.rowOperationsSizeBytes = (long)builder.getRowOperations().getRows().size() + (long)builder.getRowOperations().getIndirectData().size();
        builder.setTabletId(UnsafeByteOperations.unsafeWrap(this.getTablet().getTabletIdAsBytes()));
        builder.setExternalConsistencyMode(this.externalConsistencyMode.pbVersion());
        if (this.propagatedTimestamp != -1L) {
            builder.setPropagatedTimestamp(this.propagatedTimestamp);
        }
        if (this.authzToken != null) {
            builder.setAuthzToken(this.authzToken);
        }
        if (this.txnId != -1L) {
            builder.setTxnId(this.txnId);
        }
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.tserver.TabletServerService";
    }

    @Override
    String method() {
        return "Write";
    }

    @Override
    Pair<BatchResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Tserver.WriteResponsePB.Builder builder = Tserver.WriteResponsePB.newBuilder();
        Batch.readProtobuf(callResponse.getPBMessage(), builder);
        List<Tserver.WriteResponsePB.PerRowErrorPB> errorsPB = builder.getPerRowErrorsList();
        if (!this.ignoredErrors.isEmpty()) {
            ArrayList<Tserver.WriteResponsePB.PerRowErrorPB> filteredErrors = new ArrayList<Tserver.WriteResponsePB.PerRowErrorPB>();
            for (Tserver.WriteResponsePB.PerRowErrorPB errorPB : errorsPB) {
                if (this.ignoredErrors.contains(errorPB.getError().getCode())) continue;
                filteredErrors.add(errorPB);
            }
            errorsPB = filteredErrors;
        }
        ResourceMetrics metrics = builder.hasResourceMetrics() ? ResourceMetrics.fromResourceMetricsPB(builder.getResourceMetrics()) : null;
        BatchResponse response = new BatchResponse(this.timeoutTracker.getElapsedMillis(), tsUUID, builder.getTimestamp(), errorsPB, this.operations, this.operationIndexes, metrics);
        if (injectedError != null) {
            if (injectedlatencyMs > 0) {
                try {
                    Thread.sleep(injectedlatencyMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return new Pair<BatchResponse, Object>(response, injectedError);
        }
        return new Pair<BatchResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }

    @Override
    public byte[] partitionKey() {
        return this.tablet.getPartition().getPartitionKeyStart();
    }

    @Override
    boolean isRequestTracked() {
        return true;
    }

    @Override
    void updateStatistics(Statistics statistics, BatchResponse response) {
        String tabletId = this.getTablet().getTabletId();
        String tableName = this.getTable().getName();
        Statistics.TabletStatistics tabletStatistics = statistics.getTabletStatistics(tableName, tabletId);
        if (response == null) {
            tabletStatistics.incrementStatistic(Statistics.Statistic.OPS_ERRORS, this.operations.size());
            tabletStatistics.incrementStatistic(Statistics.Statistic.RPC_ERRORS, 1L);
            return;
        }
        tabletStatistics.incrementStatistic(Statistics.Statistic.WRITE_RPCS, 1L);
        for (OperationResponse opResponse : response.getIndividualResponses()) {
            if (opResponse.hasRowError()) {
                tabletStatistics.incrementStatistic(Statistics.Statistic.OPS_ERRORS, 1L);
                continue;
            }
            tabletStatistics.incrementStatistic(Statistics.Statistic.WRITE_OPS, 1L);
        }
        tabletStatistics.incrementStatistic(Statistics.Statistic.BYTES_WRITTEN, this.getRowOperationsSizeBytes());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("operations", this.operations.size()).add("tablet", this.tablet).add("ignoredErrors", Iterables.toString(this.ignoredErrors)).add("rpc", super.toString()).toString();
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    static void injectTabletServerErrorAndLatency(Tserver.TabletServerErrorPB error, int latencyMs) {
        injectedError = error;
        injectedlatencyMs = latencyMs;
    }
}

