/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Collection;
import java.util.List;
import org.apache.kudu.client.BeginTransactionResponse;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.kudu.transactions.TxnManager;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class BeginTransactionRequest
extends KuduRpc<BeginTransactionResponse> {
    private static final List<Integer> featureFlags = ImmutableList.of();

    BeginTransactionRequest(KuduTable masterTable, Timer timer, long timeoutMillis) {
        super(masterTable, timer, timeoutMillis);
    }

    @Override
    Message createRequestPB() {
        return TxnManager.BeginTransactionRequestPB.getDefaultInstance();
    }

    @Override
    String serviceName() {
        return "kudu.transactions.TxnManagerService";
    }

    @Override
    String method() {
        return "BeginTransaction";
    }

    @Override
    Pair<BeginTransactionResponse, Object> deserialize(CallResponse callResponse, String serverUUID) throws KuduException {
        TxnManager.BeginTransactionResponsePB.Builder b = TxnManager.BeginTransactionResponsePB.newBuilder();
        BeginTransactionRequest.readProtobuf(callResponse.getPBMessage(), b);
        if (!b.hasError()) {
            Preconditions.checkState(b.hasTxnId());
            Preconditions.checkState(b.hasKeepaliveMillis());
        }
        BeginTransactionResponse response = new BeginTransactionResponse(this.timeoutTracker.getElapsedMillis(), serverUUID, b.getTxnId(), b.getKeepaliveMillis());
        return new Pair<BeginTransactionResponse, Object>(response, b.hasError() ? b.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return featureFlags;
    }
}

