/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.zip.GZIPOutputStream;
import org.apache.kudu.shaded.com.google.common.base.Throwables;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CapturingToFileLogAppender
extends AbstractAppender
implements AutoCloseable {
    private static final PatternLayout LAYOUT = PatternLayout.newBuilder().withPattern("%d{HH:mm:ss.SSS} [%p - %t] (%F:%L) %m%n").build();
    private static final Random RANDOM = new Random();
    private File outputFile = File.createTempFile("captured_output", ".txt.gz");
    private Writer outputFileWriter;

    public CapturingToFileLogAppender(boolean useGzip) throws IOException {
        super(String.format("CapturingToFileLogAppender-%d", RANDOM.nextInt()), null, (Layout)LAYOUT, true, Property.EMPTY_ARRAY);
        try {
            OutputStream os = this.createOutputStream(useGzip);
            try {
                this.outputFileWriter = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
            }
            catch (Throwable t) {
                os.close();
            }
        }
        catch (Throwable t) {
            this.outputFile.delete();
            throw t;
        }
        this.start();
    }

    private OutputStream createOutputStream(boolean useGzip) throws IOException {
        OutputStream os = new FileOutputStream(this.outputFile.getPath());
        if (useGzip) {
            try {
                os = new GZIPOutputStream(os);
            }
            catch (IOException ex) {
                ((OutputStream)os).close();
                throw ex;
            }
        }
        return os;
    }

    @Override
    public void close() {
        if (this.outputFileWriter != null) {
            try {
                this.outputFileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputFileWriter = null;
        }
        if (this.outputFile != null) {
            this.outputFile.delete();
            this.outputFile = null;
        }
    }

    public void append(LogEvent event) {
        assert (this.outputFileWriter != null);
        try {
            this.outputFileWriter.write(LAYOUT.toSerializable(event));
            if (event.getThrown() != null) {
                this.outputFileWriter.write(Throwables.getStackTraceAsString(event.getThrown()));
                this.outputFileWriter.write("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finish() throws IOException {
        this.outputFileWriter.close();
        this.outputFileWriter = null;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public Closeable attach() {
        LoggerContext.getContext((boolean)false).getRootLogger().addAppender((Appender)this);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                LoggerContext.getContext((boolean)false).getRootLogger().removeAppender((Appender)CapturingToFileLogAppender.this);
            }
        };
    }
}

