/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test.cluster;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.io.CharStreams;
import org.apache.kudu.test.TempDirUtils;
import org.apache.kudu.test.cluster.KuduBinaryInfo;
import org.apache.kudu.test.cluster.KuduBinaryJarExtractor;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class KuduBinaryLocator {
    private static final String SASL_PATH_NAME = "SASL_PATH";
    private static final String KUDU_BIN_DIR_PROP = "kuduBinDir";
    private static final Logger LOG = LoggerFactory.getLogger(KuduBinaryLocator.class);

    private static KuduBinaryInfo findBinaryLocation() {
        block11: {
            KuduBinaryInfo kuduBinaryInfo;
            String kuduBinDirProp = System.getProperty(KUDU_BIN_DIR_PROP);
            if (kuduBinDirProp != null) {
                LOG.info("Using Kudu binary directory specified by system property '{}': {}", (Object)KUDU_BIN_DIR_PROP, (Object)kuduBinDirProp);
                return new KuduBinaryInfo(kuduBinDirProp);
            }
            try {
                KuduBinaryJarExtractor extractor = new KuduBinaryJarExtractor();
                if (extractor.isKuduBinaryJarOnClasspath()) {
                    File testTmpDir = TempDirUtils.makeTempDirectory("kudu-binary-jar", TempDirUtils.DeleteOnExit.DELETE_RECURSIVELY_ON_EXIT);
                    LOG.info("Using Kudu binary jar directory: {}", (Object)testTmpDir.getAbsolutePath());
                    return extractor.extractKuduBinaryArtifact(testTmpDir.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                LOG.warn("Unable to extract a Kudu binary jar", (Throwable)ex);
            }
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("which kudu");
            int errorCode = process.waitFor();
            if (errorCode != 0) break block11;
            InputStreamReader reader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
            try {
                String kuduBinary = CharStreams.toString(reader);
                String kuduBinDir = new File(kuduBinary).getParent();
                LOG.info("Using Kudu binary directory found on path with 'which kudu': {}", (Object)kuduBinDir);
                kuduBinaryInfo = new KuduBinaryInfo(kuduBinDir);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException ex) {
                    throw new RuntimeException("Error while locating kudu binary", ex);
                }
            }
            ((Reader)reader).close();
            return kuduBinaryInfo;
        }
        throw new RuntimeException("Set the system variable kuduBinDir or add the Kudu binary test jar to your classpath or ensure the `kudu` binary is on your path.");
    }

    public static ExecutableInfo findBinary(String exeName) throws FileNotFoundException {
        KuduBinaryInfo artifactInfo = KuduBinaryLocator.findBinaryLocation();
        File executable = new File(artifactInfo.getBinDir(), exeName);
        if (!executable.exists() || !executable.canExecute()) {
            throw new FileNotFoundException("Cannot find executable " + exeName + " in binary directory " + artifactInfo.getBinDir());
        }
        HashMap<String, String> env = new HashMap<String, String>();
        if (artifactInfo.getSaslDir() != null) {
            env.put(SASL_PATH_NAME, artifactInfo.getSaslDir());
        }
        return new ExecutableInfo(executable.getAbsolutePath(), env);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class ExecutableInfo {
        private final String exePath;
        private final Map<String, String> env;

        public ExecutableInfo(String exePath, Map<String, String> env) {
            Preconditions.checkNotNull(exePath);
            Preconditions.checkNotNull(env);
            this.exePath = exePath;
            this.env = env;
        }

        public String exePath() {
            return this.exePath;
        }

        public Map<String, String> environment() {
            return this.env;
        }
    }
}

