/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.lock.curator;

import com.google.common.collect.Maps;
import io.kyligence.kap.shaded.curator.org.apache.curator.framework.CuratorFramework;
import io.kyligence.kap.shaded.curator.org.apache.curator.framework.recipes.locks.InterProcessMutex;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.kylin.common.exception.DistributedLockException;
import org.apache.kylin.common.util.ThrowableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorDistributedLock
implements Lock {
    private static final Logger logger = LoggerFactory.getLogger(CuratorDistributedLock.class);
    private static final String ZK_ROOT = "/distribute_lock";
    static final Map<CuratorFramework, ConcurrentMap<LockEntry, Boolean>> lockedThreads = Maps.newConcurrentMap();
    private InterProcessMutex lock;
    private CuratorFramework client;
    private String path;
    private long clientSessionId = -1L;

    CuratorDistributedLock(CuratorFramework client, String path) {
        this.path = ZK_ROOT + this.fixPath(path);
        this.lock = new InterProcessMutex(client, this.path);
        this.client = client;
        try {
            this.clientSessionId = client.getZookeeperClient().getZooKeeper().getSessionId();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get zk Session Id of " + client, e);
        }
        if (!lockedThreads.containsKey(client)) {
            lockedThreads.put(client, Maps.newConcurrentMap());
        }
    }

    private String fixPath(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    @Override
    public void lock() {
        try {
            if (this.isAcquiredInThisThread()) {
                logger.info("Thread: {} already own the lock, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
                return;
            }
            LockEntry lockEntry = new LockEntry(Thread.currentThread(), this.path);
            lockedThreads.get(this.client).put(lockEntry, false);
            logger.info("Thread: {} try to get lock, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
            this.lock.acquire();
            lockedThreads.get(this.client).put(lockEntry, true);
            logger.info("Thread: {} get the lock, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
        }
        catch (Exception e) {
            try {
                this.unlock();
            }
            catch (Exception ee) {
                logger.error("Faild to release lock, zk Session Id: {}", (Object)this.clientSessionId, (Object)ee);
            }
            throw new DistributedLockException("Failed to get curator distributed lock for path: " + this.path, (Throwable)e);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        try {
            if (this.isAcquiredInThisThread()) {
                logger.info("Thread: {} already own the lock, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
                return true;
            }
            LockEntry lockEntry = new LockEntry(Thread.currentThread(), this.path);
            lockedThreads.get(this.client).put(lockEntry, false);
            logger.info("Thread: {} try to get lock, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
            boolean acquired = this.lock.acquire(time, unit);
            if (acquired) {
                lockedThreads.get(this.client).put(lockEntry, true);
                logger.info("Thread: {} get the lock, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
            } else {
                lockedThreads.get(this.client).remove(lockEntry);
                logger.info("Thread: {} get lock timeout, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
            }
            return acquired;
        }
        catch (Exception e) {
            try {
                this.unlock();
            }
            catch (Exception ee) {
                logger.error("Faild to release lock, zk Session Id: {}", (Object)this.clientSessionId, (Object)ee);
            }
            throw new DistributedLockException("Failed to get curator distributed lock, for path: " + this.path + ",zk Session Id: " + this.clientSessionId, (Throwable)e);
        }
    }

    @Override
    public void unlock() {
        try {
            this.unlockInternal();
        }
        catch (Exception e) {
            if (ThrowableUtils.isInterruptedException((Throwable)e)) {
                logger.info("unlock failed due to interrupt, re-unlock it for path {}, zk Session Id: {}", (Object)this.path, (Object)this.clientSessionId);
                try {
                    this.unlockInternal();
                }
                catch (Exception ee) {
                    logger.error("Failed to re-unlock for path {}, zk Session Id: {}", new Object[]{this.path, this.clientSessionId, ee});
                }
            }
            throw new DistributedLockException("Failed to release curator distributed lock for path: " + this.path + ",zk Session Id: " + this.clientSessionId, (Throwable)e);
        }
    }

    private void unlockInternal() throws Exception {
        logger.info("Thread: {} try to release lock, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
        if (this.isAcquiredInThisThread()) {
            this.lock.release();
            lockedThreads.get(this.client).remove(new LockEntry(Thread.currentThread(), this.path));
            logger.info("Thread: {} release lock, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
        } else {
            logger.warn("Thread: {} do not own the lock, for path: {}, zk Session Id: {}", new Object[]{Thread.currentThread().getId(), this.path, this.clientSessionId});
        }
    }

    public boolean isAcquiredInThisThread() {
        return this.lock.isOwnedByCurrentThread();
    }

    static class LockEntry {
        Thread thread;
        String path;

        LockEntry(Thread thread, String path) {
            this.thread = thread;
            this.path = path;
        }

        public Thread getThread() {
            return this.thread;
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockEntry lockEntry = (LockEntry)o;
            return Objects.equals(this.thread, lockEntry.thread) && Objects.equals(this.path, lockEntry.path);
        }

        public int hashCode() {
            return Objects.hash(this.thread, this.path);
        }
    }
}

