/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.lock.curator;

import io.kyligence.kap.shaded.curator.org.apache.curator.framework.CuratorFramework;
import io.kyligence.kap.shaded.curator.org.apache.curator.framework.state.ConnectionState;
import io.kyligence.kap.shaded.curator.org.apache.curator.framework.state.ConnectionStateListener;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.DistributedLockException;
import org.apache.kylin.common.lock.DistributedLockFactory;
import org.apache.kylin.common.lock.curator.CuratorDistributedLock;
import org.apache.kylin.common.util.ZKUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorDistributedLockFactory
extends DistributedLockFactory {
    private static final Logger logger = LoggerFactory.getLogger(CuratorDistributedLockFactory.class);
    private static final ConnectionStateListener listener = new CuratorDistributedLockListener();
    private final CuratorFramework client;

    private static CuratorFramework getZKClient(KylinConfig config) {
        try {
            return ZKUtil.getZookeeperClient(config, listener);
        }
        catch (Exception e) {
            throw new DistributedLockException("Failed to get curator client", (Throwable)e);
        }
    }

    public CuratorDistributedLockFactory() {
        this(KylinConfig.getInstanceFromEnv());
    }

    public CuratorDistributedLockFactory(KylinConfig config) {
        this.client = CuratorDistributedLockFactory.getZKClient(config);
    }

    public Lock getLockForClient(String client, String key) {
        return new CuratorDistributedLock(this.client, key);
    }

    public void initialize() {
    }

    public CuratorDistributedLock getLockForCurrentThread(String path) {
        return new CuratorDistributedLock(this.client, path);
    }

    static class CuratorDistributedLockListener
    implements ConnectionStateListener {
        CuratorDistributedLockListener() {
        }

        public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
            long sessionId = -1L;
            try {
                sessionId = curatorFramework.getZookeeperClient().getZooKeeper().getSessionId();
            }
            catch (Exception e) {
                logger.error("Failed to get zk Session Id of {}", (Object)curatorFramework, (Object)e);
            }
            switch (connectionState) {
                case LOST: 
                case SUSPENDED: {
                    logger.error("zk connection {}, zk Session Id: {}", (Object)connectionState, (Object)sessionId);
                    ConcurrentMap<CuratorDistributedLock.LockEntry, Boolean> locks = CuratorDistributedLock.lockedThreads.get(curatorFramework);
                    if (locks == null || locks.isEmpty()) break;
                    for (Map.Entry entry : locks.entrySet()) {
                        CuratorDistributedLock.LockEntry lockEntry = (CuratorDistributedLock.LockEntry)entry.getKey();
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        lockEntry.getThread().interrupt();
                        logger.error("Thread interrupt: {}, zk lock {} for path: {}, lock acquired: {}, zk Session Id: {}", new Object[]{lockEntry.thread.getId(), connectionState, lockEntry.path, entry.getValue(), sessionId});
                    }
                    CuratorDistributedLock.lockedThreads.get(curatorFramework).clear();
                    break;
                }
                default: {
                    logger.info("zk connection state changed to: {}, zk Session Id: {}", (Object)connectionState, (Object)sessionId);
                }
            }
        }
    }
}

