/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.metrics.JobMetricsFacade;
import org.apache.kylin.job.util.MailNotificationUtil;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubingJob
extends DefaultChainedExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CubingJob.class);
    private static final long MIN_SOURCE_SIZE = 0x2000000L;
    public static final String SOURCE_RECORD_COUNT = "sourceRecordCount";
    public static final String SOURCE_SIZE_BYTES = "sourceSizeBytes";
    public static final String CUBE_SIZE_BYTES = "byteSizeBytes";
    public static final String MAP_REDUCE_WAIT_TIME = "mapReduceWaitTime";
    private static final String DEPLOY_ENV_NAME = "envName";
    private static final String JOB_TYPE = "jobType";
    private static final String SEGMENT_NAME = "segmentName";

    public static CubingJob createBuildJob(CubeSegment seg, String submitter, JobEngineConfig config) {
        return CubingJob.initCubingJob(seg, CubingJobTypeEnum.BUILD.toString(), submitter, config);
    }

    public static CubingJob createOptimizeJob(CubeSegment seg, String submitter, JobEngineConfig config) {
        return CubingJob.initCubingJob(seg, CubingJobTypeEnum.OPTIMIZE.toString(), submitter, config);
    }

    public static CubingJob createMergeJob(CubeSegment seg, String submitter, JobEngineConfig config) {
        return CubingJob.initCubingJob(seg, CubingJobTypeEnum.MERGE.toString(), submitter, config);
    }

    public static CubingJob createStreamJob(CubeSegment seg, String submitter, JobEngineConfig config) {
        return CubingJob.initCubingJob(seg, CubingJobTypeEnum.STREAM.toString(), submitter, config);
    }

    private static CubingJob initCubingJob(CubeSegment seg, String jobType, String submitter, JobEngineConfig config) {
        KylinConfig kylinConfig = config.getConfig();
        CubeInstance cube = seg.getCubeInstance();
        List projList = ProjectManager.getInstance((KylinConfig)kylinConfig).findProjects(cube.getType(), cube.getName());
        if (projList == null || projList.size() == 0) {
            throw new RuntimeException("Cannot find the project containing the cube " + cube.getName() + "!!!");
        }
        if (projList.size() >= 2) {
            String msg = "Find more than one project containing the cube " + cube.getName() + ". It does't meet the uniqueness requirement!!! ";
            if (!config.getConfig().allowCubeAppearInMultipleProjects()) {
                throw new RuntimeException(msg);
            }
            logger.warn(msg);
        }
        CubingJob result = new CubingJob();
        SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss", Locale.ROOT);
        format.setTimeZone(TimeZone.getTimeZone(config.getTimeZone()));
        result.setDeployEnvName(kylinConfig.getDeployEnv());
        result.setProjectName(((ProjectInstance)projList.get(0)).getName());
        result.setJobType(jobType);
        CubingExecutableUtil.setCubeName(seg.getCubeInstance().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(seg.getUuid(), result.getParams());
        CubingExecutableUtil.setSegmentName(seg.getName(), result.getParams());
        result.setName(jobType + " CUBE - " + seg.getCubeInstance().getDisplayName() + " - " + seg.getName() + " - " + format.format(new Date(System.currentTimeMillis())));
        result.setSubmitter(submitter);
        result.setNotifyList(seg.getCubeInstance().getDescriptor().getNotifyList());
        return result;
    }

    public int getDefaultPriority() {
        CubingJobTypeEnum jobType = CubingJobTypeEnum.getByName(this.getJobType());
        if (jobType == null) {
            return super.getDefaultPriority();
        }
        return jobType.getDefaultPriority();
    }

    protected void setDeployEnvName(String name) {
        this.setParam(DEPLOY_ENV_NAME, name);
    }

    public String getDeployEnvName() {
        return this.getParam(DEPLOY_ENV_NAME);
    }

    public String getJobType() {
        return this.getParam(JOB_TYPE);
    }

    public String getSegmentName() {
        return this.getParam(SEGMENT_NAME);
    }

    void setJobType(String jobType) {
        this.setParam(JOB_TYPE, jobType);
    }

    protected Pair<String, String> formatNotifications(ExecutableContext context, ExecutableState state) {
        CubeInstance cubeInstance = CubeManager.getInstance((KylinConfig)context.getConfig()).getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        Output output = this.getManager().getOutput(this.getId());
        if (state != ExecutableState.ERROR && !cubeInstance.getDescriptor().getStatusNeedNotify().contains(state.toString())) {
            logger.info("state:" + state + " no need to notify users");
            return null;
        }
        if (!MailNotificationUtil.hasMailNotification((ExecutableState)state)) {
            logger.info("Cannot find email template for job state: " + state);
            return null;
        }
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("job_name", this.getName());
        dataMap.put("env_name", this.getDeployEnvName());
        dataMap.put("submitter", StringUtil.noBlank((String)this.getSubmitter(), (String)"missing submitter"));
        dataMap.put("job_engine", MailNotificationUtil.getLocalHostName());
        dataMap.put("project_name", this.getProjectName());
        dataMap.put("cube_name", cubeInstance.getName());
        dataMap.put("source_records_count", String.valueOf(this.findSourceRecordCount()));
        dataMap.put("start_time", new Date(this.getStartTime()).toString());
        dataMap.put("duration", this.getDuration() / 60000L + "mins");
        dataMap.put("mr_waiting", this.getMapReduceWaitTime() / 60000L + "mins");
        dataMap.put("last_update_time", new Date(this.getLastModified()).toString());
        if (state == ExecutableState.ERROR) {
            AbstractExecutable errorTask = null;
            Output errorOutput = null;
            for (AbstractExecutable task : this.getTasks()) {
                errorOutput = this.getManager().getOutput(task.getId());
                if (errorOutput.getState() != ExecutableState.ERROR) continue;
                errorTask = task;
                break;
            }
            Preconditions.checkNotNull(errorTask, (Object)("None of the sub tasks of cubing job " + this.getId() + " is error and this job should become success."));
            dataMap.put("error_step", errorTask.getName());
            if (errorTask instanceof MapReduceExecutable) {
                String mrJobId = (String)errorOutput.getExtra().get("mr_job_id");
                dataMap.put("mr_job_id", StringUtil.noBlank((String)mrJobId, (String)"Not initialized"));
            } else {
                dataMap.put("mr_job_id", "NA");
            }
            dataMap.put("error_log", Matcher.quoteReplacement(StringUtil.noBlank((String)output.getVerboseMsg(), (String)"no error message")));
        }
        String content = MailNotificationUtil.getMailContent((ExecutableState)state, (Map)dataMap);
        String title = MailNotificationUtil.getMailTitle((String[])new String[]{"JOB", state.toString(), this.getDeployEnvName(), this.getProjectName(), cubeInstance.getName()});
        return Pair.newPair((Object)title, (Object)content);
    }

    protected void onExecuteStart(ExecutableContext executableContext) {
        KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)this.getCubeSpecificConfig());
        super.onExecuteStart(executableContext);
    }

    protected void onExecuteFinished(ExecuteResult result, ExecutableContext executableContext) {
        AbstractExecutable task;
        ExecutableState status;
        long time = 0L;
        Iterator iterator = this.getTasks().iterator();
        while (iterator.hasNext() && (status = (task = (AbstractExecutable)iterator.next()).getStatus()) == ExecutableState.SUCCEED) {
            if (!(task instanceof MapReduceExecutable)) continue;
            time += ((MapReduceExecutable)task).getMapReduceWaitTime();
        }
        this.setMapReduceWaitTime(time);
        super.onExecuteFinished(result, executableContext);
    }

    protected void onStatusChange(ExecutableContext context, ExecuteResult result, ExecutableState state) {
        super.onStatusChange(context, result, state);
        this.updateMetrics(context, result, state);
    }

    protected void updateMetrics(ExecutableContext context, ExecuteResult result, ExecutableState state) {
        JobMetricsFacade.JobStatisticsResult jobStats = new JobMetricsFacade.JobStatisticsResult();
        jobStats.setWrapper(this.getSubmitter(), this.getProjectName(), CubingExecutableUtil.getCubeName(this.getParams()), this.getId(), this.getJobType(), this.getAlgorithm() == null ? "NULL" : this.getAlgorithm().toString());
        if (state == ExecutableState.SUCCEED) {
            jobStats.setJobStats(this.findSourceSizeBytes(), this.findCubeSizeBytes(), this.getDuration(), this.getMapReduceWaitTime(), CubingJob.getPerBytesTimeCost(this.findSourceSizeBytes(), this.getDuration()));
            if (CubingJobTypeEnum.getByName(this.getJobType()) == CubingJobTypeEnum.BUILD) {
                jobStats.setJobStepStats(this.getTaskDurationByName("Extract Fact Table Distinct Columns"), this.getTaskDurationByName("Build Dimension Dictionary"), this.getTaskDurationByName("Build Cube In-Mem"), this.getTaskDurationByName("Convert Cuboid Data to HFile"));
            }
        } else if (state == ExecutableState.ERROR) {
            jobStats.setJobException(result.getThrowable() != null ? result.getThrowable() : new Exception());
        }
        JobMetricsFacade.updateMetrics((JobMetricsFacade.JobStatisticsResult)jobStats);
    }

    private long getTaskDurationByName(String name) {
        AbstractExecutable task = this.getTaskByName(name);
        if (task != null) {
            return task.getDuration();
        }
        return 0L;
    }

    private static double getPerBytesTimeCost(long size, long timeCost) {
        if (size <= 0L) {
            return 0.0;
        }
        if (size < 0x2000000L) {
            size = 0x2000000L;
        }
        return (double)timeCost * 1.0 / (double)size;
    }

    public void setAlgorithm(AlgorithmEnum alg) {
        this.addExtraInfo("algorithm", alg.name());
    }

    public AlgorithmEnum getAlgorithm() {
        String alg = (String)this.getExtraInfo().get("algorithm");
        return alg == null ? null : AlgorithmEnum.valueOf(alg);
    }

    public boolean isLayerCubing() {
        return AlgorithmEnum.LAYER == this.getAlgorithm();
    }

    public boolean isInMemCubing() {
        return AlgorithmEnum.INMEM == this.getAlgorithm();
    }

    public long findSourceRecordCount() {
        return Long.parseLong(this.findExtraInfo(SOURCE_RECORD_COUNT, "0"));
    }

    public long findSourceSizeBytes() {
        return Long.parseLong(this.findExtraInfo(SOURCE_SIZE_BYTES, "0"));
    }

    public long findCubeSizeBytes() {
        return Long.parseLong(this.findExtraInfoBackward(CUBE_SIZE_BYTES, "0"));
    }

    public List<Double> findEstimateRatio(CubeSegment seg, KylinConfig config) {
        Map<Long, Double> estimatedSizeMap;
        CubeInstance cubeInstance = seg.getCubeInstance();
        CuboidScheduler cuboidScheduler = cubeInstance.getCuboidScheduler();
        List layeredCuboids = cuboidScheduler.getCuboidsByLayer();
        int totalLevels = cuboidScheduler.getBuildLevel();
        ArrayList result = Lists.newArrayList();
        String cuboidRootPath = this.getCuboidRootPath(seg, config);
        try {
            estimatedSizeMap = new CubeStatsReader(seg, config, true).getCuboidSizeMap(true);
        }
        catch (IOException e) {
            logger.warn("Cannot get segment {} estimated size map", (Object)seg.getName());
            return null;
        }
        for (int level = 0; level <= totalLevels; ++level) {
            double levelEstimatedSize = 0.0;
            for (Long cuboidId : (List)layeredCuboids.get(level)) {
                levelEstimatedSize += estimatedSizeMap.get(cuboidId) == null ? 0.0 : estimatedSizeMap.get(cuboidId);
            }
            double levelRealSize = this.getRealSizeByLevel(cuboidRootPath, level);
            if (levelEstimatedSize == 0.0 || levelRealSize == 0.0) {
                result.add(level, -1.0);
                continue;
            }
            result.add(level, levelRealSize / levelEstimatedSize);
        }
        return result;
    }

    private double getRealSizeByLevel(String rootPath, int level) {
        try {
            String levelPath = JobBuilderSupport.getCuboidOutputPathsByLevel(rootPath, level);
            FileSystem fs = HadoopUtil.getFileSystem((String)levelPath);
            return fs.getContentSummary(new Path(levelPath)).getLength() / 0x100000L;
        }
        catch (Exception e) {
            logger.warn("get level real size failed." + e);
            return 0.0;
        }
    }

    private String getCuboidRootPath(CubeSegment seg, KylinConfig kylinConfig) {
        String rootDir = kylinConfig.getHdfsWorkingDirectory();
        if (!rootDir.endsWith("/")) {
            rootDir = rootDir + "/";
        }
        String jobID = this.getId();
        return rootDir + "kylin-" + jobID + "/" + seg.getRealization().getName() + "/cuboid/";
    }

    public static enum CubingJobTypeEnum {
        BUILD("BUILD", 20),
        OPTIMIZE("OPTIMIZE", 5),
        MERGE("MERGE", 25),
        STREAM("STREAM", 30);

        private final String name;
        private final int defaultPriority;

        private CubingJobTypeEnum(String name, int priority) {
            this.name = name;
            this.defaultPriority = priority;
        }

        public int getDefaultPriority() {
            return this.defaultPriority;
        }

        public String toString() {
            return this.name;
        }

        public static CubingJobTypeEnum getByName(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                return null;
            }
            for (CubingJobTypeEnum jobTypeEnum : CubingJobTypeEnum.values()) {
                if (!jobTypeEnum.name.equals(name.toUpperCase(Locale.ROOT))) continue;
                return jobTypeEnum;
            }
            return null;
        }
    }

    public static enum AlgorithmEnum {
        LAYER,
        INMEM;

    }
}

