/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.job.execution.DefaultChainedExecutable;

public class LookupMaterializeContext {
    private DefaultChainedExecutable jobFlow;
    private Map<String, String> lookupSnapshotMap;

    public LookupMaterializeContext(DefaultChainedExecutable jobFlow) {
        this.jobFlow = jobFlow;
        this.lookupSnapshotMap = Maps.newHashMap();
    }

    public DefaultChainedExecutable getJobFlow() {
        return this.jobFlow;
    }

    public void addLookupSnapshotPath(String lookupTable, String snapshotPath) {
        this.lookupSnapshotMap.put(lookupTable, snapshotPath);
    }

    public String getAllLookupSnapshotsInString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> lookupSnapshotEntry : this.lookupSnapshotMap.entrySet()) {
            if (!first) {
                result.append(",");
            }
            first = false;
            result.append(lookupSnapshotEntry.getKey());
            result.append("=");
            result.append(lookupSnapshotEntry.getValue());
        }
        return result.toString();
    }

    public static Map<String, String> parseLookupSnapshots(String snapshotsString) {
        String[] lookupSnapshotEntries;
        HashMap lookupSnapshotMap = Maps.newHashMap();
        for (String lookupSnapshotEntryStr : lookupSnapshotEntries = StringUtil.splitByComma((String)snapshotsString)) {
            String[] split = StringUtil.split((String)lookupSnapshotEntryStr, (String)"=");
            lookupSnapshotMap.put(split[0], split[1]);
        }
        return lookupSnapshotMap;
    }
}

