/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.IStorageAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.SourceManager;
import org.apache.kylin.storage.StorageFactory;

public class MRUtil {
    public static IMRInput.IMRBatchCubingInputSide getBatchCubingInputSide(CubeSegment seg) {
        IJoinedFlatTableDesc flatDesc = EngineFactory.getJoinedFlatTableDesc((CubeSegment)seg);
        return (IMRInput.IMRBatchCubingInputSide)((IMRInput)SourceManager.createEngineAdapter((ISourceAware)seg, IMRInput.class)).getBatchCubingInputSide(flatDesc);
    }

    public static IMRInput.IMRTableInputFormat getTableInputFormat(String tableName, String prj, String uuid) {
        TableDesc t = MRUtil.getTableDesc(tableName, prj);
        return ((IMRInput)SourceManager.createEngineAdapter((ISourceAware)t, IMRInput.class)).getTableInputFormat(t, uuid);
    }

    public static IMRInput.IMRTableInputFormat getTableInputFormat(TableDesc tableDesc, String uuid) {
        return ((IMRInput)SourceManager.createEngineAdapter((ISourceAware)tableDesc, IMRInput.class)).getTableInputFormat(tableDesc, uuid);
    }

    private static TableDesc getTableDesc(String tableName, String prj) {
        return TableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getTableDesc(tableName, prj);
    }

    public static IMROutput2.IMRBatchCubingOutputSide2 getBatchCubingOutputSide2(CubeSegment seg) {
        return ((IMROutput2)StorageFactory.createEngineAdapter((IStorageAware)seg, IMROutput2.class)).getBatchCubingOutputSide(seg);
    }

    public static IMROutput2.IMRBatchMergeOutputSide2 getBatchMergeOutputSide2(CubeSegment seg) {
        return ((IMROutput2)StorageFactory.createEngineAdapter((IStorageAware)seg, IMROutput2.class)).getBatchMergeOutputSide(seg);
    }

    public static IMRInput.IMRBatchMergeInputSide getBatchMergeInputSide(CubeSegment seg) {
        return (IMRInput.IMRBatchMergeInputSide)((IMRInput)SourceManager.createEngineAdapter((ISourceAware)seg, IMRInput.class)).getBatchMergeInputSide((ISegment)seg);
    }

    public static IMROutput2.IMRBatchOptimizeOutputSide2 getBatchOptimizeOutputSide2(CubeSegment seg) {
        return ((IMROutput2)StorageFactory.createEngineAdapter((IStorageAware)seg, IMROutput2.class)).getBatchOptimizeOutputSide(seg);
    }

    public static int runMRJob(Tool tool, String[] args) throws Exception {
        Configuration conf = tool.getConf();
        if (conf == null) {
            conf = new Configuration();
        }
        GenericOptionsParser parser = MRUtil.getParser(conf, args);
        tool.setConf(conf);
        String[] toolArgs = parser.getRemainingArgs();
        return tool.run(toolArgs);
    }

    private static synchronized GenericOptionsParser getParser(Configuration conf, String[] args) throws Exception {
        return new GenericOptionsParser(conf, args);
    }
}

