/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.job.execution.ExecutableContext;

public class CubingExecutableUtil {
    public static final String CUBE_NAME = "cubeName";
    public static final String DISPALY_NAME = "displayName";
    public static final String SEGMENT_NAME = "segmentName";
    public static final String SEGMENT_ID = "segmentId";
    public static final String MERGING_SEGMENT_IDS = "mergingSegmentIds";
    public static final String STATISTICS_PATH = "statisticsPath";
    public static final String CUBING_JOB_ID = "cubingJobId";
    public static final String MERGED_STATISTICS_PATH = "mergedStatisticsPath";
    public static final String INDEX_PATH = "indexPath";
    public static final String DICTIONARIES_PATH = "dictsPath";

    public static void setStatisticsPath(String path, Map<String, String> params) {
        params.put(STATISTICS_PATH, path);
    }

    public static String getStatisticsPath(Map<String, String> params) {
        return params.get(STATISTICS_PATH);
    }

    public static void setCubeName(String cubeName, Map<String, String> params) {
        params.put(CUBE_NAME, cubeName);
    }

    public static String getCubeName(Map<String, String> params) {
        return params.get(CUBE_NAME);
    }

    public static void setSegmentName(String segmentName, Map<String, String> params) {
        params.put(SEGMENT_NAME, segmentName);
    }

    public static String getSegmentName(Map<String, String> params) {
        return params.get(SEGMENT_NAME);
    }

    public static void setSegmentId(String segmentId, Map<String, String> params) {
        params.put(SEGMENT_ID, segmentId);
    }

    public static String getSegmentId(Map<String, String> params) {
        return params.get(SEGMENT_ID);
    }

    public static void setMergingSegmentIds(List<String> ids, Map<String, String> params) {
        params.put(MERGING_SEGMENT_IDS, StringUtils.join(ids, (String)","));
    }

    public static CubeSegment findSegment(ExecutableContext context, String cubeName, String segmentId) {
        CubeManager mgr = CubeManager.getInstance((KylinConfig)context.getConfig());
        CubeInstance cube = mgr.getCube(cubeName);
        if (cube == null) {
            String cubeList = StringUtils.join(Iterables.transform((Iterable)mgr.listAllCubes(), (Function)new Function<CubeInstance, String>(){

                @Nullable
                public String apply(@Nullable CubeInstance input) {
                    return input.getName();
                }
            }).iterator(), (String)",");
            throw new IllegalStateException("target cube name: " + cubeName + " cube list: " + cubeList);
        }
        CubeSegment newSegment = cube.getSegmentById(segmentId);
        if (newSegment == null) {
            String segmentList = StringUtils.join(Iterables.transform((Iterable)cube.getSegments(), (Function)new Function<CubeSegment, String>(){

                @Nullable
                public String apply(@Nullable CubeSegment input) {
                    return input.getUuid();
                }
            }).iterator(), (String)",");
            throw new IllegalStateException("target segment id: " + segmentId + " segment list: " + segmentList);
        }
        return newSegment;
    }

    public static List<String> getMergingSegmentIds(Map<String, String> params) {
        String ids = params.get(MERGING_SEGMENT_IDS);
        if (ids != null) {
            String[] splitted = StringUtils.split((String)ids, (String)",");
            ArrayList result = Lists.newArrayListWithExpectedSize((int)splitted.length);
            for (String id : splitted) {
                result.add(id);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static void setCubingJobId(String id, Map<String, String> params) {
        params.put(CUBING_JOB_ID, id);
    }

    public static String getCubingJobId(Map<String, String> params) {
        return params.get(CUBING_JOB_ID);
    }

    public static void setMergedStatisticsPath(String path, Map<String, String> params) {
        params.put(MERGED_STATISTICS_PATH, path);
    }

    public static String getMergedStatisticsPath(Map<String, String> params) {
        return params.get(MERGED_STATISTICS_PATH);
    }

    public static void setDictsPath(String path, Map<String, String> params) {
        params.put(DICTIONARIES_PATH, path);
    }

    public static String getDictsPath(Map<String, String> params) {
        return params.get(DICTIONARIES_PATH);
    }
}

