/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import io.kyligence.kap.guava20.shaded.common.eventbus.Subscribe;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.kylin.common.persistence.transaction.AccessBatchGrantEventNotifier;
import org.apache.kylin.common.persistence.transaction.AccessGrantEventNotifier;
import org.apache.kylin.common.persistence.transaction.AccessRevokeEventNotifier;
import org.apache.kylin.common.persistence.transaction.AclGrantEventNotifier;
import org.apache.kylin.common.persistence.transaction.AclRevokeEventNotifier;
import org.apache.kylin.common.persistence.transaction.AclTCRRevokeEventNotifier;
import org.apache.kylin.common.persistence.transaction.AddS3CredentialToSparkBroadcastEventNotifier;
import org.apache.kylin.common.persistence.transaction.AuditLogBroadcastEventNotifier;
import org.apache.kylin.common.persistence.transaction.BroadcastEventReadyNotifier;
import org.apache.kylin.common.persistence.transaction.EpochCheckBroadcastNotifier;
import org.apache.kylin.common.persistence.transaction.LogicalViewBroadcastNotifier;
import org.apache.kylin.common.persistence.transaction.StopQueryBroadcastEventNotifier;
import org.apache.kylin.common.persistence.transaction.UpdateJobStatusEventNotifier;
import org.apache.kylin.metadata.epoch.EpochManager;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.rest.broadcaster.BroadcastEventHandler;
import org.apache.kylin.rest.broadcaster.Broadcaster;
import org.apache.kylin.rest.security.AdminUserSyncEventNotifier;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRService;
import org.apache.kylin.rest.service.AuditLogService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.service.QueryService;
import org.apache.kylin.rest.service.UserAclService;
import org.apache.spark.sql.LogicalViewLoader;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BroadcastListener
implements BroadcastEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BroadcastListener.class);
    @Autowired
    private AuditLogService auditLogService;
    @Autowired
    @Qualifier(value="queryService")
    private QueryService queryService;
    @Autowired
    private AclTCRService aclTCRService;
    @Autowired
    private AccessService accessService;
    @Autowired
    private UserAclService userAclService;
    @Autowired
    private JobService jobService;
    @Autowired
    private Broadcaster broadcaster;

    @PostConstruct
    public void init() {
        this.broadcaster.register((BroadcastEventHandler)this);
        this.broadcaster.start();
    }

    @PreDestroy
    public void cleanup() {
        this.broadcaster.close();
        this.broadcaster.unregister();
    }

    @Subscribe
    public void onEventReady(BroadcastEventReadyNotifier notifier) {
        this.broadcaster.announce(notifier);
    }

    public void handle(BroadcastEventReadyNotifier notifier) throws IOException {
        log.info("accept broadcast Event {}", (Object)notifier);
        if (notifier instanceof AuditLogBroadcastEventNotifier) {
            this.auditLogService.notifyCatchUp();
        } else if (notifier instanceof StopQueryBroadcastEventNotifier) {
            this.queryService.stopQuery(notifier.getSubject());
        } else if (notifier instanceof EpochCheckBroadcastNotifier) {
            EpochManager.getInstance().updateAllEpochs();
        } else if (notifier instanceof AclGrantEventNotifier) {
            this.aclTCRService.updateAclFromRemote((AclGrantEventNotifier)notifier, null);
        } else if (notifier instanceof AclRevokeEventNotifier) {
            this.aclTCRService.updateAclFromRemote(null, (AclRevokeEventNotifier)notifier);
        } else if (notifier instanceof AccessGrantEventNotifier) {
            this.accessService.updateAccessFromRemote((AccessGrantEventNotifier)notifier, null, null);
        } else if (notifier instanceof AccessBatchGrantEventNotifier) {
            this.accessService.updateAccessFromRemote(null, (AccessBatchGrantEventNotifier)notifier, null);
        } else if (notifier instanceof AccessRevokeEventNotifier) {
            this.accessService.updateAccessFromRemote(null, null, (AccessRevokeEventNotifier)notifier);
        } else if (notifier instanceof UpdateJobStatusEventNotifier) {
            UpdateJobStatusEventNotifier updateJobStatusEventNotifier = (UpdateJobStatusEventNotifier)notifier;
            this.jobService.batchUpdateGlobalJobStatus(updateJobStatusEventNotifier.getJobIds(), updateJobStatusEventNotifier.getAction(), updateJobStatusEventNotifier.getStatuses());
        } else if (notifier instanceof AclTCRRevokeEventNotifier) {
            AclTCRRevokeEventNotifier aclTCRRevokeEventNotifier = (AclTCRRevokeEventNotifier)notifier;
            this.aclTCRService.revokeAclTCR(aclTCRRevokeEventNotifier.getSid(), aclTCRRevokeEventNotifier.isPrinciple());
        } else if (notifier instanceof AddS3CredentialToSparkBroadcastEventNotifier) {
            AddS3CredentialToSparkBroadcastEventNotifier s3CredentialNotifier = (AddS3CredentialToSparkBroadcastEventNotifier)notifier;
            SparderEnv.addS3Credential((TableExtDesc.S3RoleCredentialInfo)new TableExtDesc.S3RoleCredentialInfo(s3CredentialNotifier.getBucket(), s3CredentialNotifier.getRole(), s3CredentialNotifier.getEndpoint()), (SparkSession)SparderEnv.getSparkSession());
        } else if (notifier instanceof AdminUserSyncEventNotifier) {
            AdminUserSyncEventNotifier adminUserSyncEventNotifier = (AdminUserSyncEventNotifier)notifier;
            this.userAclService.syncAdminUserAcl(adminUserSyncEventNotifier.getAdminUserList(), adminUserSyncEventNotifier.isUseEmptyPermission());
        } else if (notifier instanceof LogicalViewBroadcastNotifier) {
            LogicalViewLoader.syncViewAsync();
        }
    }

    public void handleLocally(BroadcastEventReadyNotifier notifier) throws IOException {
        this.handle(notifier);
    }
}

