/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.kylin.common.util.SecretKeyUtil;
import org.apache.kylin.query.util.QueryLimiter;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.HealthResponse;
import org.apache.kylin.rest.service.HealthService;
import org.apache.kylin.tool.daemon.ServiceOpLevelEnum;
import org.apache.kylin.tool.util.ToolUtil;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/kg/health"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class HealthController
extends NBasicController {
    @Generated
    private static final Logger log = Logger.getLogger(HealthController.class);
    private static final int MAX_TOKEN_LENGTH = 64;
    private static final long VALIDATION_DURATION = 20000L;
    private static String KE_PID;
    @Autowired
    @Qualifier(value="healthService")
    private HealthService healthService;

    public synchronized void setKePid(String pid) {
        KE_PID = pid;
    }

    @ApiOperation(value="health APIs", tags={"SM"})
    @PostMapping(value={"/instance_info"})
    @ResponseBody
    public EnvelopeResponse<HealthResponse> getHealthStatus(HttpServletRequest request) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream((InputStream)request.getInputStream());){
            byte[] encryptedToken = this.readEncryptedToken(bis);
            if (!this.validateToken(encryptedToken)) {
                EnvelopeResponse envelopeResponse = new EnvelopeResponse("999", null, "Check permission failed!");
                return envelopeResponse;
            }
            EnvelopeResponse<HealthResponse> envelopeResponse = this.getHealthStatus();
            return envelopeResponse;
        }
    }

    @ApiOperation(value="health APIs", tags={"SM"})
    @PostMapping(value={"/instance_service/{state}"})
    @ResponseBody
    public EnvelopeResponse<String> changeServerState(HttpServletRequest request, @PathVariable String state) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream((InputStream)request.getInputStream());){
            byte[] encryptedToken = this.readEncryptedToken(bis);
            if (!this.validateToken(encryptedToken)) {
                EnvelopeResponse envelopeResponse = new EnvelopeResponse("999", (Object)"", "Check permission failed!");
                return envelopeResponse;
            }
            if (ServiceOpLevelEnum.QUERY_DOWN_GRADE.getOpType().equals(state)) {
                QueryLimiter.downgrade();
            } else if (ServiceOpLevelEnum.QUERY_UP_GRADE.getOpType().equals(state)) {
                QueryLimiter.recover();
            } else {
                throw new IllegalArgumentException("Illegal server state: " + state);
            }
            EnvelopeResponse envelopeResponse = new EnvelopeResponse("000", (Object)"", "");
            return envelopeResponse;
        }
    }

    public EnvelopeResponse<HealthResponse> getHealthStatus() {
        HealthResponse.RestartSparkStatusResponse sparkRestartStatus = this.healthService.getRestartSparkStatus();
        List canceledSlowQueriesStatus = this.healthService.getCanceledSlowQueriesStatus();
        HealthResponse healthResponse = new HealthResponse(sparkRestartStatus, canceledSlowQueriesStatus);
        return new EnvelopeResponse("000", (Object)healthResponse, "");
    }

    private byte[] readEncryptedToken(BufferedInputStream bis) throws IOException {
        int data;
        ArrayList byteList = Lists.newArrayList();
        int readByteCount = 0;
        while ((data = bis.read()) != -1) {
            byteList.add((byte)data);
            if (++readByteCount <= 64) continue;
            return null;
        }
        byte[] encryptedToken = new byte[readByteCount];
        for (int i = 0; i < readByteCount; ++i) {
            encryptedToken[i] = (Byte)byteList.get(i);
        }
        return encryptedToken;
    }

    private boolean validateToken(byte[] encryptedToken) {
        if (null == encryptedToken || encryptedToken.length == 0) {
            return false;
        }
        try {
            SecretKey secretKey = SecretKeyUtil.getKGSecretKey();
            String originalToken = SecretKeyUtil.decryptToken((SecretKey)secretKey, (byte[])encryptedToken);
            String[] parts = originalToken.split("_");
            if (parts.length != 2) {
                return false;
            }
            if (null == HealthController.getKE_PID()) {
                this.setKePid(ToolUtil.getKylinPid());
            }
            if (!parts[0].equals(HealthController.getKE_PID())) {
                return false;
            }
            long timestamp = Long.parseLong(parts[1]);
            return System.currentTimeMillis() - timestamp <= 20000L;
        }
        catch (Exception e) {
            log.error((Object)"Validate token failed! ", (Throwable)e);
            return false;
        }
    }

    @Generated
    public static String getKE_PID() {
        return KE_PID;
    }
}

