/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.EpochRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.EpochService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/epoch"}, produces={"application/vnd.apache.kylin-v4+json"})
public class NEpochController
extends NBasicController {
    @Autowired
    @Qualifier(value="epochService")
    private EpochService epochService;

    @ApiOperation(value="change epoch", tags={"DW"})
    @PostMapping(value={""}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> updateEpochOwner(@RequestBody EpochRequest epochRequest) {
        this.checkCollectionRequiredArg("projects", epochRequest.getProjects());
        epochRequest.getProjects().forEach(this::checkProjectName);
        this.checkRequiredArg("force", epochRequest.getForce());
        this.epochService.updateEpoch(epochRequest.getProjects(), epochRequest.getForce().booleanValue(), epochRequest.isClient());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="change all epoch", tags={"DW"})
    @PostMapping(value={"/all"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> updateAllEpochOwner(@RequestBody EpochRequest epochRequest) {
        this.checkRequiredArg("force", epochRequest.getForce());
        this.epochService.updateAllEpochs(epochRequest.getForce().booleanValue(), epochRequest.isClient());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @GetMapping(value={"/maintenance_mode"})
    @ResponseBody
    public EnvelopeResponse<Boolean> isMaintenanceMode() {
        return new EnvelopeResponse("000", (Object)this.epochService.isMaintenanceMode(), "");
    }
}

