/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.annotations.VisibleForTesting;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.transaction.EpochCheckBroadcastNotifier;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.helper.MetadataToolHelper;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.DiagPackageRequest;
import org.apache.kylin.rest.request.DiagProgressRequest;
import org.apache.kylin.rest.request.MaintenanceModeRequest;
import org.apache.kylin.rest.request.QueryDiagPackageRequest;
import org.apache.kylin.rest.response.DiagStatusResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.MaintenanceModeResponse;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.kylin.rest.response.ServersResponse;
import org.apache.kylin.rest.service.MaintenanceModeService;
import org.apache.kylin.rest.service.MetadataBackupService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.SystemService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.tool.HDFSMetadataTool;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/system"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class NSystemController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NSystemController.class);
    @Autowired
    @Qualifier(value="systemService")
    private SystemService systemService;
    @Autowired
    @Qualifier(value="maintenanceModeService")
    private MaintenanceModeService maintenanceModeService;
    @Autowired
    private ClusterManager clusterManager;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private MetadataBackupService metadataBackupService;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    private MetadataToolHelper metadataToolHelper = new MetadataToolHelper();

    @VisibleForTesting
    public void setAclEvaluate(AclEvaluate aclEvaluate) {
        this.aclEvaluate = aclEvaluate;
    }

    @VisibleForTesting
    public AclEvaluate getAclEvaluate() {
        return this.aclEvaluate;
    }

    @ApiOperation(value="dump ke inner metadata responding to system kylinconfig")
    @GetMapping(value={"/metadata/dump"})
    @ResponseBody
    public EnvelopeResponse<String> dumpMetadata(@RequestParam(value="dump_path") String dumpPath) throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        HDFSMetadataTool.cleanBeforeBackup((KylinConfig)kylinConfig);
        KylinConfig backupConfig = kylinConfig.getMetadataBackupFromSystem() ? kylinConfig : KylinConfig.createKylinConfig((KylinConfig)kylinConfig);
        this.metadataToolHelper.backup(backupConfig, null, dumpPath, null, true, false);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="diag", tags={"SM"})
    @PostMapping(value={"/diag"})
    @ResponseBody
    public EnvelopeResponse<String> getRemoteDumpDiagPackage(@RequestParam(value="host", required=false) String host, @RequestBody DiagPackageRequest diagPackageRequest, HttpServletRequest request) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)diagPackageRequest.getJobId())) {
            diagPackageRequest.setStart("");
            diagPackageRequest.setEnd("");
        } else if (StringUtils.isBlank((CharSequence)diagPackageRequest.getStart()) || StringUtils.isBlank((CharSequence)diagPackageRequest.getEnd())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_NOT_CONSISTENT, new Object[0]);
        }
        this.validateDataRange(diagPackageRequest.getStart(), diagPackageRequest.getEnd());
        if (StringUtils.isEmpty((CharSequence)host)) {
            String uuid = this.systemService.dumpLocalDiagPackage(diagPackageRequest.getStart(), diagPackageRequest.getEnd(), diagPackageRequest.getJobId(), diagPackageRequest.getProject());
            return new EnvelopeResponse("000", (Object)uuid, "");
        }
        String url = host + "/kylin/api/system/diag";
        return this.generateTaskForRemoteHost(request, url);
    }

    @ApiOperation(value="queryDiag", tags={"QE"})
    @PostMapping(value={"/diag/query"})
    @ResponseBody
    public EnvelopeResponse<String> getRemoteDumpQueryDiagPackage(@RequestParam(value="host", required=false) String host, @RequestBody QueryDiagPackageRequest queryDiagPackageRequest, HttpServletRequest request) throws Exception {
        if (StringUtils.isEmpty((CharSequence)host)) {
            String uuid = this.systemService.dumpLocalQueryDiagPackage(queryDiagPackageRequest.getQueryId(), queryDiagPackageRequest.getProject());
            return new EnvelopeResponse("000", (Object)uuid, "");
        }
        String url = host + "/kylin/api/system/diag/query";
        return this.generateTaskForRemoteHost(request, url);
    }

    @ApiOperation(value="diagProgress", tags={"SM"})
    @PutMapping(value={"/diag/progress"})
    @ResponseBody
    public EnvelopeResponse<String> updateDiagProgress(@RequestBody DiagProgressRequest diagProgressRequest) {
        this.systemService.updateDiagProgress(diagProgressRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PutMapping(value={"/roll_event_log"})
    @ResponseBody
    public EnvelopeResponse<String> rollEventLog() {
        if (ToolUtil.waitForSparderRollUp()) {
            return new EnvelopeResponse("000", (Object)"", "");
        }
        return new EnvelopeResponse("999", (Object)"", "Rollup sparder eventLog failed.");
    }

    @ApiOperation(value="diagStatus", tags={"SM"})
    @GetMapping(value={"/diag/status"})
    @ResponseBody
    public EnvelopeResponse<DiagStatusResponse> getRemotePackageStatus(@RequestParam(value="host", required=false) String host, @RequestParam(value="id") String id, @RequestParam(value="project", required=false) String project, HttpServletRequest request) throws Exception {
        if (StringUtils.isEmpty((CharSequence)host)) {
            return this.systemService.getExtractorStatus(id, project);
        }
        String url = host + "/kylin/api/system/diag/status?id=" + id;
        if (StringUtils.isNotEmpty((CharSequence)project)) {
            url = url + "&project=" + project;
        }
        return this.generateTaskForRemoteHost(request, url);
    }

    @ApiOperation(value="diagDownload", tags={"SM"})
    @GetMapping(value={"/diag"})
    @ResponseBody
    public void remoteDownloadPackage(@RequestParam(value="host", required=false) String host, @RequestParam(value="id") String id, @RequestParam(value="project", required=false) String project, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtils.isEmpty((CharSequence)host)) {
            this.setDownloadResponse(this.systemService.getDiagPackagePath(id, project), "application/octet-stream", response);
        } else {
            String url = host + "/kylin/api/system/diag?id=" + id;
            if (StringUtils.isNotEmpty((CharSequence)project)) {
                url = url + "&project=" + project;
            }
            this.downloadFromRemoteHost(request, url, response);
        }
    }

    @ApiOperation(value="cancelDiag", tags={"SM"})
    @DeleteMapping(value={"/diag"})
    @ResponseBody
    public EnvelopeResponse<String> remoteStopPackage(@RequestParam(value="host", required=false) String host, @RequestParam(value="id") String id, HttpServletRequest request) throws Exception {
        if (StringUtils.isEmpty((CharSequence)host)) {
            this.systemService.stopDiagTask(id);
            return new EnvelopeResponse("000", (Object)"", "");
        }
        String url = host + "/kylin/api/system/diag?id=" + id;
        return this.generateTaskForRemoteHost(request, url);
    }

    @ApiOperation(value="enterMaintenance", tags={"DW"})
    @PostMapping(value={"/maintenance_mode"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> setMaintenanceMode(@RequestBody MaintenanceModeRequest maintenanceModeRequest) {
        this.maintenanceModeService.setMaintenanceMode(maintenanceModeRequest.getReason());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="exitMaintenance", tags={"DW"})
    @DeleteMapping(value={"/maintenance_mode"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<String> unsetReadMode(@RequestParam(value="reason") String reason) {
        this.maintenanceModeService.unsetMaintenanceMode(reason);
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new EpochCheckBroadcastNotifier());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getMaintenance", tags={"DW"})
    @GetMapping(value={"/maintenance_mode"}, produces={"application/vnd.apache.kylin-v4+json"})
    @ResponseBody
    public EnvelopeResponse<MaintenanceModeResponse> getMaintenanceMode() throws Exception {
        return new EnvelopeResponse("000", (Object)this.maintenanceModeService.getMaintenanceMode(), "");
    }

    @ApiOperation(value="servers", tags={"DW"})
    @GetMapping(value={"/servers"})
    @ResponseBody
    public EnvelopeResponse<ServersResponse> getServers(@RequestParam(value="ext", required=false, defaultValue="false") boolean ext) {
        ServersResponse response = new ServersResponse();
        List servers = this.clusterManager.getServers();
        response.setStatus(this.maintenanceModeService.getMaintenanceMode());
        if (ext) {
            response.setServers(servers);
        } else {
            response.setServers(servers.stream().map(ServerInfoResponse::getHost).collect(Collectors.toList()));
        }
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="host", tags={"DW"})
    @GetMapping(value={"/host"})
    @ResponseBody
    public EnvelopeResponse<String> getHostname() {
        return new EnvelopeResponse("000", (Object)AddressUtil.getLocalInstance(), "");
    }

    @ApiOperation(value="reload metadata", tags={"MID"})
    @PostMapping(value={"/metadata/reload"})
    @ResponseBody
    public EnvelopeResponse<String> reloadMetadata() throws IOException {
        this.systemService.reloadMetadata();
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"/transaction/simulation"})
    @ResponseBody
    public EnvelopeResponse<String> simulateUnitOfWork(String project, int seconds) {
        this.aclEvaluate.checkProjectAdminPermission(project);
        if (KylinConfig.getInstanceFromEnv().isUnitOfWorkSimulationEnabled()) {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                long index;
                for (index = 0L; index < (long)seconds; ++index) {
                    Thread.sleep(1000L);
                }
                return index;
            }, (String)project);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"/transaction/simulation/insert_meta"})
    @ResponseBody
    public EnvelopeResponse<String> simulateInsertMeta(@RequestParam(value="count", required=false, defaultValue="5") int count, @RequestParam(value="sleepSec", required=false, defaultValue="20") long sleepSec) {
        if (KylinConfig.getInstanceFromEnv().isUnitOfWorkSimulationEnabled()) {
            List<String> projectList = IntStream.range(0, 5).mapToObj(i -> "simulation" + i).collect(Collectors.toList());
            projectList.forEach(p -> {
                if (CollectionUtils.isNotEmpty((Collection)this.projectService.getReadableProjects(p, true))) {
                    EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                        this.projectService.dropProject(p);
                        return null;
                    }, (String)p);
                }
            });
            log.debug("insert_meta begin to create project");
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").sleepMills(TimeUnit.SECONDS.toMillis(sleepSec)).processor(() -> {
                projectList.forEach(p -> this.projectService.createProject(p, new ProjectInstance()));
                return null;
            }).build());
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

